/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: AbstractOutputter.java,v 1.2 2008/01/04 21:44:30 sleeloy Exp $
 **********************************************************************/
package org.eclipse.cosmos.provisional.dr.drs.service.handler.common;

import java.util.ArrayList;
import java.util.List;


public abstract class AbstractOutputter implements IOutputter {

	protected IIDResolver idResolver;
	protected IOutputterContext context;
	public void initalize(IOutputterContext context, IParameters parameters)
			throws Exception {
		this.context = context;

	}

	public void setIdResolver(IIDResolver idResolver) {
		this.idResolver = idResolver;

	}
	
	public IOutputterParameters[] getInputParameters(){
		return null;
	}

	public List<IOutputterParameters> getInvalidInput(IParameters input) throws Exception {
		List<IOutputterParameters> returnList = new ArrayList<IOutputterParameters>();
		IOutputterParameters[] metaData = getInputParameters();
		if (metaData != null){
			for (int x = 0 ; x < metaData.length; x++){
				if (metaData[x].getType() == IOutputterParameters.REQUIRED_TYPE){
					if (input.getParameter(metaData[x].getName()) == null){
						returnList.add(metaData[x]);
					}
				}
			}
		}
		return returnList;
	}
	
}
