/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dr.internal.web.ui.viewer;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.cosmos.dr.internal.web.ui.viewer.Activator;
import org.eclipse.cosmos.dr.internal.web.ui.viewer.Messages;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebViewer {
    private static String host = "127.0.0.1";
    private static int port = 38284;
    private static IWebBrowser internalBrowser;
    private static boolean webStarted;

    static {
        webStarted = false;
    }

    private static synchronized void startWebApp() {
        if (WebViewer.checkUpdate()) {
            WebViewer.stopWebApp();
        }
        if (webStarted) {
            return;
        }
        try {
            WebViewer.start("viewertest");
        }
        catch (Exception exception) {}
    }

    private static void stopWebApp() {
        if (!webStarted) {
            return;
        }
        try {
            WebViewer.stop("viewertest");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void display(Map<String, String> params) throws CoreException {
        WebViewer.startWebApp();
        try {
            if (internalBrowser == null) {
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                try {
                    internalBrowser = support.createBrowser(null);
                }
                catch (PartInitException partInitException) {
                    return;
                }
            }
            try {
                Iterator<String> iter = params.keySet().iterator();
                String paramsString = "?func=directMDR";
                while (iter.hasNext()) {
                    paramsString = String.valueOf(paramsString) + "&";
                    String key = iter.next();
                    paramsString = String.valueOf(paramsString) + key + "=" + URLEncoder.encode(params.get(key), "UTF-8");
                }
                internalBrowser.openURL(new URL("http://" + host + ":" + port + "/" + "COSMOSUI" + "/index.jsp" + paramsString));
            }
            catch (PartInitException partInitException) {
            }
            catch (MalformedURLException malformedURLException) {}
        }
        catch (Exception exception) {
            throw new CoreException(Activator.createErrorStatus(Messages.getString("WebViewer.5")));
        }
    }

    public static boolean checkUpdate() {
        int newPort = -1;
        try {
            newPort = Integer.parseInt(Activator.getDefault().getPortPreference());
        }
        catch (Exception exception) {
            return false;
        }
        String newHost = Activator.getDefault().getHostPreference();
        return newPort != port || !host.equals(newHost);
    }

    public static void start(String webappName) throws CoreException {
        try {
            port = Integer.parseInt(Activator.getDefault().getPortPreference());
        }
        catch (Exception exception) {
            return;
        }
        host = Activator.getDefault().getHostPreference();
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        ((Dictionary)dict).put("http.port", new Integer(port));
        ((Dictionary)dict).put("http.host", host);
        ((Dictionary)dict).put("other.info", "org.eclipse.cosmos.dr.web.ui.viewer");
        try {
            JettyConfigurator.startServer((String)webappName, dict);
            WebViewer.ensureBundleStarted("org.eclipse.equinox.http.registry");
        }
        catch (BundleException e) {
            throw new CoreException(Activator.createErrorStatus(Messages.getString("WebViewer.6"), (Exception)((Object)e)));
        }
        catch (Exception e) {
            throw new CoreException(Activator.createErrorStatus(Messages.getString("WebViewer.7"), e));
        }
        webStarted = true;
    }

    public static void stop(String webappName) throws CoreException {
        try {
            JettyConfigurator.stopServer((String)webappName);
            webStarted = false;
        }
        catch (Exception e) {
            throw new CoreException(Activator.createErrorStatus(Messages.getString("WebViewer.8"), e));
        }
    }

    private static void ensureBundleStarted(String symbolicName) throws BundleException {
        Bundle bundle = Platform.getBundle((String)symbolicName);
        if (bundle != null && bundle.getState() == 4) {
            bundle.start(1);
        }
    }
}

