/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.MapParameterImpl;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.QueriesOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IIDResolver;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

/*
 * Exception performing whole class analysis ignored.
 */
public class QueriesOutputter
extends AbstractOutputter {
    public static final String NODECLASS = "nodeClass";
    protected String rootDir = "";
    protected String repoDir = "";

    public void initalize(IOutputterContext context, IParameters parameters) throws Exception {
        this.rootDir = context.getRealPath("queries");
        this.repoDir = context.getRealPath("queryRepository" + File.separator + "queries");
        super.initalize(context, parameters);
    }

    public void render(PrintWriter writer, IParameters input) throws Exception {
        String nodeClass = input.getParameter("nodeClass");
        String bundleName = this.context.getInitParameter("WIDGET_BUNDLE_NAME");
        String[] bundles = bundleName.split(",");
        ResourceBundle[] RESOURCE_BUNDLES = new ResourceBundle[bundles.length];
        for (int x = 0; x < bundles.length; ++x) {
            RESOURCE_BUNDLES[x] = ResourceBundle.getBundle(bundles[x]);
        }
        if (nodeClass != null) {
            String[] tags = nodeClass.split(",");
            int count = 0;
            writer.write("{");
            for (int y = 0; y < tags.length; ++y) {
                int x;
                String genRepoFilename;
                String genFilename = this.generateFilename(tags[y]);
                File[] files = new File[]{};
                File[] repoFiles = new File[]{};
                File fileExists = new File(genFilename);
                if (fileExists.exists() && fileExists.isDirectory()) {
                    1 fileFilter = new /* Unavailable Anonymous Inner Class!! */;
                    files = fileExists.listFiles((FileFilter)fileFilter);
                }
                if ((fileExists = new File(genRepoFilename = this.generateRepoFilename(tags[y]))).exists() && fileExists.isDirectory()) {
                    2 fileFilter = new /* Unavailable Anonymous Inner Class!! */;
                    repoFiles = fileExists.listFiles((FileFilter)fileFilter);
                }
                if (files.length <= 0 && repoFiles.length <= 0) continue;
                if (count > 0) {
                    writer.write(",");
                }
                writer.write("\"" + tags[y] + "\":[");
                int fileCount = 0;
                for (x = 0; x < files.length; ++x) {
                    if (fileCount > 0) {
                        writer.append(",");
                    }
                    this.generateJSON(files[x].getAbsolutePath(), (Writer)writer, RESOURCE_BUNDLES, true);
                    ++fileCount;
                }
                for (x = 0; x < repoFiles.length; ++x) {
                    if (fileCount > 0) {
                        writer.append(",");
                    }
                    this.generateJSON(repoFiles[x].getAbsolutePath(), (Writer)writer, RESOURCE_BUNDLES, false);
                    ++fileCount;
                }
                writer.write("]");
                ++count;
            }
            writer.write("}");
        } else {
            writer.write("[]");
        }
    }

    protected String generateFilename(String tag) {
        String[] tags = tag.split(" ");
        String newFileName = this.rootDir + File.separator;
        for (int x = 0; x < tags.length; ++x) {
            newFileName = newFileName + tags[x] + File.separator;
        }
        return newFileName;
    }

    protected String generateRepoFilename(String tag) {
        String[] tags = tag.split(" ");
        String newFileName = this.repoDir + File.separator;
        for (int x = 0; x < tags.length; ++x) {
            newFileName = newFileName + tags[x] + File.separator;
        }
        return newFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateQueryJSON(String filename, Writer writer) throws Exception {
        File file = new File(filename);
        if (file.isFile()) {
            writer.write(", query:\"");
            FileInputStream fis = null;
            ByteArrayOutputStream bos = null;
            try {
                int i;
                fis = new FileInputStream(filename);
                bos = new ByteArrayOutputStream();
                while ((i = fis.read()) != -1) {
                    bos.write(i);
                }
                fis.close();
                writer.write(QueriesOutputter.escapeForMarkup((byte[])bos.toByteArray()));
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            writer.write("\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateJSON(String filename, Writer writer, ResourceBundle[] RESOURCE_BUNDLE, boolean readonly) throws Exception {
        FileInputStream fis = null;
        writer.write("{readonly:" + readonly + ",meta:");
        try {
            int c;
            fis = new FileInputStream(filename);
            boolean macroStart = false;
            boolean macroStart2 = false;
            StringBuffer macroBuffer = null;
            while ((c = fis.read()) != -1) {
                if (macroStart) {
                    if ((char)c == '{') {
                        macroBuffer = new StringBuffer();
                        macroStart2 = true;
                    } else {
                        writer.write(36);
                        macroBuffer = null;
                    }
                    macroStart = false;
                }
                if ((char)c == '$') {
                    macroStart = true;
                }
                if (macroBuffer != null) {
                    if ((char)c == '}') {
                        String macroValue = "${" + macroBuffer.toString() + "}";
                        for (int x = 0; x < RESOURCE_BUNDLE.length; ++x) {
                            try {
                                macroValue = RESOURCE_BUNDLE[x].getString(macroBuffer.toString());
                                continue;
                            }
                            catch (MissingResourceException e) {
                                // empty catch block
                            }
                        }
                        if (macroValue == null) {
                            macroValue = "${" + macroBuffer.toString() + "}";
                        }
                        writer.write(macroValue);
                        macroBuffer = null;
                        continue;
                    }
                    if (!macroStart2) {
                        macroBuffer.append((char)c);
                        continue;
                    }
                    if (!macroStart2) continue;
                    macroStart2 = false;
                    continue;
                }
                if (macroStart) continue;
                writer.write(c);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        this.generateQueryJSON(filename.substring(0, filename.length() - "jprop".length()) + "query", writer);
        writer.write("}");
    }

    public static String escapeForMarkup(byte[] buffer) {
        if (buffer == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int len = buffer.length;
        block5: for (int i = 0; i < len; ++i) {
            char c = (char)buffer[i];
            switch (c) {
                case '\"': {
                    result.append("\\\"");
                    continue block5;
                }
                case '\r': {
                    continue block5;
                }
                case '\n': {
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public void setIdResolver(IIDResolver idResolver) {
    }

    public static final void main(String[] argv) throws Exception {
        PrintWriter pw = new PrintWriter(System.out);
        QueriesOutputter out = new QueriesOutputter();
        out.rootDir = "D:\\development\\wtp30\\eclipse\\workspace\\org.eclipse.cosmos.dr.tests.views\\WebContent\\queries";
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("nodeClass", "mdrExample");
        out.render(pw, (IParameters)new MapParameterImpl(input));
        pw.flush();
        pw.close();
    }
}

