/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.ReponseHistoryOutputter;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.SaverHelper;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

public class ReponseHistoryOutputter
extends AbstractOutputter {
    public static final String QUERY_ID = "uuid";
    protected String rootDir;

    public void initalize(IOutputterContext context, IParameters parameters) throws Exception {
        this.rootDir = context.getRealPath("queryRepository" + File.separator + "responses");
        super.initalize(context, parameters);
    }

    public void render(PrintWriter output, IParameters input) throws Exception {
        String uuid = input.getParameter(QUERY_ID);
        String genRepoFilename = this.rootDir + File.separator + uuid;
        File fileExists = new File(genRepoFilename);
        if (fileExists.exists() && fileExists.isDirectory()) {
            1 fileFilter = new /* Unavailable Anonymous Inner Class!! */;
            File[] repoFiles = SaverHelper.getSortedFileList((File)fileExists, (FilenameFilter)fileFilter);
            output.write("[");
            for (int x = 0; x < repoFiles.length; ++x) {
                if (x > 0) {
                    output.write(",");
                }
                this.generateResponseJSON(repoFiles[x], (Writer)output, uuid);
            }
            output.write("]");
        }
    }

    protected String generateTimeStamp(String timestamp, Locale locale) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(Long.parseLong(timestamp));
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", locale);
        return sdf.format(cal.getTime());
    }

    protected void generateResponseJSON(File file, Writer writer, String uuid) throws Exception {
        if (file.isFile()) {
            String timestamp = file.getName();
            int idx = timestamp.indexOf(".response");
            if (idx != -1) {
                timestamp = timestamp.substring(0, idx);
            }
            writer.write("{title:\"" + this.generateTimeStamp(timestamp, Locale.ENGLISH) + "\", instanceId:\"" + timestamp + "\", uuid:\"" + uuid + "\"}");
        }
    }

    public static String escapeForMarkup(byte[] buffer) {
        if (buffer == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int len = buffer.length;
        block5: for (int i = 0; i < len; ++i) {
            char c = (char)buffer[i];
            switch (c) {
                case '\"': {
                    result.append("\\\"");
                    continue block5;
                }
                case '\r': {
                    continue block5;
                }
                case '\n': {
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }
}

