/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.LoggerWrapper;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.OutputterDelegator;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractServletHandler;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IServletHandler;

public class URLDelegator
extends HttpServlet {
    static final long serialVersionUID = -5991590204597891023L;
    protected AbstractServletHandler outputter;
    protected List<IServletHandler> delegators;
    private static ILogger logger = LoggerWrapper.getLogger(URLDelegator.class);

    public URLDelegator() {
        this.setLogger();
    }

    public void init(ServletConfig config) throws ServletException {
        String delegatorStr = config.getServletContext().getInitParameter("DELEGATORS");
        if (delegatorStr != null) {
            String[] delegatorsStrings = delegatorStr.split(",");
            this.delegators = new ArrayList();
            for (int x = 0; x < delegatorsStrings.length; ++x) {
                try {
                    IServletHandler delegator = (IServletHandler)Class.forName(delegatorsStrings[x]).newInstance();
                    this.delegators.add(delegator);
                    delegator.init(config);
                    continue;
                }
                catch (InstantiationException e) {
                    logger.error((Object)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)e);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)e);
                }
            }
        }
        this.outputter = this.createOutputterDelegator();
        super.init(config);
        this.outputter.init(config);
    }

    protected AbstractServletHandler createOutputterDelegator() {
        return new OutputterDelegator();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        StringWriter sw = new StringWriter();
        this.outputter.doGet(req, sw);
        if (this.delegators != null) {
            for (int x = 0; x < this.delegators.size(); ++x) {
                ((IServletHandler)this.delegators.get(x)).doGet(req, sw);
            }
        }
        sw.flush();
        PrintWriter fw = resp.getWriter();
        fw.append(sw.getBuffer().toString());
        fw.close();
        sw.close();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        StringWriter sw = new StringWriter();
        this.outputter.doPost(req, sw);
        if (this.delegators != null) {
            for (int x = 0; x < this.delegators.size(); ++x) {
                ((IServletHandler)this.delegators.get(x)).doPost(req, sw);
            }
        }
        sw.flush();
        PrintWriter fw = resp.getWriter();
        fw.append(sw.getBuffer().toString());
        fw.close();
        sw.close();
    }

    protected void setLogger() {
        LoggerWrapper.setLogwrapper((LoggerWrapper)new LoggerWrapper());
    }
}

