/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.QueryOutputTransformer;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryServiceElementCollection;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IAdditionalRecordType;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecordMetadata;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.JSONArray;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.JSONObject;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.AbstractGraphResponse;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

public class GraphResponseTreeOutputter
extends AbstractGraphResponse {
    public void render(PrintWriter output, IParameters input) throws Exception {
        String queryResponse = input.getParameter("queryResponse");
        String historyId = input.getParameter("historyId");
        String uuid = input.getParameter("uuid");
        if (historyId != null) {
            queryResponse = super.loadFromHistory(uuid, historyId);
        }
        if (queryResponse != null) {
            IQueryResult queryResult = QueryOutputTransformer.transform((InputStream)new ByteArrayInputStream(queryResponse.getBytes()));
            this.writeLogicalJSON(output, queryResult);
        }
    }

    private void writeLogicalJSON(PrintWriter output, IQueryResult response) {
        JSONObject main = new JSONObject();
        main.put((Object)"label", (Object)"label");
        JSONArray elementsArray = new JSONArray();
        this.convertTemplates(elementsArray, response, response.getNodesIds(), true);
        this.convertTemplates(elementsArray, response, response.getEdgesIds(), false);
        main.put((Object)"items", (Object)elementsArray);
        output.println(main.toString());
    }

    private void convertTemplates(JSONArray store, IQueryResult response, String[] templateIds, boolean isItem) {
        String type = isItem ? "itemTemplate" : "relationshipTemplate";
        for (int i = 0; i < templateIds.length; ++i) {
            JSONObject templateObject = new JSONObject();
            templateObject.put((Object)"type", (Object)type);
            templateObject.put((Object)"label", (Object)templateIds[i]);
            templateObject.put((Object)"elements", (Object)this.convertElements((IQueryServiceElementCollection)(isItem ? response.getNodes(templateIds[i]) : response.getEdges(templateIds[i])), isItem));
            store.add((Object)templateObject);
        }
    }

    private JSONArray convertElements(IQueryServiceElementCollection elementCollection, boolean isItem) {
        JSONArray elementsArray = new JSONArray();
        IGraphElement[] elements = elementCollection.getElements();
        String type = isItem ? "item" : "relationship";
        for (int i = 0; i < elements.length; ++i) {
            JSONObject elementObject = new JSONObject();
            elementObject.put((Object)"type", (Object)type);
            elementObject.put((Object)"label", (Object)this.getFirstInstanceId(elements[i].getInstanceIds()));
            if (!isItem) {
                IRelationship relationship = (IRelationship)elements[i];
                this.addJSONEntries(elementObject, (String[][])new String[][]{{"source", this.getFirstInstanceId(new IInstanceId[]{relationship.getSourceId()})}, {"target", this.getFirstInstanceId(new IInstanceId[]{relationship.getTargetId()})}});
            }
            elementObject.put((Object)"instanceId", (Object)this.convertInstanceIds(elements[i]));
            elementObject.put((Object)"additionalRecords", (Object)this.convertAdditionalRecords(elements[i]));
            elementObject.put((Object)"records", (Object)this.convertRecords(elements[i]));
            elementsArray.add((Object)elementObject);
        }
        return elementsArray;
    }

    private JSONArray convertInstanceIds(IGraphElement graphElement) {
        IInstanceId[] instanceIds = graphElement.getInstanceIds();
        JSONArray instanceIdArray = new JSONArray();
        for (int i = 0; i < instanceIds.length; ++i) {
            JSONObject instanceIdObject = new JSONObject();
            instanceIdObject.put((Object)"mdrId", (Object)CMDBfServicesUtil.toString((URI)instanceIds[i].getMdrId()));
            instanceIdObject.put((Object)"localId", (Object)CMDBfServicesUtil.toString((URI)instanceIds[i].getLocalId()));
            instanceIdArray.add((Object)instanceIdObject);
        }
        return instanceIdArray;
    }

    private JSONArray convertAdditionalRecords(IGraphElement graphElement) {
        IAdditionalRecordType[] additionalRecords = graphElement.getAdditionalRecordTypes();
        JSONArray additionalRecordsArray = new JSONArray();
        for (int i = 0; i < additionalRecords.length; ++i) {
            JSONObject additionalRecordsObject = new JSONObject();
            additionalRecordsObject.put((Object)"namespace", (Object)CMDBfServicesUtil.toString((URI)additionalRecords[i].getNamespace()));
            additionalRecordsObject.put((Object)"localName", (Object)additionalRecords[i].getLocalName());
            additionalRecordsArray.add((Object)additionalRecordsObject);
        }
        return additionalRecordsArray;
    }

    private JSONArray convertRecords(IGraphElement graphElement) {
        IRecord[] records = graphElement.getRecords();
        JSONArray recordsArray = new JSONArray();
        for (int i = 0; i < records.length; ++i) {
            IRecordMetadata recordMetaData = records[i].getRecordMetadata();
            JSONObject recordsObject = new JSONObject();
            StringWriter sw = new StringWriter();
            records[i].getValue().toXML(sw, 0);
            String value = sw.getBuffer().toString();
            this.addJSONEntries(recordsObject, (String[][])new String[][]{{"type", "record"}, {"label", CMDBfServicesUtil.toString((URI)recordMetaData.getRecordId())}, {"lastModified", recordMetaData.getLastModified()}, {"snapId", recordMetaData.getSnapshotId()}, {"baseId", recordMetaData.getBaselineId()}, {"value", value}});
            recordsArray.add((Object)recordsObject);
        }
        return recordsArray;
    }

    private String getFirstInstanceId(IInstanceId[] instanceIds) {
        String localId = null;
        return instanceIds.length > 0 && instanceIds[0] != null && (localId = CMDBfServicesUtil.toString((URI)instanceIds[0].getLocalId())) != null && localId.length() > 0 ? localId : "unknown";
    }

    private void addJSONEntries(JSONObject jsonObject, String[][] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i][1] == null || values[i][1].length() <= 0) continue;
            jsonObject.put((Object)values[i][0], (Object)values[i][1]);
        }
    }

    public static void main(String[] args) throws Exception {
        GraphResponseTreeOutputter outputter = new GraphResponseTreeOutputter();
        IQueryResult result = QueryOutputTransformer.transform((InputStream)outputter.getClass().getClassLoader().getResourceAsStream("Staff02Students.xml"));
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        outputter.writeLogicalJSON(pw, result);
        System.out.println(sw.getBuffer());
    }
}

