/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.ReportDeploymentHandler;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

public class ReportDeployment
extends AbstractOutputter {
    protected IOutputterContext context;

    public void initalize(IOutputterContext context, IParameters parameters) throws Exception {
        super.initalize(context, parameters);
        this.context = context;
        this.setupReportContext(context);
    }

    public void render(PrintWriter output, IParameters input) throws Exception {
        String func = input.getParameter("func");
        if (func != null) {
            if (func.equals("list")) {
                this.generateReportList(output, input);
            }
            if (func.equals("datasource")) {
                this.datasource(output, input);
            } else if (func.equals("url")) {
                this.generateURL(output, input);
            }
        }
    }

    protected void generateReportList(PrintWriter out, IParameters input) throws ServletException, IOException {
        String reportURL = this.context.getInitParameter("COSMOS_REPORT_URL");
        Map parameters = input.getParameterMap();
        Iterator param = parameters.keySet().iterator();
        String paramStr = "";
        while (param.hasNext()) {
            Object key = param.next();
            if (key.equals("service")) continue;
            paramStr = paramStr + "&" + key + "=" + URLEncoder.encode(input.getParameter(key.toString()), "UTF-8");
        }
        this.sendRequest(reportURL + "/webcontent/report.jsp?func=list" + paramStr, out);
        out.close();
    }

    protected void sendRequest(String url, PrintWriter pw) throws IOException {
        URL netUrl = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)netUrl.openConnection();
        connection.setRequestMethod("GET");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        out.flush();
        out.close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String response = reader.readLine();
        while (null != response) {
            pw.write(response);
            response = reader.readLine();
        }
    }

    protected void sendPOSTRequest(String url, PrintWriter pw, String parameters) throws IOException {
        URL netUrl = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)netUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("Content-Length", "" + Integer.toString(parameters.getBytes().length));
        connection.setRequestProperty("Content-Language", "en-US");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        out.writeBytes(parameters);
        out.flush();
        out.close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String response = reader.readLine();
        while (null != response) {
            pw.write(response);
            response = reader.readLine();
        }
    }

    protected void generateURL(PrintWriter out, IParameters input) throws ServletException, IOException {
        String reportURL = this.context.getInitParameter("COSMOS_REPORT_URL");
        Map parameters = input.getParameterMap();
        Iterator param = parameters.keySet().iterator();
        String paramStr = "";
        int count = 0;
        while (param.hasNext()) {
            String key = (String)param.next();
            paramStr = count == 0 ? paramStr + "?" : paramStr + "&";
            paramStr = paramStr + key + "=" + input.getParameter(key.toString());
            ++count;
        }
        out.print(reportURL + "/webcontent/report.jsp" + paramStr);
        out.close();
    }

    protected void datasource(PrintWriter out, IParameters input) throws ServletException, IOException {
        String reportURL = this.context.getInitParameter("COSMOS_REPORT_URL");
        Map parameters = input.getParameterMap();
        Iterator param = parameters.keySet().iterator();
        String paramStr = "";
        int count = 0;
        while (param.hasNext()) {
            String key = (String)param.next();
            paramStr = count == 0 ? paramStr + "" : paramStr + "&";
            paramStr = paramStr + key + "=" + input.getParameter(key.toString());
            ++count;
        }
        this.sendPOSTRequest(reportURL + "/report.jsp", out, paramStr);
        out.close();
    }

    protected void setupReportContext(IOutputterContext context) throws ServletException {
        if (context.getStore().getAttribute("COSMOS_REPORT_REGISTRY") == null) {
            ReportDeploymentHandler rdh = new ReportDeploymentHandler();
            String filename = context.getInitParameter("COSMOS_REPORT_DEPLOYMENT_FILE");
            rdh.parse(context.getRealPath(filename));
            context.getStore().setAttribute("COSMOS_REPORT_TEMPLATE_LOOKUP", (Object)rdh);
        }
    }
}

