/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.ReportElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ReportDeploymentHandler {
    public static final String XPATHROOT = "/visualizationMetadata/visualization";
    protected Document doc;
    protected XPathFactory xpathFactory = XPathFactory.newInstance();

    public void parse(String filename) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.parse(filename);
        }
        catch (ParserConfigurationException e) {
            this.fatalError((Exception)e);
        }
        catch (SAXNotRecognizedException e) {
            this.fatalError((Exception)e);
        }
        catch (SAXNotSupportedException e) {
            this.fatalError((Exception)e);
        }
        catch (SAXException e) {
            this.fatalError((Exception)e);
        }
        catch (IOException e) {
            this.fatalError((Exception)e);
        }
    }

    protected void fatalError(Exception e) {
        e.printStackTrace();
    }

    public List<ReportElement> getReportElementByMetaData(Map<String, String> searchCriteria) {
        Iterator<String> searchIter = searchCriteria.keySet().iterator();
        String xpathCriteria = "";
        int x = 0;
        while (searchIter.hasNext()) {
            String key = searchIter.next();
            String value = searchCriteria.get(key);
            if (x > 0) {
                xpathCriteria = xpathCriteria + " and ";
            }
            xpathCriteria = xpathCriteria + "visualizationDescription/" + key + "/text()='" + value + "'";
            ++x;
        }
        try {
            XPath xpath = this.xpathFactory.newXPath();
            XPathExpression expr = xpath.compile("/visualizationMetadata/visualization[" + xpathCriteria + "]");
            NodeList list = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            ArrayList<ReportElement> returnList = new ArrayList<ReportElement>();
            for (int y = 0; y < list.getLength(); ++y) {
                returnList.add(new ReportElement((Element)list.item(y)));
            }
            return returnList;
        }
        catch (XPathExpressionException e) {
            this.fatalError((Exception)e);
            return null;
        }
    }

    public ReportElement getReportElementById(String id) {
        try {
            XPath xpath = this.xpathFactory.newXPath();
            XPathExpression expr = xpath.compile("/visualizationMetadata/visualization[visualizationId/localId/text()='" + id + "']");
            NodeList list = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            if (list != null && list.getLength() > 0) {
                return new ReportElement((Element)list.item(0));
            }
            return null;
        }
        catch (XPathExpressionException e) {
            this.fatalError((Exception)e);
            return null;
        }
    }

    public static NodeList getStringFromXPath(String xpathExpression, String xml) throws Exception {
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docbuilder = docfactory.newDocumentBuilder();
        Document docroot = docbuilder.parse(new InputSource(new StringReader(xml)));
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList resultNode = (NodeList)xpath.evaluate(xpathExpression, docroot, XPathConstants.NODESET);
        return resultNode;
    }

    public static String xmlToString(Node elem) throws Exception {
        StringWriter sw = new StringWriter();
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        serializer.transform(new DOMSource(elem), new StreamResult(sw));
        return sw.toString();
    }

    public static final void main(String[] argv) throws Exception {
        FileInputStream fis = new FileInputStream("D:\\development\\BIRT222\\eclipse\\workspace3\\GraphResponseProject\\response.xml");
        StringBuffer sb = new StringBuffer();
        int x = fis.available();
        byte[] b = new byte[x];
        fis.read(b);
        String content = new String(b);
        sb.append(content);
        String xml = sb.toString();
        NodeList resultNodeSet = ReportDeploymentHandler.getStringFromXPath((String)"/queryResult/nodes/item/record", (String)xml);
        for (int y = 0; y < resultNodeSet.getLength(); ++y) {
            Node resultNode = resultNodeSet.item(y);
            NamedNodeMap map = resultNode.getAttributes();
            Node node = map.getNamedItem("xmlns");
            System.out.println(ReportDeploymentHandler.xmlToString((Node)resultNode.getChildNodes().item(1)));
        }
    }
}

