/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.ps.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.cosmos.internal.dr.ps.common.ConfigurationItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements Map {
    protected static final String EQUAL = "=";
    protected static final String COMMENT = "#";
    protected static final String TITLE = "@title";
    protected static final String DESCRIPTION = "@description";
    protected static final String RESOURCE = "@resource";
    protected static final String NAME = "@name";
    protected Map<String, ConfigurationItem> map = new Hashtable();
    protected String title;

    public String getTitle() {
        return this.title;
    }

    public boolean load(InputStream reader) throws Exception {
        return this.load((Reader)new InputStreamReader(reader));
    }

    public boolean load(String filename) throws Exception {
        File file = new File(filename);
        if (!file.exists()) {
            return false;
        }
        return this.load((Reader)new FileReader(filename));
    }

    public boolean load(Reader reader) throws Exception {
        BufferedReader in = new BufferedReader(reader);
        String readLine = null;
        String description = null;
        ResourceBundle[] RESOURCE_BUNDLES = null;
        String name = null;
        while ((readLine = in.readLine()) != null) {
            int idx;
            if (readLine.trim().startsWith(COMMENT)) {
                idx = readLine.indexOf(RESOURCE);
                if (idx > 0) {
                    String bundleName = readLine.substring(idx + RESOURCE.length(), readLine.length());
                    String[] bundles = bundleName.split(",");
                    RESOURCE_BUNDLES = new ResourceBundle[bundles.length];
                    for (int x = 0; x < bundles.length; ++x) {
                        try {
                            RESOURCE_BUNDLES[x] = ResourceBundle.getBundle(bundles[x].trim());
                            continue;
                        }
                        catch (RuntimeException e) {
                            // empty catch block
                        }
                    }
                }
                if ((idx = readLine.indexOf(DESCRIPTION)) > 0) {
                    description = this.resolveMacro(readLine.substring(idx + DESCRIPTION.length(), readLine.length()), RESOURCE_BUNDLES);
                }
                if ((idx = readLine.indexOf(TITLE)) > 0) {
                    this.title = this.resolveMacro(readLine.substring(idx + TITLE.length(), readLine.length()), RESOURCE_BUNDLES);
                }
                if ((idx = readLine.indexOf(NAME)) <= 0) continue;
                name = this.resolveMacro(readLine.substring(idx + NAME.length(), readLine.length()), RESOURCE_BUNDLES);
                continue;
            }
            idx = readLine.indexOf(EQUAL);
            if (idx <= 0) continue;
            String attribute = readLine.substring(0, idx);
            String value = readLine.substring(idx + 1, readLine.length());
            this.map.put(attribute, new ConfigurationItem(description, name, attribute, value));
        }
        in.close();
        return true;
    }

    protected String resolveMacro(String line, ResourceBundle[] RESOURCE_BUNDLE) {
        boolean macroStart = false;
        boolean macroStart2 = false;
        StringBuffer macroBuffer = null;
        StringBuffer writer = new StringBuffer();
        char[] chars = line.toCharArray();
        for (int z = 0; z < chars.length; ++z) {
            char c = chars[z];
            if (macroStart) {
                if (c == '{') {
                    macroBuffer = new StringBuffer();
                    macroStart2 = true;
                } else {
                    writer.append('$');
                    macroBuffer = null;
                }
                macroStart = false;
            }
            if (c == '$') {
                macroStart = true;
            }
            if (macroBuffer != null) {
                if (c == '}') {
                    String macroValue = "";
                    if (RESOURCE_BUNDLE != null) {
                        for (int x = 0; x < RESOURCE_BUNDLE.length; ++x) {
                            try {
                                if (RESOURCE_BUNDLE[x] == null) continue;
                                macroValue = RESOURCE_BUNDLE[x].getString(macroBuffer.toString());
                                continue;
                            }
                            catch (MissingResourceException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (macroValue == null) {
                        macroValue = "";
                    }
                    writer.append(macroValue);
                    macroBuffer = null;
                    continue;
                }
                if (!macroStart2) {
                    macroBuffer.append(c);
                    continue;
                }
                if (!macroStart2) continue;
                macroStart2 = false;
                continue;
            }
            if (macroStart) continue;
            writer.append(c);
        }
        return writer.toString();
    }

    public void save(String filename) throws Exception {
        BufferedWriter out = new BufferedWriter(new FileWriter(filename));
        Iterator iter = this.map.keySet().iterator();
        out.write("# @title " + this.getTitle());
        out.newLine();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            ConfigurationItem ci = (ConfigurationItem)this.map.get(key);
            out.write("# @name " + ci.getDisplayName());
            out.newLine();
            out.write("# @description " + ci.getDescription());
            out.newLine();
            out.write(ci.getName() + EQUAL + ci.getValue());
            out.newLine();
        }
        out.close();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set<Map.Entry<String, ConfigurationItem>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.map).equals(o);
    }

    public ConfigurationItem get(Object key) {
        return (ConfigurationItem)this.map.get(key);
    }

    public String getValue(Object key) {
        ConfigurationItem ci = this.get(key);
        if (ci != null) {
            return ci.getValue();
        }
        return null;
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public ConfigurationItem put(String key, ConfigurationItem value) {
        return this.map.put(key, value);
    }

    public ConfigurationItem remove(Object key) {
        return (ConfigurationItem)this.map.remove(key);
    }

    public Object put(Object key, Object value) {
        return this.map.put((String)key, (ConfigurationItem)value);
    }

    public void putAll(Map t) {
        this.map.putAll(t);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public Collection<ConfigurationItem> values() {
        return this.map.values();
    }
}

