/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.FixIdentityImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.FixIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.MaintenanceInformation;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaintenanceInformationImpl
extends SPIDataObject
implements MaintenanceInformation {
    private static final String MAINTENANCE_INFORMATION_TYPE = "sdd-common:MaintenanceInformationType";

    public MaintenanceInformationImpl(Element element, SPISessionImpl session) {
        super(element, session, MAINTENANCE_INFORMATION_TYPE);
    }

    @Override
    public Collection<TranslatableString> getCategory() {
        ArrayList<TranslatableString> maintenanceCategories = new ArrayList<TranslatableString>();
        Collection<Element> maintenanceCategoryList = this.getChildren("Category");
        for (Element maintenanceCategory : maintenanceCategoryList) {
            maintenanceCategories.add(new TranslatableString(maintenanceCategory));
        }
        return maintenanceCategories;
    }

    @Override
    public Collection<FixIdentity> getFixIdentityDefinitions() {
        Collection<Element> fixList = this.getChildren("Fix");
        ArrayList<FixIdentity> fixes = new ArrayList<FixIdentity>();
        for (Element fixElement : fixList) {
            fixes.add(new FixIdentityImpl(fixElement, this.session));
        }
        return fixes;
    }

    @Override
    public TranslatableString getSeverity() {
        TranslatableString value = null;
        if (this.isSetElement("Severity")) {
            value = new TranslatableString(this.getChild("Severity"));
        }
        return value;
    }

    @Override
    public Collection<MaintenanceInformation> getSupersedes() {
        Collection<Element> supersedesList = this.getChildren("Supersedes");
        ArrayList<MaintenanceInformation> supersedes = new ArrayList<MaintenanceInformation>();
        for (Element supersede : supersedesList) {
            supersedes.add(new MaintenanceInformationImpl(supersede, this.session));
        }
        return supersedes;
    }

    @Override
    public void setCategory(Collection<TranslatableString> category) {
        if (category == null) {
            this.unSetElement("Category");
        } else {
            ArrayList<Element> categoryElements = new ArrayList<Element>();
            this.removeContent(this.getChildren("Category", false));
            for (TranslatableString categoryTs : category) {
                Element element = this.session.createCommonElement("Category");
                element.setTextContent(categoryTs.getValue());
                element.setAttribute("translationKey", categoryTs.getTranslationKey());
                categoryElements.add(element);
            }
            this.addContent(categoryElements);
        }
    }

    @Override
    public void setFixIdentityDefinitions(Collection<FixIdentity> fixIdentityDefinitions) {
        if (fixIdentityDefinitions == null) {
            this.unSetElement("Fix");
        } else {
            this.removeContent(this.getChildren("Fix", false));
            this.addContent(fixIdentityDefinitions);
        }
    }

    @Override
    public void setSeverity(TranslatableString severity) {
        if (severity == null) {
            this.unSetElement("Severity");
        } else {
            Element element = this.session.createCommonElement("Severity");
            element.setTextContent(severity.getValue());
            element.setAttribute("translationKey", severity.getTranslationKey());
            this.setContent(element);
        }
    }

    @Override
    public void setSupersedes(Collection<MaintenanceInformation> maintenanceInformation) {
        if (maintenanceInformation == null) {
            this.unSetElement("Supersedes");
        } else {
            this.removeContent(this.getChildren("Supersedes", false));
            this.addContent(maintenanceInformation);
        }
    }

    @Override
    public Object clone() {
        return new MaintenanceInformationImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

