/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.StringSubstitutionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.AdditionalContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.StringSubstitution;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdditionalContentImpl
extends SPIDataObject
implements AdditionalContent {
    private static final String ADDITIONAL_CONTENT_TYPE = "sdd-dd:AdditionalContentType";

    public AdditionalContentImpl(Element additionalContent, SPISessionImpl session) {
        super(additionalContent, session, ADDITIONAL_CONTENT_TYPE);
    }

    @Override
    public String getContentReference() {
        return this.isSetAttribute("contentRef") ? this.getAttribute("contentRef") : null;
    }

    @Override
    public String getType() {
        return this.isSetAttribute("type") ? this.getAttribute("type") : null;
    }

    @Override
    public Collection<StringSubstitution> getStringSubstitutions() {
        Collection<Element> substitutionElements = this.getChildren("Substitution");
        ArrayList<StringSubstitution> copiedSubstitutions = new ArrayList<StringSubstitution>();
        for (Element strSub : substitutionElements) {
            StringSubstitutionImpl temp = new StringSubstitutionImpl(strSub, this.session);
            copiedSubstitutions.add(temp);
        }
        return copiedSubstitutions;
    }

    @Override
    public void setContentReference(String contentReference) {
        this.session.testParameter(contentReference, 1, null);
        this.setAttribute("contentRef", contentReference);
    }

    @Override
    public void setType(String contentType) {
        if (contentType == null) {
            this.unSetAttribute("type");
        } else {
            this.setAttribute("type", contentType);
        }
    }

    @Override
    public void setStringSubstitutions(Collection<StringSubstitution> newStringSubstitutions) {
        if (newStringSubstitutions != null) {
            this.removeContent(this.getChildren("Substitution", false));
            this.addContent(newStringSubstitutions);
        } else {
            this.unSetElement("Substitution");
        }
    }

    @Override
    public Object clone() {
        Element copy = (Element)this.getElement().cloneNode(true);
        AdditionalContentImpl duplicate = new AdditionalContentImpl(copy, this.session);
        return duplicate;
    }
}

