/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionalResourceConstraintImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.AlternativeCondition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionalResourceConstraint;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternativeConditionImpl
extends NameableObject
implements AlternativeCondition {
    private static final String ALTERNATIVE_CONDITIONAL_TYPE = "sdd-dd:AlternativeConditionalType";

    public AlternativeConditionImpl(Element data, SPISessionImpl session) {
        super(data, session, ALTERNATIVE_CONDITIONAL_TYPE);
    }

    @Override
    public String getAlternativeConditionID() {
        return this.getAttribute("id");
    }

    @Override
    public Collection<ConditionalResourceConstraint> getConditionalResourceConstraints() {
        Collection<Element> constraintElements = this.getChildren("ResourceConstraint");
        ArrayList<ConditionalResourceConstraint> crcList = new ArrayList<ConditionalResourceConstraint>();
        for (Element element : constraintElements) {
            ConditionalResourceConstraintImpl temp = new ConditionalResourceConstraintImpl(element, this.session);
            crcList.add(temp);
        }
        return crcList;
    }

    @Override
    public void setAlternativeConditionID(String id) {
        this.session.testParameter(id, 1, null);
        this.setAttribute("id", id);
    }

    @Override
    public void setConditionalResourceConstraints(Collection<ConditionalResourceConstraint> crc) {
        this.session.testParameter(crc, 1, null);
        this.removeContent(this.getChildren("ResourceConstraint", false));
        this.addContent(crc);
    }

    @Override
    public Object clone() {
        return new AlternativeConditionImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

