/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DisplayNameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionalPropertyConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RelationshipConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.UniquenessConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.VersionConstraintImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionalPropertyConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionalResourceConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RelationshipConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.UniquenessConstraint;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalResourceConstraintImpl
extends DisplayNameableObject
implements ConditionalResourceConstraint {
    private static final String CONDITIONAL_RESOURCE_CONSTRAINT_TYPE = "sdd-dd:ConditionalResourceConstraintType";

    public ConditionalResourceConstraintImpl(Element data, SPISessionImpl session) {
        super(data, session, CONDITIONAL_RESOURCE_CONSTRAINT_TYPE);
    }

    @Override
    public String getName() {
        String value = null;
        if (this.isSetElement("Name")) {
            value = this.getChild("Name").getTextContent();
        }
        return value;
    }

    @Override
    public String getConstraintID() {
        return this.getAttribute("id");
    }

    @Override
    public String getResourceReference() {
        return this.getAttribute("resourceRef");
    }

    @Override
    public Boolean getTestValue() {
        String value = this.getAttribute("testValue");
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    @Override
    public Collection<VersionRange> getVersionRanges() {
        ArrayList<VersionRange> versionRanges = new ArrayList<VersionRange>();
        if (this.isSetElement("VersionConstraint")) {
            VersionConstraintImpl versionConstraint = new VersionConstraintImpl(this.getChild("VersionConstraint"), this.session);
            versionRanges.addAll(versionConstraint.getVersionRanges());
        }
        return versionRanges;
    }

    @Override
    public Collection<VersionValue> getVersionValues() {
        ArrayList<VersionValue> versionValues = new ArrayList<VersionValue>();
        if (this.isSetElement("VersionConstraint")) {
            VersionConstraintImpl versionConstraint = new VersionConstraintImpl(this.getChild("VersionConstraint"), this.session);
            versionValues.addAll(versionConstraint.getVersionValues());
        }
        return versionValues;
    }

    @Override
    public Collection<ConditionalPropertyConstraint> getConditionalMultiValuePropertyConstraints() {
        ArrayList<ConditionalPropertyConstraint> multiValueConstraints = new ArrayList<ConditionalPropertyConstraint>();
        if (this.isSetElement("PropertyConstraint")) {
            Collection<Element> constraintElements = this.getChildren("PropertyConstraint");
            for (Element constraint : constraintElements) {
                if (this.session.getChildren(constraint, "ListOfValues").isEmpty()) continue;
                multiValueConstraints.add(new ConditionalPropertyConstraintImpl(constraint, this.session));
            }
        }
        return multiValueConstraints;
    }

    @Override
    public Collection<ConditionalPropertyConstraint> getConditionalSingleValuePropertyConstraints() {
        ArrayList<ConditionalPropertyConstraint> singleValueConstraints = new ArrayList<ConditionalPropertyConstraint>();
        if (this.isSetElement("PropertyConstraint")) {
            Collection<Element> constraintElements = this.getChildren("PropertyConstraint");
            for (Element constraint : constraintElements) {
                if (this.session.getChildren(constraint, "Value").isEmpty()) continue;
                singleValueConstraints.add(new ConditionalPropertyConstraintImpl(constraint, this.session));
            }
        }
        return singleValueConstraints;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            Element nameElement = this.session.createDeploymentElement("Name");
            nameElement.setTextContent(name);
            this.setContent(nameElement);
        } else {
            this.unSetElement("Name");
        }
    }

    @Override
    public void setConstraintID(String id) {
        this.session.testParameter(id, 1, null);
        this.setAttribute("id", id);
    }

    @Override
    public void setResourceReference(String resourceReference) {
        this.session.testParameter(resourceReference, 1, null);
        this.setAttribute("resourceRef", resourceReference);
    }

    @Override
    public void setTestValue(Boolean testValue) {
        if (testValue != null) {
            this.setAttribute("testValue", testValue.toString());
        } else {
            this.unSetAttribute("testValue");
        }
    }

    @Override
    public void setVersionRanges(Collection<VersionRange> newVersionRanges) {
        if (!this.isSetElement("VersionConstraint")) {
            Element versionConstraintElement = this.session.createDeploymentElement("VersionConstraint");
            this.setContent(versionConstraintElement);
        }
        VersionConstraintImpl versionConstraint = new VersionConstraintImpl(this.getChild("VersionConstraint"), this.session);
        versionConstraint.setVersionRanges(newVersionRanges);
        this.setContent(versionConstraint);
    }

    @Override
    public void setVersionValues(Collection<VersionValue> newVersionValues) {
        if (!this.isSetElement("VersionConstraint")) {
            Element versionConstraintElement = this.session.createDeploymentElement("VersionConsrtaint");
            this.setContent(versionConstraintElement);
        }
        VersionConstraintImpl versionConstraint = new VersionConstraintImpl(this.getChild("VersionConstraint"), this.session);
        versionConstraint.setVersionValues(newVersionValues);
        this.setContent(versionConstraint);
    }

    @Override
    public void setConditionalMultiValuePropertyConstraints(Collection<ConditionalPropertyConstraint> propertyConstraints) {
        if (this.isSetElement("PropertyConstraint")) {
            Collection<Element> constraintElements = this.getChildren("PropertyConstraint", false);
            ArrayList<Element> multiValueElements = new ArrayList<Element>();
            for (Element constraint : constraintElements) {
                if (this.session.getChildren(constraint, "ListOfValues").isEmpty()) continue;
                multiValueElements.add(constraint);
            }
            this.removeContent(multiValueElements);
        }
        this.addContent(propertyConstraints);
    }

    @Override
    public void setConditionalSingleValuePropertyConstraints(Collection<ConditionalPropertyConstraint> propertyConstraints) {
        if (this.isSetElement("PropertyConstraint")) {
            Collection<Element> constraintElements = this.getChildren("PropertyConstraint", false);
            ArrayList<Element> singleValueElements = new ArrayList<Element>();
            for (Element constraint : constraintElements) {
                if (this.session.getChildren(constraint, "Value").isEmpty()) continue;
                singleValueElements.add(constraint);
            }
            this.removeContent(singleValueElements);
        }
        this.addContent(propertyConstraints);
    }

    @Override
    public Object clone() {
        return new ConditionalResourceConstraintImpl((Element)this.getElement().cloneNode(true), this.session);
    }

    @Override
    public Collection<RelationshipConstraint> getRelationshipConstraints() {
        ArrayList<RelationshipConstraint> relationshipConstraints = new ArrayList<RelationshipConstraint>();
        if (this.isSetElement("RelationshipConstraint")) {
            Collection<Element> relationshipElements = this.getChildren("RelationshipConstraint");
            for (Element constraint : relationshipElements) {
                relationshipConstraints.add(new RelationshipConstraintImpl(constraint, this.session));
            }
        }
        return relationshipConstraints;
    }

    @Override
    public Collection<UniquenessConstraint> getUniquenessConstraints() {
        ArrayList<UniquenessConstraint> uniquenessConstraints = new ArrayList<UniquenessConstraint>();
        if (this.isSetElement("UniquenessConstraint")) {
            Collection<Element> uniquenessElements = this.getChildren("UniquenessConstraint");
            for (Element constraint : uniquenessElements) {
                uniquenessConstraints.add(new UniquenessConstraintImpl(constraint, this.session));
            }
        }
        return uniquenessConstraints;
    }

    @Override
    public void setRelationshipConstraints(Collection<RelationshipConstraint> relationshipConstraints) {
        this.removeContent(this.getChildren("RelationshipConstraint", false));
        this.addContent(relationshipConstraints);
    }

    @Override
    public void setUniquenessConstraints(Collection<UniquenessConstraint> uniquenessConstraints) {
        this.removeContent(this.getChildren("UniquenessConstraint", false));
        this.addContent(uniquenessConstraints);
    }
}

