/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ReferencedPackageImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.CompletionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ContentUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.LanguageImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.LocalizationUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ResultingResourceImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase.RequiredBaseImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RequirementImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeLocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeLocalizationUnitImpl
extends ContentUnitImpl
implements CompositeLocalizationUnit {
    private static final String COMPOSITE_LOCALIZATION_UNIT_TYPE = "sdd-dd:CompositeLocalizationUnitType";
    private static final String REQUIREMENTS_TYPE = "sdd-dd:RequirementsType";
    private static final String LANGUAGES_TYPE = "sdd-dd:LanguagesType";

    public CompositeLocalizationUnitImpl(Element data, SPISessionImpl session) {
        super(data, session, COMPOSITE_LOCALIZATION_UNIT_TYPE);
    }

    @Override
    public Collection<Completion> getCompletions() {
        Collection<Element> completionElements = this.getChildren("Completion");
        ArrayList<Completion> completions = new ArrayList<Completion>();
        for (Element element : completionElements) {
            completions.add(new CompletionImpl(element, this.session));
        }
        return completions;
    }

    @Override
    public Collection<CompositeLocalizationUnit> getCompositeLocalizationUnits() {
        Collection<Element> cluElements = this.getChildren("CompositeLocalizationUnit");
        ArrayList<CompositeLocalizationUnit> compositeLocalizationUnits = new ArrayList<CompositeLocalizationUnit>();
        for (Element element : cluElements) {
            compositeLocalizationUnits.add(new CompositeLocalizationUnitImpl(element, this.session));
        }
        return compositeLocalizationUnits;
    }

    @Override
    public Condition getCondition() {
        ConditionImpl c = null;
        if (this.isSetElement("Condition")) {
            c = new ConditionImpl(this.getChild("Condition"), this.session);
        }
        return c;
    }

    @Override
    public Collection<ReferencedPackage> getContainedLocalizationPackages() {
        Collection<Element> containedLocalizationPackageElements = this.getChildren("ContainedLocalizationPackage");
        ArrayList<ReferencedPackage> containedLocalizationPackages = new ArrayList<ReferencedPackage>();
        for (Element element : containedLocalizationPackageElements) {
            containedLocalizationPackages.add(new ReferencedPackageImpl(element, this.session));
        }
        return containedLocalizationPackages;
    }

    @Override
    public RequiredBase getLocalizationBase() {
        RequiredBaseImpl localizationBase = null;
        if (this.isSetElement("LocalizationBase")) {
            localizationBase = new RequiredBaseImpl(this.getChild("LocalizationBase"), this.session);
        }
        return localizationBase;
    }

    @Override
    public Collection<LocalizationUnit> getLocalizationUnits() {
        Collection<Element> localizationUnitElements = this.getChildren("LocalizationUnit");
        ArrayList<LocalizationUnit> localizationUnits = new ArrayList<LocalizationUnit>();
        for (Element element : localizationUnitElements) {
            localizationUnits.add(new LocalizationUnitImpl(element, this.session));
        }
        return localizationUnits;
    }

    @Override
    public RequiredBase getRequiredBase() {
        RequiredBaseImpl requiredBase = null;
        if (this.isSetElement("RequiredBase")) {
            requiredBase = new RequiredBaseImpl(this.getChild("RequiredBase"), this.session);
        }
        return requiredBase;
    }

    @Override
    public Collection<Requirement> getRequirements() {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        if (this.isSetElement("Requirements")) {
            Collection<Element> requirementElementList = this.session.getChildren(this.getChild("Requirements"), "Requirement");
            for (Element element : requirementElementList) {
                requirements.add(new RequirementImpl(element, this.session));
            }
        } else {
            requirements = new ArrayList();
        }
        return requirements;
    }

    @Override
    public Collection<ResultingResource> getResultingResources() {
        Collection<Element> resultingResourceElements = this.getChildren("ResultingResource");
        ArrayList<ResultingResource> resultingResources = new ArrayList<ResultingResource>();
        for (Element element : resultingResourceElements) {
            resultingResources.add(new ResultingResourceImpl(element, this.session));
        }
        return resultingResources;
    }

    @Override
    public Collection<Language> getLanguages() {
        ArrayList<Language> languages = new ArrayList<Language>();
        if (this.isSetElement("Languages")) {
            Collection<Element> languageElementList = this.session.getChildren(this.getChild("Languages"), "Language");
            for (Element element : languageElementList) {
                languages.add(new LanguageImpl(element, this.session));
            }
        } else {
            languages = new ArrayList();
        }
        return languages;
    }

    @Override
    public void setCompletions(Collection<Completion> completions) {
        if (completions != null && !completions.isEmpty()) {
            this.removeContent(this.getChildren("Completion", false));
            this.addContent(completions);
        } else {
            this.removeContent(this.getChildren("Completion", false));
        }
    }

    @Override
    public void setCompositeLocalizationUnits(Collection<CompositeLocalizationUnit> localizationUnits) {
        this.session.testParameter(localizationUnits, 1, null);
        if (localizationUnits != null && !localizationUnits.isEmpty()) {
            this.removeContent(this.getChildren("CompositeLocalizationUnit", false));
            this.addContent(localizationUnits);
        } else {
            this.removeContent(this.getChildren("CompositeLocalizationUnit", false));
        }
    }

    @Override
    public void setCondition(Condition condition) {
        if (condition == null) {
            this.unSetElement("Condition");
        } else {
            this.setContent((SPIDataObject)((Object)condition));
        }
    }

    @Override
    public void setContainedLocalizationPackages(Collection<ReferencedPackage> packages) {
        if (this.getLocalizationUnits().isEmpty() && this.getCompositeLocalizationUnits().isEmpty()) {
            this.session.testParameter(packages, 1, null);
        }
        if (packages != null && !packages.isEmpty()) {
            this.removeContent(this.getChildren("ContainedLocalizationPackage", false));
            this.addContent(packages);
        } else {
            this.removeContent(this.getChildren("ContainedLocalizationPackage", false));
        }
    }

    @Override
    public void setLocalizationBase(RequiredBase localizationBase) {
        if (localizationBase == null) {
            this.unSetElement("LocalizationBase");
        } else {
            this.setContent((SPIDataObject)((Object)localizationBase));
        }
    }

    @Override
    public void setLocalizationUnits(Collection<LocalizationUnit> localizationUnits) {
        if (this.getContainedLocalizationPackages().isEmpty() && this.getCompositeLocalizationUnits().isEmpty()) {
            this.session.testParameter(localizationUnits, 1, null);
        }
        if (localizationUnits != null && !localizationUnits.isEmpty()) {
            this.removeContent(this.getChildren("LocalizationUnit", false));
            this.addContent(localizationUnits);
        } else {
            this.removeContent(this.getChildren("LocalizationUnit", false));
        }
    }

    @Override
    public void setRequiredBase(RequiredBase requiredBase) {
        if (requiredBase == null) {
            this.unSetElement("RequiredBase");
        } else {
            this.setContent((SPIDataObject)((Object)requiredBase));
        }
    }

    @Override
    public void setRequirements(Collection<Requirement> requirements) {
        if (requirements != null && !requirements.isEmpty()) {
            Element requirementsDataObject = this.isSetElement("Requirements") ? this.getChild("Requirements") : this.session.createDeploymentElement("Requirements");
            Collection<Element> requirementNodeList = this.session.getChildren(requirementsDataObject, "Requirement");
            for (Element element : requirementNodeList) {
                requirementsDataObject.removeChild(element);
            }
            for (Requirement requirement : requirements) {
                this.session.insertNode((Node)requirementsDataObject, (SPIDataObject)((Object)requirement), REQUIREMENTS_TYPE);
            }
            this.setContent(requirementsDataObject);
        } else {
            this.unSetElement("Requirements");
        }
    }

    @Override
    public void setResultingResources(Collection<ResultingResource> resources) {
        if (resources != null && !resources.isEmpty()) {
            this.removeContent(this.getChildren("ResultingResource", false));
            this.addContent(resources);
        } else {
            this.removeContent(this.getChildren("ResultingResource", false));
        }
    }

    @Override
    public void setLanguages(Collection<Language> languages) {
        if (languages != null && !languages.isEmpty()) {
            Element languagesElement = this.isSetElement("Languages") ? this.getChild("Languages") : this.session.createDeploymentElement("Languages");
            Collection<Element> languageNodeList = this.session.getChildren(languagesElement, "Language");
            for (Element element : languageNodeList) {
                languagesElement.removeChild(element);
            }
            for (Language language : languages) {
                this.session.insertNode((Node)languagesElement, (SPIDataObject)((Object)language), LANGUAGES_TYPE);
            }
            this.setContent(languagesElement);
        } else {
            this.unSetElement("Languages");
        }
    }

    @Override
    public Object clone() {
        return new CompositeLocalizationUnitImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

