/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ReferencedPackageImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ConfigurationUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ContentUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.InstallableUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RequirementImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeUnitImpl
extends ContentUnitImpl
implements CompositeUnit {
    private static final String COMPOSITE_UNIT_TYPE = "sdd-dd:CompositeUnitType";
    private static final String REQUIREMENTS_TYPE = "sdd-dd:RequirementsType";

    public CompositeUnitImpl(Element data, SPISessionImpl session) {
        super(data, session, COMPOSITE_UNIT_TYPE);
    }

    @Override
    public Collection<CompositeUnit> getCompositeUnits() {
        Collection<Element> compositeUnitElements = this.getChildren("CompositeUnit");
        ArrayList<CompositeUnit> compositeUnits = new ArrayList<CompositeUnit>();
        for (Element element : compositeUnitElements) {
            compositeUnits.add(new CompositeUnitImpl(element, this.session));
        }
        return compositeUnits;
    }

    @Override
    public Condition getCondition() {
        ConditionImpl c = null;
        if (this.isSetElement("Condition")) {
            c = new ConditionImpl(this.getChild("Condition"), this.session);
        }
        return c;
    }

    @Override
    public Collection<ConfigurationUnit> getConfigurationUnits() {
        Collection<Element> configurationUnitElements = this.getChildren("ConfigurationUnit");
        ArrayList<ConfigurationUnit> configurationUnit = new ArrayList<ConfigurationUnit>();
        for (Element element : configurationUnitElements) {
            configurationUnit.add(new ConfigurationUnitImpl(element, this.session));
        }
        return configurationUnit;
    }

    @Override
    public Collection<ReferencedPackage> getContainedPackages() {
        Collection<Element> containedPackageElements = this.getChildren("ContainedPackage");
        ArrayList<ReferencedPackage> containedPackages = new ArrayList<ReferencedPackage>();
        for (Element element : containedPackageElements) {
            containedPackages.add(new ReferencedPackageImpl(element, this.session));
        }
        return containedPackages;
    }

    @Override
    public Collection<InstallableUnit> getInstallableUnits() {
        Collection<Element> installableUnitElements = this.getChildren("InstallableUnit");
        ArrayList<InstallableUnit> installableUnits = new ArrayList<InstallableUnit>();
        for (Element element : installableUnitElements) {
            installableUnits.add(new InstallableUnitImpl(element, this.session));
        }
        return installableUnits;
    }

    @Override
    public Collection<Requirement> getRequirements() {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        if (this.isSetElement("Requirements")) {
            Collection<Element> requirementElementList = this.session.getChildren(this.getChild("Requirements"), "Requirement");
            for (Element element : requirementElementList) {
                requirements.add(new RequirementImpl(element, this.session));
            }
        }
        return requirements;
    }

    @Override
    public void setCompositeUnits(Collection<CompositeUnit> compositeUnits) {
        if (compositeUnits != null && !compositeUnits.isEmpty()) {
            this.removeContent(this.getChildren("CompositeUnit", false));
            this.addContent(compositeUnits);
        } else {
            this.removeContent(this.getChildren("CompositeUnit", false));
        }
    }

    @Override
    public void setCondition(Condition condition) {
        if (condition == null) {
            this.unSetElement("Condition");
        } else {
            this.setContent((SPIDataObject)((Object)condition));
        }
    }

    @Override
    public void setConfigurationUnits(Collection<ConfigurationUnit> configurationUnits) {
        if (configurationUnits != null && !configurationUnits.isEmpty()) {
            this.removeContent(this.getChildren("ConfigurationUnit", false));
            this.addContent(configurationUnits);
        } else {
            this.removeContent(this.getChildren("ConfigurationUnit", false));
        }
    }

    @Override
    public void setContainedPackages(Collection<ReferencedPackage> containedPackages) {
        if (containedPackages != null && !containedPackages.isEmpty()) {
            this.removeContent(this.getChildren("ContainedPackage", false));
            this.addContent(containedPackages);
        } else {
            this.removeContent(this.getChildren("ContainedPackage", false));
        }
    }

    @Override
    public void setInstallableUnits(Collection<InstallableUnit> installableUnits) {
        if (installableUnits != null && !installableUnits.isEmpty()) {
            this.removeContent(this.getChildren("InstallableUnit", false));
            this.addContent(installableUnits);
        } else {
            this.removeContent(this.getChildren("InstallableUnit", false));
        }
    }

    @Override
    public void setRequirements(Collection<Requirement> requirements) {
        if (requirements != null && !requirements.isEmpty()) {
            Element requirementsElement = this.isSetElement("Requirements") ? this.getChild("Requirements") : this.session.createDeploymentElement("Requirements");
            Collection<Element> requirementNodeList = this.session.getChildren(requirementsElement, "Requirement");
            for (Element element : requirementNodeList) {
                requirementsElement.removeChild(element);
            }
            for (Requirement requirement : requirements) {
                this.session.insertNode((Node)requirementsElement, (SPIDataObject)((Object)requirement), REQUIREMENTS_TYPE);
            }
            this.setContent(requirementsElement);
        } else {
            this.unSetElement("Requirements");
        }
    }

    @Override
    public Object clone() {
        return new CompositeUnitImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

