/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DisplayNameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Group;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupImpl
extends DisplayNameableObject
implements Group {
    private static final String GROUP_TYPE = "sdd-dd:GroupType";

    public GroupImpl(Element data, SPISessionImpl session) {
        super(data, session, GROUP_TYPE);
    }

    @Override
    public Boolean getDefault() {
        return new Boolean(this.getAttribute("default"));
    }

    @Override
    public String getGroupID() {
        return this.getAttribute("id");
    }

    @Override
    public Collection<String> getSelectedFeatures() {
        Collection<Element> selectedFeatureElements = this.getChildren("SelectedFeature");
        ArrayList<String> features = new ArrayList<String>();
        for (Element element : selectedFeatureElements) {
            String featureRef = element.getAttribute("featureRef");
            if (featureRef.length() == 0) {
                featureRef = null;
            }
            features.add(featureRef);
        }
        return features;
    }

    @Override
    public void setDefault(Boolean value) {
        if (value == null) {
            this.unSetAttribute("default");
        } else {
            this.setAttribute("default", value.toString());
        }
    }

    @Override
    public void setGroupID(String id) {
        this.session.testParameter(id, 1, null);
        this.setAttribute("id", id);
    }

    @Override
    public void setSelectedFeatures(Collection<String> refs) {
        this.session.testParameter(refs, 1, null);
        this.removeContent(this.getChildren("SelectedFeature", false));
        ArrayList<Element> selectedFeatures = new ArrayList<Element>();
        if (refs != null && !refs.isEmpty()) {
            for (String s : refs) {
                Element sf = this.session.createDeploymentElement("SelectedFeature");
                sf.setAttribute("featureRef", s);
                selectedFeatures.add(sf);
            }
            this.addContent(selectedFeatures);
        }
    }

    @Override
    public Object clone() {
        return new GroupImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

