/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.util.ConversionUtil;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Relationship;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RelationshipImpl
extends SPIDataObject
implements Relationship {
    private static final String RELATIONSHIP_TYPE = "sdd-dd:RelationshipType";
    private static final String PROPERTY_TYPE = "sdd-dd:PropertyType";

    public RelationshipImpl(Element rdo, SPISessionImpl session) {
        super(rdo, session, RELATIONSHIP_TYPE);
    }

    public Properties getProperties() {
        Collection<Element> propertyElements = this.getChildren("Property");
        return ConversionUtil.getPropertiesFromPropertyElementList(propertyElements);
    }

    public String getRelatedResourceReference() {
        return this.getAttribute("relatedResourceRef");
    }

    public String getType() {
        return this.getAttribute("type");
    }

    public void setProperties(Properties props) {
        if (props != null) {
            ArrayList<Element> properties = new ArrayList<Element>();
            this.removeContent(this.getChildren("Property", false));
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = props.getProperty(key);
                Element propertyElement = this.session.createDeploymentElement("Property");
                Element propertyNameElement = this.session.createDeploymentElement("PropertyName");
                Element valueElement = this.session.createDeploymentElement("Value");
                propertyNameElement.setTextContent(key);
                valueElement.setTextContent(value);
                this.session.insertNode((Node)propertyElement, (Node)propertyNameElement, PROPERTY_TYPE);
                this.session.insertNode((Node)propertyElement, (Node)valueElement, PROPERTY_TYPE);
                properties.add(propertyElement);
            }
            this.addContent(properties);
        } else {
            this.unSetElement("Property");
        }
    }

    public void setRelatedResourceReference(String ref) {
        this.session.testParameter(ref, 1, null);
        this.setAttribute("relatedResourceRef", ref);
    }

    public void setType(String type) {
        this.session.testParameter(type, 1, null);
        this.setAttribute("type", type);
    }

    public Object clone() {
        return new RelationshipImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

