/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.RelationshipImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.util.ConversionUtil;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Relationship;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingChange;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultingChangeImpl
extends DescribableObject
implements ResultingChange {
    private static final String RESULTING_CHANGE_TYPE = "sdd-dd:ResultingChangeType";
    private static final String RESULTING_PROPERTY_TYPE = "sdd-dd:ResultingPropertyType";

    public ResultingChangeImpl(Element data, SPISessionImpl session) {
        super(data, session, RESULTING_CHANGE_TYPE);
    }

    @Override
    public String getName() {
        String name = null;
        if (this.isSetElement("Name")) {
            name = this.getChild("Name").getTextContent();
        }
        return name;
    }

    @Override
    public Properties getProperties() {
        Collection<Element> propertyElements = this.getChildren("Property");
        return ConversionUtil.getPropertiesFromPropertyElementList(propertyElements);
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            this.unSetElement("Name");
        } else {
            Element nameElement = this.session.createDeploymentElement("Name");
            nameElement.setTextContent(name);
            this.setContent(nameElement);
        }
    }

    @Override
    public void setProperties(Properties newResultingChangeProperties) {
        if (newResultingChangeProperties != null) {
            ArrayList<Element> properties = new ArrayList<Element>();
            this.removeContent(this.getChildren("Property", false));
            Enumeration<Object> e = newResultingChangeProperties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = newResultingChangeProperties.getProperty(key);
                Element propertyElement = this.session.createDeploymentElement("Property");
                Element propertyNameElement = this.session.createDeploymentElement("PropertyName");
                Element valueElement = this.session.createDeploymentElement("Value");
                propertyNameElement.setTextContent(key);
                valueElement.setTextContent(value);
                this.session.insertNode((Node)propertyElement, (Node)propertyNameElement, RESULTING_PROPERTY_TYPE);
                this.session.insertNode((Node)propertyElement, (Node)valueElement, RESULTING_PROPERTY_TYPE);
                properties.add(propertyElement);
            }
            this.addContent(properties);
        } else {
            this.unSetElement("Property");
        }
    }

    @Override
    public Object clone() {
        return new ResultingChangeImpl((Element)this.getElement().cloneNode(true), this.session);
    }

    @Override
    public Condition getCondition() {
        ConditionImpl condition = null;
        if (this.isSetElement("Condition")) {
            condition = new ConditionImpl(this.getChild("Condition"), this.session);
        }
        return condition;
    }

    @Override
    public Collection<Relationship> getRelationships() {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        Collection<Element> relationshipElements = this.getChildren("Relationship");
        for (Element relationshipElement : relationshipElements) {
            relationships.add(new RelationshipImpl(relationshipElement, this.session));
        }
        return relationships;
    }

    @Override
    public void setCondition(Condition condition) {
        if (condition == null) {
            this.unSetElement("Condition");
        } else {
            this.setContent((SPIDataObject)((Object)condition));
        }
    }

    @Override
    public void setRelationships(Collection<Relationship> relationships) {
        if (relationships == null) {
            this.unSetElement("Relationship");
        } else {
            this.removeContent(this.getChildren("Relationship", false));
            this.addContent(relationships);
        }
    }
}

