/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase.AlternativeRequiredBaseConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase.RequiredBaseImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.AlternativeRequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseFactory;
import org.w3c.dom.Element;

public class RequiredBaseFactoryImpl
implements RequiredBaseFactory {
    private SPISessionImpl session;

    public RequiredBaseFactoryImpl(SPISessionImpl session) {
        this.session = session;
    }

    public AlternativeRequiredBaseConstraint createAlternativeRequiredBaseConstraint(String id) throws InvalidInputException {
        if (id == null && this.session.isErrorCheckingEnabled()) {
            throw new InvalidInputException(1, 0);
        }
        Element arbcElement = this.session.createDeploymentElement("Alternative");
        if (id != null) {
            arbcElement.setAttribute("id", id);
        }
        return new AlternativeRequiredBaseConstraintImpl(arbcElement, this.session);
    }

    public RequiredBase createRequiredBase() {
        return this.createRequiredBase("RequiredBase");
    }

    public RequiredBase createLocalizationBase() {
        return this.createRequiredBase("LocalizationBase");
    }

    private RequiredBase createRequiredBase(String tagName) {
        return new RequiredBaseImpl(this.session.createDeploymentElement(tagName), this.session);
    }

    public RequiredBaseConstraint createRequiredBaseConstraint(String id, String resourceReference) throws InvalidInputException {
        if (id == null && this.session.isErrorCheckingEnabled()) {
            throw new InvalidInputException(1, 0);
        }
        if (resourceReference == null && this.session.isErrorCheckingEnabled()) {
            throw new InvalidInputException(2, 0);
        }
        Element rbcElement = this.session.createDeploymentElement("ResourceConstraint");
        if (id != null) {
            rbcElement.setAttribute("id", id);
        }
        if (resourceReference != null) {
            rbcElement.setAttribute("resourceRef", resourceReference);
        }
        return new RequiredBaseConstraintImpl(rbcElement, this.session);
    }
}

