/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.PropertyValueListImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.PropertyConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.PropertyValueList;
import org.w3c.dom.Element;

public class PropertyConstraintImpl
extends DescribableObject
implements PropertyConstraint {
    private static final String PROPERTY_CONSTRAINT_TYPE = "sdd-dd:PropertyConstraintType";

    public PropertyConstraintImpl(Element data, SPISessionImpl session) {
        super(data, session, PROPERTY_CONSTRAINT_TYPE);
        if (!this.isSetElement("PropertyName")) {
            Element propNameElement = session.createDeploymentElement("PropertyName");
            propNameElement.setTextContent("DEFAULT_PROPERTY_NAME");
            this.setContent(propNameElement);
        }
    }

    public String getPropertyName() {
        return this.isSetElement("PropertyName") ? this.getChild("PropertyName").getTextContent() : null;
    }

    public void setPropertyName(String propertyName) {
        this.session.testParameter(propertyName, 1, null);
        if (propertyName == null) {
            this.unSetElement("PropertyName");
        } else {
            Element propNameElement = this.session.createDeploymentElement("PropertyName");
            propNameElement.setTextContent(propertyName);
            this.setContent(propNameElement);
        }
    }

    public String getValue() {
        return this.isSetElement("Value") ? this.getChild("Value").getTextContent() : null;
    }

    public void setValue(String value) {
        this.session.testParameter(value, 1, null);
        if (value == null) {
            this.unSetElement("Value");
        } else {
            Element propNameElement = this.session.createDeploymentElement("Value");
            propNameElement.setTextContent(value);
            this.setContent(propNameElement);
        }
    }

    public PropertyValueList getValueList() {
        PropertyValueListImpl valueList = null;
        if (this.isSetElement("ListOfValues")) {
            Element valueListElement = this.getChild("ListOfValues");
            valueList = new PropertyValueListImpl(valueListElement, this.session);
        }
        return valueList;
    }

    public void setValueList(PropertyValueList value) {
        this.session.testParameter(value, 1, null);
        if (value == null) {
            this.unSetElement("ListOfValues");
        } else {
            this.setContent(((SPIDataObject)((Object)value)).getElement());
        }
    }
}

