/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DisplayNameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.CapacityConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.ConsumptionConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.PropertyConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RelationshipConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.UniquenessConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.VersionConstraintImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.CapacityConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.ConsumptionConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.PropertyConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RelationshipConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.UniquenessConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.VersionConstraint;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementResourceConstraintImpl
extends DisplayNameableObject
implements RequirementResourceConstraint {
    private static final String REQUIREMENT_RESOURCE_CONSTRAINT_TYPE = "sdd-dd:RequirementResourceConstraintType";

    public RequirementResourceConstraintImpl(Element data, SPISessionImpl session) {
        super(data, session, REQUIREMENT_RESOURCE_CONSTRAINT_TYPE);
    }

    @Override
    public String getName() {
        return this.isSetElement("Name") ? this.getChild("Name").getTextContent() : null;
    }

    @Override
    public Collection<CapacityConstraint> getCapacityConstraintArray() {
        Collection<Element> ccElements = this.getChildren("CapacityConstraint");
        ArrayList<CapacityConstraint> capacityContraints = new ArrayList<CapacityConstraint>();
        for (Element element : ccElements) {
            CapacityConstraintImpl cc = new CapacityConstraintImpl(element, this.session);
            capacityContraints.add(cc);
        }
        return capacityContraints;
    }

    @Override
    public Collection<ConsumptionConstraint> getConsumptionConstraintArray() {
        Collection<Element> ccElements = this.getChildren("ConsumptionConstraint");
        ArrayList<ConsumptionConstraint> consumptionContraints = new ArrayList<ConsumptionConstraint>();
        for (Element element : ccElements) {
            ConsumptionConstraintImpl cc = new ConsumptionConstraintImpl(element, this.session);
            consumptionContraints.add(cc);
        }
        return consumptionContraints;
    }

    @Override
    public Collection<PropertyConstraint> getPropertyConstraintArray() {
        Collection<Element> rcElements = this.getChildren("PropertyConstraint");
        ArrayList<PropertyConstraint> propertyContraints = new ArrayList<PropertyConstraint>();
        for (Element element : rcElements) {
            PropertyConstraintImpl cc = new PropertyConstraintImpl(element, this.session);
            propertyContraints.add(cc);
        }
        return propertyContraints;
    }

    @Override
    public String getResourceConstraintID() {
        return this.getAttribute("id");
    }

    @Override
    public String getResourceReference() {
        return this.getAttribute("resourceRef");
    }

    @Override
    public Boolean getTestValue() {
        return new Boolean(this.getAttribute("testValue"));
    }

    @Override
    public Collection<VersionConstraint> getVersionConstraintArray() {
        Collection<Element> vcElements = this.getChildren("VersionConstraint");
        ArrayList<VersionConstraint> versionContraints = new ArrayList<VersionConstraint>();
        for (Element element : vcElements) {
            VersionConstraintImpl vc = new VersionConstraintImpl(element, this.session);
            versionContraints.add(vc);
        }
        return versionContraints;
    }

    @Override
    public Collection<UniquenessConstraint> getUniquenessConstraintArray() {
        Collection<Element> ucElements = this.getChildren("UniquenessConstraint");
        ArrayList<UniquenessConstraint> uniquenessContraints = new ArrayList<UniquenessConstraint>();
        for (Element element : ucElements) {
            UniquenessConstraintImpl uc = new UniquenessConstraintImpl(element, this.session);
            uniquenessContraints.add(uc);
        }
        return uniquenessContraints;
    }

    @Override
    public Collection<RelationshipConstraint> getRelationshipConstraintArray() {
        Collection<Element> rcElements = this.getChildren("RelationshipConstraint");
        ArrayList<RelationshipConstraint> relationshipContraints = new ArrayList<RelationshipConstraint>();
        for (Element element : rcElements) {
            RelationshipConstraintImpl rc = new RelationshipConstraintImpl(element, this.session);
            relationshipContraints.add(rc);
        }
        return relationshipContraints;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            this.unSetElement("Name");
        } else {
            Element nameElement = this.session.createDeploymentElement("Name");
            nameElement.setTextContent(name);
            this.setContent(nameElement);
        }
    }

    @Override
    public void setCapacityConstraintArray(Collection<CapacityConstraint> newCapacityConstraintArray) {
        if (newCapacityConstraintArray != null && !newCapacityConstraintArray.isEmpty()) {
            this.removeContent(this.getChildren("CapacityConstraint", false));
            this.addContent(newCapacityConstraintArray);
        } else {
            this.unSetElement("CapacityConstraint");
        }
    }

    @Override
    public void setConsumptionConstraintArray(Collection<ConsumptionConstraint> newConsumptionConstraintArray) {
        if (newConsumptionConstraintArray != null && !newConsumptionConstraintArray.isEmpty()) {
            this.removeContent(this.getChildren("ConsumptionConstraint", false));
            this.addContent(newConsumptionConstraintArray);
        } else {
            this.unSetElement("ConsumptionConstraint");
        }
    }

    @Override
    public void setPropertyConstraintArray(Collection<PropertyConstraint> propertyConstraints) {
        if (propertyConstraints != null && !propertyConstraints.isEmpty()) {
            this.removeContent(this.getChildren("PropertyConstraint", false));
            this.addContent(propertyConstraints);
        } else {
            this.unSetElement("PropertyConstraint");
        }
    }

    @Override
    public void setResourceConstraintID(String resourceConstraintID) {
        this.session.testParameter(resourceConstraintID, 1, null);
        this.setAttribute("id", resourceConstraintID);
    }

    @Override
    public void setResourceReference(String resourceReference) {
        this.session.testParameter(resourceReference, 1, null);
        this.setAttribute("resourceRef", resourceReference);
    }

    @Override
    public void setTestValue(Boolean testValue) {
        if (testValue == null) {
            this.unSetAttribute("testValue");
        } else {
            this.setAttribute("testValue", testValue.toString());
        }
    }

    @Override
    public void setVersionConstraintArray(Collection<VersionConstraint> newVersionConstraintArray) {
        if (newVersionConstraintArray != null && !newVersionConstraintArray.isEmpty()) {
            this.removeContent(this.getChildren("VersionConstraint", false));
            this.addContent(newVersionConstraintArray);
        } else {
            this.unSetElement("VersionConstraint");
        }
    }

    @Override
    public void setUniquenessConstraintArray(Collection<UniquenessConstraint> newUniquenessConstraintArray) {
        if (newUniquenessConstraintArray != null && !newUniquenessConstraintArray.isEmpty()) {
            this.removeContent(this.getChildren("UniquenessConstraint", false));
            this.addContent(newUniquenessConstraintArray);
        } else {
            this.unSetElement("UniquenessConstraint");
        }
    }

    @Override
    public void setRelationshipConstraintArray(Collection<RelationshipConstraint> newRelationshipConstraintArray) {
        if (newRelationshipConstraintArray != null && !newRelationshipConstraintArray.isEmpty()) {
            this.removeContent(this.getChildren("RelationshipConstraint", false));
            this.addContent(newRelationshipConstraintArray);
        } else {
            this.unSetElement("RelationshipConstraint");
        }
    }

    @Override
    public Object clone() {
        return new RequirementResourceConstraintImpl((Element)this.getElement().cloneNode(true), this.session);
    }

    @Override
    public String toString() {
        String contents = new String("ResourceConstraint ID: " + this.getResourceConstraintID() + " , Resource Reference: " + this.getResourceReference() + "\n" + super.toString());
        return contents;
    }
}

