/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.VersionRangeImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.VersionValueImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.VersionConstraint;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionConstraintImpl
extends DescribableObject
implements VersionConstraint {
    private static final String VERSION_CONSTRAINT_TYPE = "sdd-dd:VersionConstraintType";
    private static final String VERSION_CONSTRAINT_VALUE_TYPE = "sdd-dd:VersionConstraintValueType";

    public VersionConstraintImpl(Element data, SPISessionImpl session) {
        super(data, session, VERSION_CONSTRAINT_TYPE);
    }

    @Override
    public Collection<VersionValue> getCertifiedVersionValues() {
        ArrayList<VersionValue> versionValues = new ArrayList<VersionValue>();
        if (this.isSetElement("Certified")) {
            Collection<Element> versionValueElementList = this.session.getChildren(this.getChild("Certified"), "Value");
            for (Element element : versionValueElementList) {
                versionValues.add(new VersionValueImpl(element, this.session));
            }
        }
        return versionValues;
    }

    @Override
    public Collection<VersionValue> getVersionValues() {
        ArrayList<VersionValue> versionValues = new ArrayList<VersionValue>();
        if (this.isSetElement("Supported")) {
            Collection<Element> versionValueElementList = this.session.getChildren(this.getChild("Supported"), "Value");
            for (Element element : versionValueElementList) {
                versionValues.add(new VersionValueImpl(element, this.session));
            }
        }
        return versionValues;
    }

    @Override
    public Collection<VersionRange> getCertifiedVersionRanges() {
        ArrayList<VersionRange> versionRanges = new ArrayList<VersionRange>();
        if (this.isSetElement("Certified")) {
            Collection<Element> versionRangeElementList = this.session.getChildren(this.getChild("Certified"), "Range");
            for (Element element : versionRangeElementList) {
                versionRanges.add(new VersionRangeImpl(element, this.session));
            }
        }
        return versionRanges;
    }

    @Override
    public Collection<VersionRange> getVersionRanges() {
        ArrayList<VersionRange> versionRanges = new ArrayList<VersionRange>();
        if (this.isSetElement("Supported")) {
            Collection<Element> versionRangeElementList = this.session.getChildren(this.getChild("Supported"), "Range");
            for (Element element : versionRangeElementList) {
                versionRanges.add(new VersionRangeImpl(element, this.session));
            }
        }
        return versionRanges;
    }

    @Override
    public void setCertifiedVersionValues(Collection<VersionValue> newCertifiedVersionValues) {
        Element certified = this.isSetElement("Certified") ? this.getChild("Certified") : this.session.createDeploymentElement("Certified");
        Collection<Element> containedPackageNodeList = this.session.getChildren(certified, "Value");
        for (Element element : containedPackageNodeList) {
            certified.removeChild(element);
        }
        if (newCertifiedVersionValues != null && !newCertifiedVersionValues.isEmpty()) {
            for (VersionValue versionValue : newCertifiedVersionValues) {
                this.session.insertNode((Node)certified, (SPIDataObject)((Object)versionValue), VERSION_CONSTRAINT_VALUE_TYPE);
            }
            this.setContent(certified);
        } else if (this.session.getChildren(certified, "Range").isEmpty()) {
            this.unSetElement("Certified");
        }
    }

    @Override
    public void setVersionValues(Collection<VersionValue> newVersionValues) {
        Element supported = this.isSetElement("Supported") ? this.getChild("Supported") : this.session.createDeploymentElement("Supported");
        Collection<Element> containedPackageNodeList = this.session.getChildren(supported, "Value");
        for (Element element : containedPackageNodeList) {
            supported.removeChild(element);
        }
        if (newVersionValues != null && !newVersionValues.isEmpty()) {
            for (VersionValue versionValue : newVersionValues) {
                this.session.insertNode((Node)supported, (SPIDataObject)((Object)versionValue), VERSION_CONSTRAINT_VALUE_TYPE);
            }
            this.setContent(supported);
        } else if (this.session.getChildren(supported, "Range").isEmpty()) {
            this.unSetElement("Supported");
        }
    }

    @Override
    public void setCertifiedVersionRanges(Collection<VersionRange> newCertifiedVersionRanges) {
        Element certified = this.isSetElement("Certified") ? this.getChild("Certified") : this.session.createDeploymentElement("Certified");
        Collection<Element> containedPackageNodeList = this.session.getChildren(certified, "Range");
        for (Element element : containedPackageNodeList) {
            certified.removeChild(element);
        }
        if (newCertifiedVersionRanges != null && !newCertifiedVersionRanges.isEmpty()) {
            for (VersionRange versionRange : newCertifiedVersionRanges) {
                this.session.insertNode((Node)certified, (SPIDataObject)((Object)versionRange), VERSION_CONSTRAINT_VALUE_TYPE);
            }
            this.setContent(certified);
        } else if (this.session.getChildren(certified, "Value").isEmpty()) {
            this.unSetElement("Certified");
        }
    }

    @Override
    public void setVersionRanges(Collection<VersionRange> newVersionRanges) {
        Element supported = this.isSetElement("Supported") ? this.getChild("Supported") : this.session.createDeploymentElement("Supported");
        Collection<Element> containedPackageNodeList = this.session.getChildren(supported, "Range");
        for (Element element : containedPackageNodeList) {
            supported.removeChild(element);
        }
        if (newVersionRanges != null && !newVersionRanges.isEmpty()) {
            for (VersionRange versionRange : newVersionRanges) {
                this.session.insertNode((Node)supported, (SPIDataObject)((Object)versionRange), VERSION_CONSTRAINT_VALUE_TYPE);
            }
            this.setContent(supported);
        } else if (this.session.getChildren(supported, "Value").isEmpty()) {
            this.unSetElement("Supported");
        }
    }

    @Override
    public Object clone() {
        return new VersionConstraintImpl((Element)this.getElement().cloneNode(true), this.session);
    }

    @Override
    public String toString() {
        String contents = new String("Version Constraint\n" + super.toString());
        return contents;
    }
}

