/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Identity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeInstallable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeLocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Feature;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Group;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LanguageSet;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.MultiFeatureSelect;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingChange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.BooleanParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariableExpression;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterGroup;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ResourceProperty;
import org.w3c.dom.Element;

public class CompositeInstallable_Test
extends TestCase {
    CompositeInstallable unit;
    CompositeInstallable clonedUnit;
    Element element;
    SPISessionImpl session;

    public CompositeInstallable_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.unit = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeInstallable("id", "operation");
        Condition condition = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        condition.setDisplayName(new TranslatableString("conName", "conNameKey"));
        this.unit.setCondition(condition);
        Condition con1 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con1.setDisplayName(new TranslatableString("con1Name", "con1NameKey"));
        ConditionalDerivedVariableExpression exp1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp1Expression", con1);
        Condition con2 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con2.setDisplayName(new TranslatableString("con2Name", "con2NameKey"));
        ConditionalDerivedVariableExpression exp2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp2Expression", con2);
        ConditionalDerivedVariable var1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariable("var1ID", (Collection<ConditionalDerivedVariableExpression>)Arrays.asList(exp1, exp2));
        Condition con3 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con3.setDisplayName(new TranslatableString("con3Name", "con3NameKey"));
        ConditionalDerivedVariableExpression exp3 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp3Expression", con3);
        Condition con4 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con4.setDisplayName(new TranslatableString("con4Name", "con4NameKey"));
        ConditionalDerivedVariableExpression exp4 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp4Expression", con4);
        ConditionalDerivedVariable var2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariable("var2ID", (Collection<ConditionalDerivedVariableExpression>)Arrays.asList(exp3, exp4));
        this.unit.setConditionalDerivedVariables((Collection<ConditionalDerivedVariable>)Arrays.asList(var1, var2));
        DerivedVariable dvar1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("dvar1ID", "dvar1Expression");
        DerivedVariable dvar2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("dvar2ID", "dvar2Expression");
        this.unit.setDerivedVariables((Collection<DerivedVariable>)Arrays.asList(dvar1, dvar2));
        Identity identity = SPISession.DEFAULT_INSTANCE.createBaseFactory().createIdentity(new TranslatableString("name", "nameKey"));
        this.unit.setIdentityData(identity);
        BooleanParameter param1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param1ID");
        BooleanParameter param2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param2ID");
        ParameterGroup paramGroup1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createParameterGroup();
        paramGroup1.setBooleanParameters((Collection<BooleanParameter>)Arrays.asList(param1, param2));
        BooleanParameter param3 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param3ID");
        BooleanParameter param4 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param4ID");
        ParameterGroup paramGroup2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createParameterGroup();
        paramGroup2.setBooleanParameters((Collection<BooleanParameter>)Arrays.asList(param3, param4));
        this.unit.setParameterGroups((Collection<ParameterGroup>)Arrays.asList(paramGroup1, paramGroup2));
        Requirement req1 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req1ID");
        Requirement req2 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req2ID");
        this.unit.setRequirements((Collection<Requirement>)Arrays.asList(req1, req2));
        ResourceProperty prop1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createResourceProperty("prop1ID", "prop1Ref");
        ResourceProperty prop2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createResourceProperty("prop2ID", "prop2Ref");
        this.unit.setResourceProperties((Collection<ResourceProperty>)Arrays.asList(prop1, prop2));
        ReferencedPackage package1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package1Ref", "package1ID");
        ReferencedPackage package2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package2Ref", "package2ID");
        this.unit.setContainedLocalizationPackages((Collection<ReferencedPackage>)Arrays.asList(package1, package2));
        ReferencedPackage package3 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package3Ref", "package3ID");
        ReferencedPackage package4 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package4Ref", "package4ID");
        CompositeLocalizationUnit comploc1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeLocalizationUnitWithContainedLocalizationPackages("comploc1ID", (Collection<ReferencedPackage>)Arrays.asList(package3, package4));
        ReferencedPackage package5 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package5Ref", "package5ID");
        ReferencedPackage package6 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package6Ref", "package6ID");
        CompositeLocalizationUnit comploc2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeLocalizationUnitWithContainedLocalizationPackages("comploc2ID", (Collection<ReferencedPackage>)Arrays.asList(package5, package6));
        this.unit.setCompositeLocalizationUnits((Collection<CompositeLocalizationUnit>)Arrays.asList(comploc1, comploc2));
        ResultingResource res1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingResource("res1Ref");
        ResultingResource res2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingResource("res2Ref");
        this.unit.setResultingResources((Collection<ResultingResource>)Arrays.asList(res1, res2));
        RequiredBase base = SPISession.DEFAULT_INSTANCE.createRequiredBaseFactory().createRequiredBase();
        base.setDisplayName(new TranslatableString("baseName", "baseKey"));
        this.unit.setRequiredBase(base);
        Artifact art1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        art1.setContentReference("art1ContentRef");
        LocalizationUnit lu1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLocalizationUnit("lu1ID", "lu1ResourceRef", art1, 0);
        Artifact art2 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        art2.setContentReference("art2ContentRef");
        LocalizationUnit lu2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLocalizationUnit("lu2ID", "lu2ResourceRef", art2, 0);
        this.unit.setLocalizationUnits((Collection<LocalizationUnit>)Arrays.asList(lu1, lu2));
        CompositeUnit baseUnit1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("baseCU1ID");
        CompositeUnit baseUnit2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("baseCU2ID");
        this.unit.setBaseCompositeUnits((Collection<CompositeUnit>)Arrays.asList(baseUnit1, baseUnit2));
        Artifact baseArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createConfigArtifact();
        baseArt1.setContentReference("baseArt1ContentRef");
        ConfigurationUnit baseCfg1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConfigurationUnit("baseCfg1ID", "baseCfg1ResourceRef", baseArt1);
        Artifact baseArt2 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createConfigArtifact();
        baseArt2.setContentReference("baseArt2ContentRef");
        ConfigurationUnit baseCfg2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConfigurationUnit("baseCfg2ID", "baseCfg2ResourceRef", baseArt2);
        this.unit.setBaseConfigurationUnits((Collection<ConfigurationUnit>)Arrays.asList(baseCfg1, baseCfg2));
        ReferencedPackage basePackage1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedPackage("basePackage1Ref", "basePackage1ID");
        ReferencedPackage basePackage2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedPackage("basePackage2Ref", "basePackage2ID");
        this.unit.setBaseContainedPackages((Collection<ReferencedPackage>)Arrays.asList(basePackage1, basePackage2));
        Artifact baseIUArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        baseIUArt1.setContentReference("baseIUArt1ContentRef");
        InstallableUnit baseIU1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createInstallableUnit("baseIU1ID", "baseIU1ResourceRef", baseIUArt1, 0);
        Artifact baseIUArt2 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        baseIUArt2.setContentReference("baseIUArt2ContentRef");
        InstallableUnit baseIU2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createInstallableUnit("baseIU2ID", "baseIU2ResourceRef", baseIUArt2, 0);
        this.unit.setBaseInstallableUnits((Collection<InstallableUnit>)Arrays.asList(baseIU1, baseIU2));
        CompositeUnit compUnit1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("selCU1ID");
        CompositeUnit compUnit2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("selCU2ID");
        this.unit.setSelectableCompositeUnits((Collection<CompositeUnit>)Arrays.asList(compUnit1, compUnit2));
        Artifact selArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createConfigArtifact();
        selArt1.setContentReference("selArt1ContentRef");
        ConfigurationUnit selCfg1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConfigurationUnit("selCfg1ID", "selCfg1ResourceRef", selArt1);
        Artifact selArt2 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createConfigArtifact();
        selArt2.setContentReference("selArt2ContentRef");
        ConfigurationUnit selCfg2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConfigurationUnit("selCfg2ID", "selCfg2ResourceRef", selArt2);
        this.unit.setSelectableConfigurationUnits((Collection<ConfigurationUnit>)Arrays.asList(selCfg1, selCfg2));
        ReferencedPackage selPackage1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedPackage("selPackage1Ref", "selPackage1ID");
        ReferencedPackage selPackage2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedPackage("selPackage2Ref", "selPackage2ID");
        this.unit.setSelectableContainedPackages((Collection<ReferencedPackage>)Arrays.asList(selPackage1, selPackage2));
        Artifact selIUArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        selIUArt1.setContentReference("selIUArt1ContentRef");
        InstallableUnit selIU1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createInstallableUnit("selIU1ID", "selIU1ResourceRef", selIUArt1, 0);
        Artifact selIUArt2 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        selIUArt2.setContentReference("selIUArt2ContentRef");
        InstallableUnit selIU2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createInstallableUnit("selIU2ID", "selIU2ResourceRef", selIUArt2, 0);
        this.unit.setSelectableInstallableUnits((Collection<InstallableUnit>)Arrays.asList(selIU1, selIU2));
        DerivedVariable dvar3 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("dvar3ID", "dvar3Expression");
        DerivedVariable dvar4 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("dvar4ID", "dvar4Expression");
        Feature feature1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createFeatureWithDerivedVariables("feature1ID", (Collection<DerivedVariable>)Arrays.asList(dvar3, dvar4));
        DerivedVariable dvar5 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("dvar5ID", "dvar5Expression");
        DerivedVariable dvar6 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("dvar6ID", "dvar6Expression");
        Feature feature2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createFeatureWithDerivedVariables("feature2ID", (Collection<DerivedVariable>)Arrays.asList(dvar5, dvar6));
        this.unit.setFeatures((Collection<Feature>)Arrays.asList(feature1, feature2));
        Group group1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createGroup("group1ID", (Collection<String>)Arrays.asList("feature1Ref", "feature2Ref"));
        Group group2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createGroup("group2ID", (Collection<String>)Arrays.asList("feature3Ref", "feature4Ref"));
        this.unit.setGroups((Collection<Group>)Arrays.asList(group1, group2));
        Language manLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("manLang1Type");
        Language manLang2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("manLang2Type");
        this.unit.setMandatoryLanguages((Collection<Language>)Arrays.asList(manLang1, manLang2));
        Language optLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("optLang1Type");
        Language optLang2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("optLang2Type");
        this.unit.setOptionalLanguages((Collection<Language>)Arrays.asList(optLang1, optLang2));
        Language setLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("setLang1Type");
        Language setLang2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("setLang2Type");
        LanguageSet langSet1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguageSet((Collection<Language>)Arrays.asList(setLang1, setLang2));
        Language setLang3 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("setLang3Type");
        Language setLang4 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("setLang4Type");
        LanguageSet langSet2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguageSet((Collection<Language>)Arrays.asList(setLang3, setLang4));
        this.unit.setOptionalLanguageSets((Collection<LanguageSet>)Arrays.asList(langSet1, langSet2));
        MultiFeatureSelect multi1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createMultiFeatureSelect((Collection<String>)Arrays.asList("multiFeature1", "multiFeature2"));
        MultiFeatureSelect multi2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createMultiFeatureSelect((Collection<String>)Arrays.asList("multiFeature3", "multiFeature4"));
        this.unit.setMultiFeatureSelects((Collection<MultiFeatureSelect>)Arrays.asList(multi1, multi2));
        ResultingChange change1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingChange();
        change1.setName("change1Name");
        ResultingChange change2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingChange();
        change2.setName("change2Name");
        this.unit.setResultingChanges((Collection<ResultingChange>)Arrays.asList(change1, change2));
        this.clonedUnit = (CompositeInstallable)this.unit.clone();
        this.element = ((SPIDataObject)((Object)this.unit)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)((Object)this.unit)).getTranslatableStrings();
        CompositeInstallable_Test.assertEquals((int)7, (int)props.size());
        CompositeInstallable_Test.assertEquals((String)"conName", (String)props.getProperty("conNameKey"));
        CompositeInstallable_Test.assertEquals((String)"con1Name", (String)props.getProperty("con1NameKey"));
        CompositeInstallable_Test.assertEquals((String)"con2Name", (String)props.getProperty("con2NameKey"));
        CompositeInstallable_Test.assertEquals((String)"con3Name", (String)props.getProperty("con3NameKey"));
        CompositeInstallable_Test.assertEquals((String)"con4Name", (String)props.getProperty("con4NameKey"));
        CompositeInstallable_Test.assertEquals((String)"name", (String)props.getProperty("nameKey"));
        CompositeInstallable_Test.assertEquals((String)"baseName", (String)props.getProperty("baseKey"));
    }

    public void testGetBaseCompositeUnits() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getBaseCompositeUnits().size());
        CompositeInstallable_Test.assertEquals((String)"baseCU1ID", (String)this.unit.getBaseCompositeUnits().toArray(new CompositeUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"baseCU2ID", (String)this.unit.getBaseCompositeUnits().toArray(new CompositeUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getBaseCompositeUnits().size());
        CompositeInstallable_Test.assertEquals((String)"baseCU1ID", (String)this.clonedUnit.getBaseCompositeUnits().toArray(new CompositeUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"baseCU2ID", (String)this.clonedUnit.getBaseCompositeUnits().toArray(new CompositeUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "CompositeUnit").size());
        CompositeInstallable_Test.assertEquals((String)"baseCU1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "CompositeUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"baseCU2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "CompositeUnit").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testGetBaseConfigurationUnits() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getBaseConfigurationUnits().size());
        CompositeInstallable_Test.assertEquals((String)"baseCfg1ID", (String)this.unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"baseCfg1ResourceRef", (String)this.unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"baseArt1ContentRef", (String)this.unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getConfigurationArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((String)"baseCfg2ID", (String)this.unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"baseCfg2ResourceRef", (String)this.unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"baseArt2ContentRef", (String)this.unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getConfigurationArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getBaseConfigurationUnits().size());
        CompositeInstallable_Test.assertEquals((String)"baseCfg1ID", (String)this.clonedUnit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"baseCfg1ResourceRef", (String)this.clonedUnit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"baseArt1ContentRef", (String)this.clonedUnit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getConfigurationArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((String)"baseCfg2ID", (String)this.clonedUnit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"baseCfg2ResourceRef", (String)this.clonedUnit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"baseArt2ContentRef", (String)this.clonedUnit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getConfigurationArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").size());
        CompositeInstallable_Test.assertEquals((String)"baseCfg1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"baseCfg1ResourceRef", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeInstallable_Test.assertEquals((String)"baseArt1ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "ConfigArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeInstallable_Test.assertEquals((String)"baseCfg2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"baseCfg2ResourceRef", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[1].getAttribute("targetResourceRef"));
        CompositeInstallable_Test.assertEquals((String)"baseArt2ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[1], "Artifacts").toArray(new Element[0])[0], "ConfigArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testGetBaseContainedPackages() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getBaseContainedPackages().size());
        CompositeInstallable_Test.assertEquals((String)"basePackage1ID", (String)this.unit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"basePackage1Ref", (String)this.unit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeInstallable_Test.assertEquals((String)"basePackage2ID", (String)this.unit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"basePackage2Ref", (String)this.unit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getBaseContainedPackages().size());
        CompositeInstallable_Test.assertEquals((String)"basePackage1ID", (String)this.clonedUnit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"basePackage1Ref", (String)this.clonedUnit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeInstallable_Test.assertEquals((String)"basePackage2ID", (String)this.clonedUnit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"basePackage2Ref", (String)this.clonedUnit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").size());
        CompositeInstallable_Test.assertEquals((String)"basePackage1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"basePackage1Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeInstallable_Test.assertEquals((String)"basePackage2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"basePackage2Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
    }

    public void testGetBaseInstallableUnits() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getBaseInstallableUnits().size());
        CompositeInstallable_Test.assertEquals((String)"baseIU1ID", (String)this.unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"baseIU1ResourceRef", (String)this.unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"baseIUArt1ContentRef", (String)this.unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getInstallArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((String)"baseIU2ID", (String)this.unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"baseIU2ResourceRef", (String)this.unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[1].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"baseIUArt2ContentRef", (String)this.unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[1].getInstallArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getBaseInstallableUnits().size());
        CompositeInstallable_Test.assertEquals((String)"baseIU1ID", (String)this.clonedUnit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"baseIU1ResourceRef", (String)this.clonedUnit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"baseIUArt1ContentRef", (String)this.clonedUnit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getInstallArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((String)"baseIU2ID", (String)this.clonedUnit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"baseIU2ResourceRef", (String)this.clonedUnit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[1].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"baseIUArt2ContentRef", (String)this.clonedUnit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[1].getInstallArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").size());
        CompositeInstallable_Test.assertEquals((String)"baseIU1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"baseIU1ResourceRef", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeInstallable_Test.assertEquals((String)"baseIUArt1ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeInstallable_Test.assertEquals((String)"baseIU2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"baseIU2ResourceRef", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[1].getAttribute("targetResourceRef"));
        CompositeInstallable_Test.assertEquals((String)"baseIUArt2ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[1], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testGetMandatoryLanguages() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getMandatoryLanguages().size());
        CompositeInstallable_Test.assertEquals((String)"manLang1Type", (String)this.unit.getMandatoryLanguages().toArray(new Language[0])[0].getType());
        CompositeInstallable_Test.assertEquals((String)"manLang2Type", (String)this.unit.getMandatoryLanguages().toArray(new Language[0])[1].getType());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getMandatoryLanguages().size());
        CompositeInstallable_Test.assertEquals((String)"manLang1Type", (String)this.clonedUnit.getMandatoryLanguages().toArray(new Language[0])[0].getType());
        CompositeInstallable_Test.assertEquals((String)"manLang2Type", (String)this.clonedUnit.getMandatoryLanguages().toArray(new Language[0])[1].getType());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Mandatory").toArray(new Element[0])[0], "Language").size());
        CompositeInstallable_Test.assertEquals((String)"manLang1Type", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Mandatory").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
        CompositeInstallable_Test.assertEquals((String)"manLang2Type", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Mandatory").toArray(new Element[0])[0], "Language").toArray(new Element[0])[1].getAttribute("type"));
    }

    public void testGetOptionalLanguages() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getOptionalLanguages().size());
        CompositeInstallable_Test.assertEquals((String)"optLang1Type", (String)this.unit.getOptionalLanguages().toArray(new Language[0])[0].getType());
        CompositeInstallable_Test.assertEquals((String)"optLang2Type", (String)this.unit.getOptionalLanguages().toArray(new Language[0])[1].getType());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getOptionalLanguages().size());
        CompositeInstallable_Test.assertEquals((String)"optLang1Type", (String)this.clonedUnit.getOptionalLanguages().toArray(new Language[0])[0].getType());
        CompositeInstallable_Test.assertEquals((String)"optLang2Type", (String)this.clonedUnit.getOptionalLanguages().toArray(new Language[0])[1].getType());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "Language").size());
        CompositeInstallable_Test.assertEquals((String)"optLang1Type", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
        CompositeInstallable_Test.assertEquals((String)"optLang2Type", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "Language").toArray(new Element[0])[1].getAttribute("type"));
    }

    public void testGetOptionalLanguageSets() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getOptionalLanguageSets().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[1].getLanguages().size());
        CompositeInstallable_Test.assertEquals((String)"setLang1Type", (String)this.unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[0].getType());
        CompositeInstallable_Test.assertEquals((String)"setLang2Type", (String)this.unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[1].getType());
        CompositeInstallable_Test.assertEquals((String)"setLang3Type", (String)this.unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[1].getLanguages().toArray(new Language[0])[0].getType());
        CompositeInstallable_Test.assertEquals((String)"setLang4Type", (String)this.unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[1].getLanguages().toArray(new Language[0])[1].getType());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getOptionalLanguageSets().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getOptionalLanguageSets().toArray(new LanguageSet[0])[1].getLanguages().size());
        CompositeInstallable_Test.assertEquals((String)"setLang1Type", (String)this.clonedUnit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[0].getType());
        CompositeInstallable_Test.assertEquals((String)"setLang2Type", (String)this.clonedUnit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[1].getType());
        CompositeInstallable_Test.assertEquals((String)"setLang3Type", (String)this.clonedUnit.getOptionalLanguageSets().toArray(new LanguageSet[0])[1].getLanguages().toArray(new Language[0])[0].getType());
        CompositeInstallable_Test.assertEquals((String)"setLang4Type", (String)this.clonedUnit.getOptionalLanguageSets().toArray(new LanguageSet[0])[1].getLanguages().toArray(new Language[0])[1].getType());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[0], "Language").size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[1], "Language").size());
        CompositeInstallable_Test.assertEquals((String)"setLang1Type", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
        CompositeInstallable_Test.assertEquals((String)"setLang2Type", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[0], "Language").toArray(new Element[0])[1].getAttribute("type"));
        CompositeInstallable_Test.assertEquals((String)"setLang3Type", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[1], "Language").toArray(new Element[0])[0].getAttribute("type"));
        CompositeInstallable_Test.assertEquals((String)"setLang4Type", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[1], "Language").toArray(new Element[0])[1].getAttribute("type"));
    }

    public void testGetCompositeLocalizationUnits() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getCompositeLocalizationUnits().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().size());
        CompositeInstallable_Test.assertEquals((String)"comploc1ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"package3ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"package3Ref", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeInstallable_Test.assertEquals((String)"package4ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"package4Ref", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeInstallable_Test.assertEquals((String)"comploc2ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"package5ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"package5Ref", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeInstallable_Test.assertEquals((String)"package6ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"package6Ref", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getCompositeLocalizationUnits().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().size());
        CompositeInstallable_Test.assertEquals((String)"comploc1ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"package3ID", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"package3Ref", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeInstallable_Test.assertEquals((String)"package4ID", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"package4Ref", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeInstallable_Test.assertEquals((String)"comploc2ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"package5ID", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"package5Ref", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeInstallable_Test.assertEquals((String)"package6ID", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"package6Ref", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").size());
        CompositeInstallable_Test.assertEquals((String)"comploc1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"package3ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"package3Ref", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeInstallable_Test.assertEquals((String)"package4ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"package4Ref", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
        CompositeInstallable_Test.assertEquals((String)"comploc2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"package5ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"package5Ref", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeInstallable_Test.assertEquals((String)"package6ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"package6Ref", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
    }

    public void testGetCondition() {
        CompositeInstallable_Test.assertEquals((String)"conName", (String)this.unit.getCondition().getDisplayName().getValue());
        CompositeInstallable_Test.assertEquals((String)"conNameKey", (String)this.unit.getCondition().getDisplayName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((String)"conName", (String)this.clonedUnit.getCondition().getDisplayName().getValue());
        CompositeInstallable_Test.assertEquals((String)"conNameKey", (String)this.clonedUnit.getCondition().getDisplayName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((String)"conName", (String)this.session.getChildren(this.session.getChildren(this.element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"conNameKey", (String)this.session.getChildren(this.session.getChildren(this.element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetContainedLocalizationPackages() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getContainedLocalizationPackages().size());
        CompositeInstallable_Test.assertEquals((String)"package1ID", (String)this.unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"package1Ref", (String)this.unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeInstallable_Test.assertEquals((String)"package2ID", (String)this.unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"package2Ref", (String)this.unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getContainedLocalizationPackages().size());
        CompositeInstallable_Test.assertEquals((String)"package1ID", (String)this.clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"package1Ref", (String)this.clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeInstallable_Test.assertEquals((String)"package2ID", (String)this.clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"package2Ref", (String)this.clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").size());
        CompositeInstallable_Test.assertEquals((String)"package1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"package1Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeInstallable_Test.assertEquals((String)"package2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"package2Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
    }

    public void testGetFeatures() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getFeatures().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getFeatures().toArray(new Feature[0])[0].getVariables().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getFeatures().toArray(new Feature[0])[1].getVariables().size());
        CompositeInstallable_Test.assertEquals((String)"feature1ID", (String)this.unit.getFeatures().toArray(new Feature[0])[0].getFeatureID());
        CompositeInstallable_Test.assertEquals((String)"feature2ID", (String)this.unit.getFeatures().toArray(new Feature[0])[1].getFeatureID());
        CompositeInstallable_Test.assertEquals((String)"dvar3ID", (String)this.unit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar3Expression", (String)this.unit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeInstallable_Test.assertEquals((String)"dvar4ID", (String)this.unit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar4Expression", (String)this.unit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[1].getExpression());
        CompositeInstallable_Test.assertEquals((String)"dvar5ID", (String)this.unit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar5Expression", (String)this.unit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeInstallable_Test.assertEquals((String)"dvar6ID", (String)this.unit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar6Expression", (String)this.unit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[1].getExpression());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getFeatures().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getFeatures().toArray(new Feature[0])[0].getVariables().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getFeatures().toArray(new Feature[0])[1].getVariables().size());
        CompositeInstallable_Test.assertEquals((String)"feature1ID", (String)this.clonedUnit.getFeatures().toArray(new Feature[0])[0].getFeatureID());
        CompositeInstallable_Test.assertEquals((String)"feature2ID", (String)this.clonedUnit.getFeatures().toArray(new Feature[0])[1].getFeatureID());
        CompositeInstallable_Test.assertEquals((String)"dvar3ID", (String)this.clonedUnit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar3Expression", (String)this.clonedUnit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeInstallable_Test.assertEquals((String)"dvar4ID", (String)this.clonedUnit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar4Expression", (String)this.clonedUnit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[1].getExpression());
        CompositeInstallable_Test.assertEquals((String)"dvar5ID", (String)this.clonedUnit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar5Expression", (String)this.clonedUnit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeInstallable_Test.assertEquals((String)"dvar6ID", (String)this.clonedUnit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar6Expression", (String)this.clonedUnit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[1].getExpression());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").size());
        CompositeInstallable_Test.assertEquals((String)"feature1ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"feature2ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"dvar3ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"dvar3Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"dvar4ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"dvar4Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").toArray(new Element[0])[1], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"dvar5ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"dvar5Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"dvar6ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"dvar6Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").toArray(new Element[0])[1], "Expression").toArray(new Element[0])[0].getTextContent());
    }

    public void testGetMultiFeatureSelects() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getMultiFeatureSelects().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[1].getFeatures().size());
        CompositeInstallable_Test.assertEquals((String)"multiFeature1", (String)this.unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().toArray(new String[0])[0]);
        CompositeInstallable_Test.assertEquals((String)"multiFeature2", (String)this.unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().toArray(new String[0])[1]);
        CompositeInstallable_Test.assertEquals((String)"multiFeature3", (String)this.unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[1].getFeatures().toArray(new String[0])[0]);
        CompositeInstallable_Test.assertEquals((String)"multiFeature4", (String)this.unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[1].getFeatures().toArray(new String[0])[1]);
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getMultiFeatureSelects().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[1].getFeatures().size());
        CompositeInstallable_Test.assertEquals((String)"multiFeature1", (String)this.clonedUnit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().toArray(new String[0])[0]);
        CompositeInstallable_Test.assertEquals((String)"multiFeature2", (String)this.clonedUnit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().toArray(new String[0])[1]);
        CompositeInstallable_Test.assertEquals((String)"multiFeature3", (String)this.clonedUnit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[1].getFeatures().toArray(new String[0])[0]);
        CompositeInstallable_Test.assertEquals((String)"multiFeature4", (String)this.clonedUnit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[1].getFeatures().toArray(new String[0])[1]);
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[0], "Feature").size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[1], "Feature").size());
        CompositeInstallable_Test.assertEquals((String)"multiFeature1", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0].getAttribute("featureRef"));
        CompositeInstallable_Test.assertEquals((String)"multiFeature2", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1].getAttribute("featureRef"));
        CompositeInstallable_Test.assertEquals((String)"multiFeature3", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[1], "Feature").toArray(new Element[0])[0].getAttribute("featureRef"));
        CompositeInstallable_Test.assertEquals((String)"multiFeature4", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[1], "Feature").toArray(new Element[0])[1].getAttribute("featureRef"));
    }

    public void testGetGroups() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getGroups().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getGroups().toArray(new Group[0])[1].getSelectedFeatures().size());
        CompositeInstallable_Test.assertEquals((String)"group1ID", (String)this.unit.getGroups().toArray(new Group[0])[0].getGroupID());
        CompositeInstallable_Test.assertEquals((String)"feature1Ref", (String)this.unit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().toArray(new String[0])[0]);
        CompositeInstallable_Test.assertEquals((String)"feature2Ref", (String)this.unit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().toArray(new String[0])[1]);
        CompositeInstallable_Test.assertEquals((String)"group2ID", (String)this.unit.getGroups().toArray(new Group[0])[1].getGroupID());
        CompositeInstallable_Test.assertEquals((String)"feature3Ref", (String)this.unit.getGroups().toArray(new Group[0])[1].getSelectedFeatures().toArray(new String[0])[0]);
        CompositeInstallable_Test.assertEquals((String)"feature4Ref", (String)this.unit.getGroups().toArray(new Group[0])[1].getSelectedFeatures().toArray(new String[0])[1]);
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getGroups().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getGroups().toArray(new Group[0])[1].getSelectedFeatures().size());
        CompositeInstallable_Test.assertEquals((String)"group1ID", (String)this.clonedUnit.getGroups().toArray(new Group[0])[0].getGroupID());
        CompositeInstallable_Test.assertEquals((String)"feature1Ref", (String)this.clonedUnit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().toArray(new String[0])[0]);
        CompositeInstallable_Test.assertEquals((String)"feature2Ref", (String)this.clonedUnit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().toArray(new String[0])[1]);
        CompositeInstallable_Test.assertEquals((String)"group2ID", (String)this.clonedUnit.getGroups().toArray(new Group[0])[1].getGroupID());
        CompositeInstallable_Test.assertEquals((String)"feature3Ref", (String)this.clonedUnit.getGroups().toArray(new Group[0])[1].getSelectedFeatures().toArray(new String[0])[0]);
        CompositeInstallable_Test.assertEquals((String)"feature4Ref", (String)this.clonedUnit.getGroups().toArray(new Group[0])[1].getSelectedFeatures().toArray(new String[0])[1]);
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[0], "SelectedFeature").size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[1], "SelectedFeature").size());
        CompositeInstallable_Test.assertEquals((String)"group1ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"feature1Ref", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[0], "SelectedFeature").toArray(new Element[0])[0].getAttribute("featureRef"));
        CompositeInstallable_Test.assertEquals((String)"feature2Ref", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[0], "SelectedFeature").toArray(new Element[0])[1].getAttribute("featureRef"));
        CompositeInstallable_Test.assertEquals((String)"group2ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"feature3Ref", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[1], "SelectedFeature").toArray(new Element[0])[0].getAttribute("featureRef"));
        CompositeInstallable_Test.assertEquals((String)"feature4Ref", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[1], "SelectedFeature").toArray(new Element[0])[1].getAttribute("featureRef"));
    }

    public void testGetLocalizationUnits() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getLocalizationUnits().size());
        CompositeInstallable_Test.assertEquals((String)"lu1ID", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"lu1ResourceRef", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"art1ContentRef", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getInstallArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((String)"lu2ID", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"lu2ResourceRef", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"art2ContentRef", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getInstallArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getLocalizationUnits().size());
        CompositeInstallable_Test.assertEquals((String)"lu1ID", (String)this.clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"lu1ResourceRef", (String)this.clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"art1ContentRef", (String)this.clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getInstallArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((String)"lu2ID", (String)this.clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"lu2ResourceRef", (String)this.clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"art2ContentRef", (String)this.clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getInstallArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").size());
        CompositeInstallable_Test.assertEquals((String)"lu1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"lu1ResourceRef", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeInstallable_Test.assertEquals((String)"art1ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeInstallable_Test.assertEquals((String)"lu2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"lu2ResourceRef", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[1].getAttribute("targetResourceRef"));
        CompositeInstallable_Test.assertEquals((String)"art2ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[1], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testGetRequiredBase() {
        CompositeInstallable_Test.assertEquals((String)"baseName", (String)this.unit.getRequiredBase().getDisplayName().getValue());
        CompositeInstallable_Test.assertEquals((String)"baseKey", (String)this.unit.getRequiredBase().getDisplayName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((String)"baseName", (String)this.clonedUnit.getRequiredBase().getDisplayName().getValue());
        CompositeInstallable_Test.assertEquals((String)"baseKey", (String)this.clonedUnit.getRequiredBase().getDisplayName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((String)"baseName", (String)this.session.getChildren(this.session.getChildren(this.element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"baseKey", (String)this.session.getChildren(this.session.getChildren(this.element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetRequirements() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getRequirements().size());
        CompositeInstallable_Test.assertEquals((String)"req1ID", (String)this.unit.getRequirements().toArray(new Requirement[0])[0].getRequirementID());
        CompositeInstallable_Test.assertEquals((String)"req2ID", (String)this.unit.getRequirements().toArray(new Requirement[0])[1].getRequirementID());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getRequirements().size());
        CompositeInstallable_Test.assertEquals((String)"req1ID", (String)this.clonedUnit.getRequirements().toArray(new Requirement[0])[0].getRequirementID());
        CompositeInstallable_Test.assertEquals((String)"req2ID", (String)this.clonedUnit.getRequirements().toArray(new Requirement[0])[1].getRequirementID());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "Requirements").toArray(new Element[0])[0], "Requirement").size());
        CompositeInstallable_Test.assertEquals((String)"req1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Requirements").toArray(new Element[0])[0], "Requirement").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"req2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Requirements").toArray(new Element[0])[0], "Requirement").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testGetResultingChanges() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getResultingChanges().size());
        CompositeInstallable_Test.assertEquals((String)"change1Name", (String)this.unit.getResultingChanges().toArray(new ResultingChange[0])[0].getName());
        CompositeInstallable_Test.assertEquals((String)"change2Name", (String)this.unit.getResultingChanges().toArray(new ResultingChange[0])[1].getName());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getResultingChanges().size());
        CompositeInstallable_Test.assertEquals((String)"change1Name", (String)this.clonedUnit.getResultingChanges().toArray(new ResultingChange[0])[0].getName());
        CompositeInstallable_Test.assertEquals((String)"change2Name", (String)this.clonedUnit.getResultingChanges().toArray(new ResultingChange[0])[1].getName());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "ResultingChange").size());
        CompositeInstallable_Test.assertEquals((String)"change1Name", (String)this.session.getChildren(this.session.getChildren(this.element, "ResultingChange").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"change2Name", (String)this.session.getChildren(this.session.getChildren(this.element, "ResultingChange").toArray(new Element[0])[1], "Name").toArray(new Element[0])[0].getTextContent());
    }

    public void testGetResultingResources() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getResultingResources().size());
        CompositeInstallable_Test.assertEquals((String)"res1Ref", (String)this.unit.getResultingResources().toArray(new ResultingResource[0])[0].getResourceReference());
        CompositeInstallable_Test.assertEquals((String)"res2Ref", (String)this.unit.getResultingResources().toArray(new ResultingResource[0])[1].getResourceReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getResultingResources().size());
        CompositeInstallable_Test.assertEquals((String)"res1Ref", (String)this.clonedUnit.getResultingResources().toArray(new ResultingResource[0])[0].getResourceReference());
        CompositeInstallable_Test.assertEquals((String)"res2Ref", (String)this.clonedUnit.getResultingResources().toArray(new ResultingResource[0])[1].getResourceReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "ResultingResource").size());
        CompositeInstallable_Test.assertEquals((String)"res1Ref", (String)this.session.getChildren(this.element, "ResultingResource").toArray(new Element[0])[0].getAttribute("resourceRef"));
        CompositeInstallable_Test.assertEquals((String)"res2Ref", (String)this.session.getChildren(this.element, "ResultingResource").toArray(new Element[0])[1].getAttribute("resourceRef"));
    }

    public void testGetSelectableCompositeUnits() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getSelectableCompositeUnits().size());
        CompositeInstallable_Test.assertEquals((String)"selCU1ID", (String)this.unit.getSelectableCompositeUnits().toArray(new CompositeUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"selCU2ID", (String)this.unit.getSelectableCompositeUnits().toArray(new CompositeUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getSelectableCompositeUnits().size());
        CompositeInstallable_Test.assertEquals((String)"selCU1ID", (String)this.clonedUnit.getSelectableCompositeUnits().toArray(new CompositeUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"selCU2ID", (String)this.clonedUnit.getSelectableCompositeUnits().toArray(new CompositeUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "CompositeUnit").size());
        CompositeInstallable_Test.assertEquals((String)"selCU1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "CompositeUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"selCU2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "CompositeUnit").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testGetSelectableConfigurationUnits() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getSelectableConfigurationUnits().size());
        CompositeInstallable_Test.assertEquals((String)"selCfg1ID", (String)this.unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"selCfg1ResourceRef", (String)this.unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"selArt1ContentRef", (String)this.unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getConfigurationArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((String)"selCfg2ID", (String)this.unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"selCfg2ResourceRef", (String)this.unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"selArt2ContentRef", (String)this.unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getConfigurationArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getSelectableConfigurationUnits().size());
        CompositeInstallable_Test.assertEquals((String)"selCfg1ID", (String)this.clonedUnit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"selCfg1ResourceRef", (String)this.clonedUnit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"selArt1ContentRef", (String)this.clonedUnit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getConfigurationArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((String)"selCfg2ID", (String)this.clonedUnit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"selCfg2ResourceRef", (String)this.clonedUnit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"selArt2ContentRef", (String)this.clonedUnit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getConfigurationArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").size());
        CompositeInstallable_Test.assertEquals((String)"selCfg1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"selCfg1ResourceRef", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeInstallable_Test.assertEquals((String)"selArt1ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "ConfigArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeInstallable_Test.assertEquals((String)"selCfg2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"selCfg2ResourceRef", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[1].getAttribute("targetResourceRef"));
        CompositeInstallable_Test.assertEquals((String)"selArt2ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[1], "Artifacts").toArray(new Element[0])[0], "ConfigArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testGetSelectableContainedPackages() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getSelectableContainedPackages().size());
        CompositeInstallable_Test.assertEquals((String)"selPackage1ID", (String)this.unit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"selPackage1Ref", (String)this.unit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeInstallable_Test.assertEquals((String)"selPackage2ID", (String)this.unit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"selPackage2Ref", (String)this.unit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getSelectableContainedPackages().size());
        CompositeInstallable_Test.assertEquals((String)"selPackage1ID", (String)this.clonedUnit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"selPackage1Ref", (String)this.clonedUnit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeInstallable_Test.assertEquals((String)"selPackage2ID", (String)this.clonedUnit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"selPackage2Ref", (String)this.clonedUnit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").size());
        CompositeInstallable_Test.assertEquals((String)"selPackage1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"selPackage1Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeInstallable_Test.assertEquals((String)"selPackage2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"selPackage2Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
    }

    public void testGetSelectableInstallableUnits() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getSelectableInstallableUnits().size());
        CompositeInstallable_Test.assertEquals((String)"selIU1ID", (String)this.unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"selIU1ResourceRef", (String)this.unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"selIUArt1ContentRef", (String)this.unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getInstallArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((String)"selIU2ID", (String)this.unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"selIU2ResourceRef", (String)this.unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[1].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"selIUArt2ContentRef", (String)this.unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[1].getInstallArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getSelectableInstallableUnits().size());
        CompositeInstallable_Test.assertEquals((String)"selIU1ID", (String)this.clonedUnit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"selIU1ResourceRef", (String)this.clonedUnit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"selIUArt1ContentRef", (String)this.clonedUnit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getInstallArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((String)"selIU2ID", (String)this.clonedUnit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[1].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"selIU2ResourceRef", (String)this.clonedUnit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[1].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"selIUArt2ContentRef", (String)this.clonedUnit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[1].getInstallArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").size());
        CompositeInstallable_Test.assertEquals((String)"selIU1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"selIU1ResourceRef", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeInstallable_Test.assertEquals((String)"selIUArt1ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeInstallable_Test.assertEquals((String)"selIU2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"selIU2ResourceRef", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[1].getAttribute("targetResourceRef"));
        CompositeInstallable_Test.assertEquals((String)"selIUArt2ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[1], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testGetContentUnitID() {
        CompositeInstallable_Test.assertEquals((String)"id", (String)this.unit.getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"id", (String)this.clonedUnit.getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"id", (String)this.element.getAttribute("id"));
    }

    public void testGetIdentityData() {
        CompositeInstallable_Test.assertEquals((String)"name", (String)this.unit.getIdentityData().getName().getValue());
        CompositeInstallable_Test.assertEquals((String)"nameKey", (String)this.unit.getIdentityData().getName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((String)"name", (String)this.clonedUnit.getIdentityData().getName().getValue());
        CompositeInstallable_Test.assertEquals((String)"nameKey", (String)this.clonedUnit.getIdentityData().getName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((String)"name", (String)this.session.getChildren(this.session.getChildren(this.element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"nameKey", (String)this.session.getChildren(this.session.getChildren(this.element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetDerivedVariables() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getDerivedVariables().size());
        CompositeInstallable_Test.assertEquals((String)"dvar1ID", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar1Expression", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeInstallable_Test.assertEquals((String)"dvar2ID", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar2Expression", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getExpression());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getDerivedVariables().size());
        CompositeInstallable_Test.assertEquals((String)"dvar1ID", (String)this.clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar1Expression", (String)this.clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeInstallable_Test.assertEquals((String)"dvar2ID", (String)this.clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar2Expression", (String)this.clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getExpression());
        CompositeInstallable_Test.assertEquals((int)4, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        CompositeInstallable_Test.assertEquals((String)"dvar1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"dvar1Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"dvar2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[3].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"dvar2Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[3], "Expression").toArray(new Element[0])[0].getTextContent());
    }

    public void testGetConditionalDerivedVariables() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getConditionalDerivedVariables().size());
        CompositeInstallable_Test.assertEquals((String)"var1ID", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"exp1Expression", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        CompositeInstallable_Test.assertEquals((String)"con1Name", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        CompositeInstallable_Test.assertEquals((String)"con1NameKey", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((String)"exp2Expression", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        CompositeInstallable_Test.assertEquals((String)"con2Name", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        CompositeInstallable_Test.assertEquals((String)"con2NameKey", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((String)"var2ID", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"exp3Expression", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        CompositeInstallable_Test.assertEquals((String)"con3Name", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        CompositeInstallable_Test.assertEquals((String)"con3NameKey", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((String)"exp4Expression", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        CompositeInstallable_Test.assertEquals((String)"con4Name", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        CompositeInstallable_Test.assertEquals((String)"con4NameKey", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getConditionalDerivedVariables().size());
        CompositeInstallable_Test.assertEquals((String)"var1ID", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"exp1Expression", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        CompositeInstallable_Test.assertEquals((String)"con1Name", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        CompositeInstallable_Test.assertEquals((String)"con1NameKey", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((String)"exp2Expression", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        CompositeInstallable_Test.assertEquals((String)"con2Name", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        CompositeInstallable_Test.assertEquals((String)"con2NameKey", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((String)"var2ID", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"exp3Expression", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        CompositeInstallable_Test.assertEquals((String)"con3Name", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        CompositeInstallable_Test.assertEquals((String)"con3NameKey", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((String)"exp4Expression", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        CompositeInstallable_Test.assertEquals((String)"con4Name", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        CompositeInstallable_Test.assertEquals((String)"con4NameKey", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((int)4, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        CompositeInstallable_Test.assertEquals((String)"var1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"exp1Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"con1Name", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"con1NameKey", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
        CompositeInstallable_Test.assertEquals((String)"exp2Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[1], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"con2Name", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"con2NameKey", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
        CompositeInstallable_Test.assertEquals((String)"var2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"exp3Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"con3Name", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"con3NameKey", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
        CompositeInstallable_Test.assertEquals((String)"exp4Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[1], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"con4Name", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"con4NameKey", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetResourceProperties() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getResourceProperties().size());
        CompositeInstallable_Test.assertEquals((String)"prop1ID", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"prop1Ref", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getResourceReference());
        CompositeInstallable_Test.assertEquals((String)"prop2ID", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[1].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"prop2Ref", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[1].getResourceReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getResourceProperties().size());
        CompositeInstallable_Test.assertEquals((String)"prop1ID", (String)this.clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"prop1Ref", (String)this.clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[0].getResourceReference());
        CompositeInstallable_Test.assertEquals((String)"prop2ID", (String)this.clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[1].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"prop2Ref", (String)this.clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[1].getResourceReference());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").size());
        CompositeInstallable_Test.assertEquals((String)"prop1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"prop1Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("resourceRef"));
        CompositeInstallable_Test.assertEquals((String)"prop2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"prop2Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[1].getAttribute("resourceRef"));
    }

    public void testGetParameterGroups() {
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getParameterGroups().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().size());
        CompositeInstallable_Test.assertEquals((String)"param1ID", (String)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        CompositeInstallable_Test.assertEquals((String)"param2ID", (String)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        CompositeInstallable_Test.assertEquals((String)"param3ID", (String)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        CompositeInstallable_Test.assertEquals((String)"param4ID", (String)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getParameterGroups().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().size());
        CompositeInstallable_Test.assertEquals((String)"param1ID", (String)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        CompositeInstallable_Test.assertEquals((String)"param2ID", (String)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        CompositeInstallable_Test.assertEquals((String)"param3ID", (String)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        CompositeInstallable_Test.assertEquals((String)"param4ID", (String)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").size());
        CompositeInstallable_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[1], "BooleanParameter").size());
        CompositeInstallable_Test.assertEquals((String)"param1ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"param2ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"param3ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[1], "BooleanParameter").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"param4ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[1], "BooleanParameter").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testSetBaseCompositeUnits() {
        CompositeUnit baseUnit1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("baseCU3ID");
        this.unit.setBaseCompositeUnits((Collection<CompositeUnit>)Arrays.asList(baseUnit1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getBaseCompositeUnits().size());
        CompositeInstallable_Test.assertEquals((String)"baseCU3ID", (String)this.unit.getBaseCompositeUnits().toArray(new CompositeUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "CompositeUnit").size());
        CompositeInstallable_Test.assertEquals((String)"baseCU3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "CompositeUnit").toArray(new Element[0])[0].getAttribute("id"));
    }

    public void testSetBaseConfigurationUnits() {
        Artifact baseArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createConfigArtifact();
        baseArt1.setContentReference("baseArt3ContentRef");
        ConfigurationUnit baseCfg1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConfigurationUnit("baseCfg3ID", "baseCfg3ResourceRef", baseArt1);
        this.unit.setBaseConfigurationUnits((Collection<ConfigurationUnit>)Arrays.asList(baseCfg1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getBaseConfigurationUnits().size());
        CompositeInstallable_Test.assertEquals((String)"baseCfg3ID", (String)this.unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"baseCfg3ResourceRef", (String)this.unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"baseArt3ContentRef", (String)this.unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getConfigurationArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").size());
        CompositeInstallable_Test.assertEquals((String)"baseCfg3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"baseCfg3ResourceRef", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeInstallable_Test.assertEquals((String)"baseArt3ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "ConfigArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetBaseContainedPackages() {
        ReferencedPackage basePackage1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedPackage("basePackage3Ref", "basePackage3ID");
        this.unit.setBaseContainedPackages((Collection<ReferencedPackage>)Arrays.asList(basePackage1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getBaseContainedPackages().size());
        CompositeInstallable_Test.assertEquals((String)"basePackage3ID", (String)this.unit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"basePackage3Ref", (String)this.unit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").size());
        CompositeInstallable_Test.assertEquals((String)"basePackage3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"basePackage3Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetBaseInstallableUnits() {
        Artifact baseIUArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        baseIUArt1.setContentReference("baseIUArt3ContentRef");
        InstallableUnit baseIU1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createInstallableUnit("baseIU3ID", "baseIU3ResourceRef", baseIUArt1, 0);
        this.unit.setBaseInstallableUnits((Collection<InstallableUnit>)Arrays.asList(baseIU1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getBaseInstallableUnits().size());
        CompositeInstallable_Test.assertEquals((String)"baseIU3ID", (String)this.unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"baseIU3ResourceRef", (String)this.unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"baseIUArt3ContentRef", (String)this.unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getInstallArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").size());
        CompositeInstallable_Test.assertEquals((String)"baseIU3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"baseIU3ResourceRef", (String)this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeInstallable_Test.assertEquals((String)"baseIUArt3ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetMandatoryLanguages() {
        Language manLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("manLang3Type");
        this.unit.setMandatoryLanguages((Collection<Language>)Arrays.asList(manLang1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getMandatoryLanguages().size());
        CompositeInstallable_Test.assertEquals((String)"manLang3Type", (String)this.unit.getMandatoryLanguages().toArray(new Language[0])[0].getType());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Mandatory").toArray(new Element[0])[0], "Language").size());
        CompositeInstallable_Test.assertEquals((String)"manLang3Type", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Mandatory").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
    }

    public void testSetOptionalLanguages() {
        Language optLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("optLang3Type");
        this.unit.setOptionalLanguages((Collection<Language>)Arrays.asList(optLang1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getOptionalLanguages().size());
        CompositeInstallable_Test.assertEquals((String)"optLang3Type", (String)this.unit.getOptionalLanguages().toArray(new Language[0])[0].getType());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "Language").size());
        CompositeInstallable_Test.assertEquals((String)"optLang3Type", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
    }

    public void testSetOptionalLanguageSets() {
        Language setLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("setLang4Type");
        LanguageSet langSet1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguageSet((Collection<Language>)Arrays.asList(setLang1));
        this.unit.setOptionalLanguageSets((Collection<LanguageSet>)Arrays.asList(langSet1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getOptionalLanguageSets().size());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().size());
        CompositeInstallable_Test.assertEquals((String)"setLang4Type", (String)this.unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[0].getType());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").size());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[0], "Language").size());
        CompositeInstallable_Test.assertEquals((String)"setLang4Type", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
    }

    public void testSetCompositeLocalizationUnits() {
        ReferencedPackage package8 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package8Ref", "package8ID");
        CompositeLocalizationUnit comploc3 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeLocalizationUnitWithContainedLocalizationPackages("comploc3ID", (Collection<ReferencedPackage>)Arrays.asList(package8));
        this.unit.setCompositeLocalizationUnits((Collection<CompositeLocalizationUnit>)Arrays.asList(comploc3));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getCompositeLocalizationUnits().size());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().size());
        CompositeInstallable_Test.assertEquals((String)"comploc3ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"package8ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"package8Ref", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").size());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").size());
        CompositeInstallable_Test.assertEquals((String)"comploc3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"package8ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"package8Ref", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetCondition() {
        Condition condition = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        condition.setDisplayName(new TranslatableString("differentName", "differentNameKey"));
        this.unit.setCondition(condition);
        CompositeInstallable_Test.assertEquals((String)"differentName", (String)this.unit.getCondition().getDisplayName().getValue());
        CompositeInstallable_Test.assertEquals((String)"differentNameKey", (String)this.unit.getCondition().getDisplayName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((String)"differentName", (String)this.session.getChildren(this.session.getChildren(this.element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"differentNameKey", (String)this.session.getChildren(this.session.getChildren(this.element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetContainedLocalizationPackages() {
        ReferencedPackage package1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package7Ref", "package7ID");
        this.unit.setContainedLocalizationPackages((Collection<ReferencedPackage>)Arrays.asList(package1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getContainedLocalizationPackages().size());
        CompositeInstallable_Test.assertEquals((String)"package7ID", (String)this.unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"package7Ref", (String)this.unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").size());
        CompositeInstallable_Test.assertEquals((String)"package7ID", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"package7Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetFeatures() {
        DerivedVariable dvar7 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("dvar7ID", "dvar7Expression");
        Feature feature3 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createFeatureWithDerivedVariables("feature3ID", (Collection<DerivedVariable>)Arrays.asList(dvar7));
        DerivedVariable dvar8 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("dvar8ID", "dvar8Expression");
        Feature feature4 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createFeatureWithDerivedVariables("feature4ID", (Collection<DerivedVariable>)Arrays.asList(dvar8));
        DerivedVariable dvar9 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("dvar9ID", "dvar9Expression");
        Feature feature5 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createFeatureWithDerivedVariables("feature5ID", (Collection<DerivedVariable>)Arrays.asList(dvar9));
        this.unit.setFeatures((Collection<Feature>)Arrays.asList(feature3, feature4, feature5));
        CompositeInstallable_Test.assertEquals((int)3, (int)this.unit.getFeatures().size());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getFeatures().toArray(new Feature[0])[0].getVariables().size());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getFeatures().toArray(new Feature[0])[1].getVariables().size());
        CompositeInstallable_Test.assertEquals((String)"feature3ID", (String)this.unit.getFeatures().toArray(new Feature[0])[0].getFeatureID());
        CompositeInstallable_Test.assertEquals((String)"feature4ID", (String)this.unit.getFeatures().toArray(new Feature[0])[1].getFeatureID());
        CompositeInstallable_Test.assertEquals((String)"feature5ID", (String)this.unit.getFeatures().toArray(new Feature[0])[2].getFeatureID());
        CompositeInstallable_Test.assertEquals((String)"dvar7ID", (String)this.unit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar7Expression", (String)this.unit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeInstallable_Test.assertEquals((String)"dvar8ID", (String)this.unit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar8Expression", (String)this.unit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeInstallable_Test.assertEquals((String)"dvar9ID", (String)this.unit.getFeatures().toArray(new Feature[0])[2].getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar9Expression", (String)this.unit.getFeatures().toArray(new Feature[0])[2].getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeInstallable_Test.assertEquals((int)3, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").size());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").size());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").size());
        CompositeInstallable_Test.assertEquals((String)"feature3ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"feature4ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"feature5ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[2].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"dvar7ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"dvar7Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"dvar8ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"dvar8Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"dvar9ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[2], "Variable").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"dvar9Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[2], "Variable").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetMultiFeatureSelects() {
        MultiFeatureSelect multi1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createMultiFeatureSelect((Collection<String>)Arrays.asList("multiFeature5", "multiFeature6", "multiFeature7"));
        this.unit.setMultiFeatureSelects((Collection<MultiFeatureSelect>)Arrays.asList(multi1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getMultiFeatureSelects().size());
        CompositeInstallable_Test.assertEquals((int)3, (int)this.unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().size());
        CompositeInstallable_Test.assertEquals((String)"multiFeature5", (String)this.unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().toArray(new String[0])[0]);
        CompositeInstallable_Test.assertEquals((String)"multiFeature6", (String)this.unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().toArray(new String[0])[1]);
        CompositeInstallable_Test.assertEquals((String)"multiFeature7", (String)this.unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().toArray(new String[0])[2]);
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").size());
        CompositeInstallable_Test.assertEquals((int)3, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[0], "Feature").size());
        CompositeInstallable_Test.assertEquals((String)"multiFeature5", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0].getAttribute("featureRef"));
        CompositeInstallable_Test.assertEquals((String)"multiFeature6", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1].getAttribute("featureRef"));
        CompositeInstallable_Test.assertEquals((String)"multiFeature7", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[2].getAttribute("featureRef"));
    }

    public void testSetGroups() {
        Group group1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createGroup("group3ID", (Collection<String>)Arrays.asList("feature3Ref"));
        this.unit.setGroups((Collection<Group>)Arrays.asList(group1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getGroups().size());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().size());
        CompositeInstallable_Test.assertEquals((String)"group3ID", (String)this.unit.getGroups().toArray(new Group[0])[0].getGroupID());
        CompositeInstallable_Test.assertEquals((String)"feature3Ref", (String)this.unit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().toArray(new String[0])[0]);
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").size());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[0], "SelectedFeature").size());
        CompositeInstallable_Test.assertEquals((String)"group3ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"feature3Ref", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[0], "SelectedFeature").toArray(new Element[0])[0].getAttribute("featureRef"));
    }

    public void testSetLocalizationUnits() {
        Artifact art1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        art1.setContentReference("art3ContentRef");
        LocalizationUnit lu1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLocalizationUnit("lu3ID", "lu3ResourceRef", art1, 0);
        this.unit.setLocalizationUnits((Collection<LocalizationUnit>)Arrays.asList(lu1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getLocalizationUnits().size());
        CompositeInstallable_Test.assertEquals((String)"lu3ID", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"lu3ResourceRef", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"art3ContentRef", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getInstallArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").size());
        CompositeInstallable_Test.assertEquals((String)"lu3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"lu3ResourceRef", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeInstallable_Test.assertEquals((String)"art3ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetRequiredBase() {
        RequiredBase base = SPISession.DEFAULT_INSTANCE.createRequiredBaseFactory().createRequiredBase();
        base.setDisplayName(new TranslatableString("differentName", "differentKey"));
        this.unit.setRequiredBase(base);
        CompositeInstallable_Test.assertEquals((String)"differentName", (String)this.unit.getRequiredBase().getDisplayName().getValue());
        CompositeInstallable_Test.assertEquals((String)"differentKey", (String)this.unit.getRequiredBase().getDisplayName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((String)"differentName", (String)this.session.getChildren(this.session.getChildren(this.element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"differentKey", (String)this.session.getChildren(this.session.getChildren(this.element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetRequirements() {
        Requirement req1 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req3ID");
        this.unit.setRequirements((Collection<Requirement>)Arrays.asList(req1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getRequirements().size());
        CompositeInstallable_Test.assertEquals((String)"req3ID", (String)this.unit.getRequirements().toArray(new Requirement[0])[0].getRequirementID());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "Requirements").toArray(new Element[0])[0], "Requirement").size());
        CompositeInstallable_Test.assertEquals((String)"req3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Requirements").toArray(new Element[0])[0], "Requirement").toArray(new Element[0])[0].getAttribute("id"));
    }

    public void testSetResultingChanges() {
        ResultingChange change1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingChange();
        change1.setName("change3Name");
        this.unit.setResultingChanges((Collection<ResultingChange>)Arrays.asList(change1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getResultingChanges().size());
        CompositeInstallable_Test.assertEquals((String)"change3Name", (String)this.unit.getResultingChanges().toArray(new ResultingChange[0])[0].getName());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "ResultingChange").size());
        CompositeInstallable_Test.assertEquals((String)"change3Name", (String)this.session.getChildren(this.session.getChildren(this.element, "ResultingChange").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetResultingResources() {
        ResultingResource res1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingResource("res3Ref");
        this.unit.setResultingResources((Collection<ResultingResource>)Arrays.asList(res1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getResultingResources().size());
        CompositeInstallable_Test.assertEquals((String)"res3Ref", (String)this.unit.getResultingResources().toArray(new ResultingResource[0])[0].getResourceReference());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "ResultingResource").size());
        CompositeInstallable_Test.assertEquals((String)"res3Ref", (String)this.session.getChildren(this.element, "ResultingResource").toArray(new Element[0])[0].getAttribute("resourceRef"));
    }

    public void testSetSelectableCompositeUnits() {
        CompositeUnit selUnit1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("selCU3ID");
        this.unit.setSelectableCompositeUnits((Collection<CompositeUnit>)Arrays.asList(selUnit1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getSelectableCompositeUnits().size());
        CompositeInstallable_Test.assertEquals((String)"selCU3ID", (String)this.unit.getSelectableCompositeUnits().toArray(new CompositeUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "CompositeUnit").size());
        CompositeInstallable_Test.assertEquals((String)"selCU3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "CompositeUnit").toArray(new Element[0])[0].getAttribute("id"));
    }

    public void testSetSelectableConfigurationUnits() {
        Artifact selArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createConfigArtifact();
        selArt1.setContentReference("selArt3ContentRef");
        ConfigurationUnit selCfg1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConfigurationUnit("selCfg3ID", "selCfg3ResourceRef", selArt1);
        this.unit.setSelectableConfigurationUnits((Collection<ConfigurationUnit>)Arrays.asList(selCfg1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getSelectableConfigurationUnits().size());
        CompositeInstallable_Test.assertEquals((String)"selCfg3ID", (String)this.unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"selCfg3ResourceRef", (String)this.unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"selArt3ContentRef", (String)this.unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getConfigurationArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").size());
        CompositeInstallable_Test.assertEquals((String)"selCfg3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"selCfg3ResourceRef", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeInstallable_Test.assertEquals((String)"selArt3ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "ConfigArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetSelectableContainedPackages() {
        ReferencedPackage selPackage1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedPackage("selPackage3Ref", "selPackage3ID");
        this.unit.setSelectableContainedPackages((Collection<ReferencedPackage>)Arrays.asList(selPackage1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getSelectableContainedPackages().size());
        CompositeInstallable_Test.assertEquals((String)"selPackage3ID", (String)this.unit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeInstallable_Test.assertEquals((String)"selPackage3Ref", (String)this.unit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").size());
        CompositeInstallable_Test.assertEquals((String)"selPackage3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"selPackage3Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetSelectableInstallableUnits() {
        Artifact selIUArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        selIUArt1.setContentReference("selIUArt3ContentRef");
        InstallableUnit selIU1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createInstallableUnit("selIU3ID", "selIU3ResourceRef", selIUArt1, 0);
        this.unit.setSelectableInstallableUnits((Collection<InstallableUnit>)Arrays.asList(selIU1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getSelectableInstallableUnits().size());
        CompositeInstallable_Test.assertEquals((String)"selIU3ID", (String)this.unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"selIU3ResourceRef", (String)this.unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getTargetResourceReference());
        CompositeInstallable_Test.assertEquals((String)"selIUArt3ContentRef", (String)this.unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getInstallArtifact().getContentReference());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").size());
        CompositeInstallable_Test.assertEquals((String)"selIU3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"selIU3ResourceRef", (String)this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeInstallable_Test.assertEquals((String)"selIUArt3ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetContentUnitID() {
        this.unit.setContentUnitID("differentID");
        CompositeInstallable_Test.assertEquals((String)"differentID", (String)this.unit.getContentUnitID());
        CompositeInstallable_Test.assertEquals((String)"differentID", (String)this.element.getAttribute("id"));
    }

    public void testSetIdentityData() {
        Identity identity = SPISession.DEFAULT_INSTANCE.createBaseFactory().createIdentity(new TranslatableString("differentName", "differentNameKey"));
        this.unit.setIdentityData(identity);
        CompositeInstallable_Test.assertEquals((String)"differentName", (String)this.unit.getIdentityData().getName().getValue());
        CompositeInstallable_Test.assertEquals((String)"differentNameKey", (String)this.unit.getIdentityData().getName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((String)"differentName", (String)this.session.getChildren(this.session.getChildren(this.element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"differentNameKey", (String)this.session.getChildren(this.session.getChildren(this.element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetResourceProperties() {
        ResourceProperty prop1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createResourceProperty("prop3ID", "prop3Ref");
        this.unit.setResourceProperties((Collection<ResourceProperty>)Arrays.asList(prop1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getResourceProperties().size());
        CompositeInstallable_Test.assertEquals((String)"prop3ID", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"prop3Ref", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getResourceReference());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").size());
        CompositeInstallable_Test.assertEquals((String)"prop3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"prop3Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("resourceRef"));
    }

    public void testSetDerivedVariables() {
        DerivedVariable dvar1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("dvar3ID", "dvar3Expression");
        this.unit.setDerivedVariables((Collection<DerivedVariable>)Arrays.asList(dvar1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getDerivedVariables().size());
        CompositeInstallable_Test.assertEquals((String)"dvar3ID", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"dvar3Expression", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeInstallable_Test.assertEquals((int)3, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        CompositeInstallable_Test.assertEquals((String)"dvar3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"dvar3Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "Expression").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetConditionalDerivedVariables() {
        Condition con1 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con1.setDisplayName(new TranslatableString("con5Name", "con5NameKey"));
        ConditionalDerivedVariableExpression exp1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp3Expression", con1);
        ConditionalDerivedVariable var1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariable("var3ID", (Collection<ConditionalDerivedVariableExpression>)Arrays.asList(exp1));
        this.unit.setConditionalDerivedVariables((Collection<ConditionalDerivedVariable>)Arrays.asList(var1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getConditionalDerivedVariables().size());
        CompositeInstallable_Test.assertEquals((String)"var3ID", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getVariableID());
        CompositeInstallable_Test.assertEquals((String)"exp3Expression", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        CompositeInstallable_Test.assertEquals((String)"con5Name", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        CompositeInstallable_Test.assertEquals((String)"con5NameKey", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        CompositeInstallable_Test.assertEquals((int)3, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        CompositeInstallable_Test.assertEquals((String)"var3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2].getAttribute("id"));
        CompositeInstallable_Test.assertEquals((String)"exp3Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "ConditionalExpression").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"con5Name", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeInstallable_Test.assertEquals((String)"con5NameKey", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetParameterGroups() {
        BooleanParameter param1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param5ID");
        ParameterGroup group1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createParameterGroup();
        group1.setBooleanParameters((Collection<BooleanParameter>)Arrays.asList(param1));
        this.unit.setParameterGroups((Collection<ParameterGroup>)Arrays.asList(group1));
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getParameterGroups().size());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().size());
        CompositeInstallable_Test.assertEquals((String)"param5ID", (String)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").size());
        CompositeInstallable_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").size());
        CompositeInstallable_Test.assertEquals((String)"param5ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").toArray(new Element[0])[0].getAttribute("id"));
    }
}

