/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.InternalDependency;
import org.w3c.dom.Element;

public class InternalDependency_Test
extends TestCase {
    InternalDependency dep;
    InternalDependency clonedDep;
    Element element;
    SPISessionImpl session;

    public InternalDependency_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.dep = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createInternalDependency("contentRef");
        this.dep.setContentReferenceOperations((Collection<String>)Arrays.asList("op1", "op2"));
        this.dep.setDescription(new TranslatableString("desc", "descKey"));
        this.dep.setShortDescription(new TranslatableString("shortDesc", "shortDescKey"));
        this.dep.setType("depType");
        this.clonedDep = (InternalDependency)this.dep.clone();
        this.element = ((SPIDataObject)((Object)this.dep)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        Properties props = this.dep.getTranslatableStrings();
        Properties clonedProps = this.clonedDep.getTranslatableStrings();
        InternalDependency_Test.assertEquals((int)2, (int)props.keySet().size());
        InternalDependency_Test.assertEquals((int)2, (int)clonedProps.keySet().size());
        InternalDependency_Test.assertEquals((Object)"desc", (Object)props.get("descKey"));
        InternalDependency_Test.assertEquals((Object)"shortDesc", (Object)props.get("shortDescKey"));
        InternalDependency_Test.assertEquals((Object)"desc", (Object)clonedProps.get("descKey"));
        InternalDependency_Test.assertEquals((Object)"shortDesc", (Object)clonedProps.get("shortDescKey"));
    }

    public void testGetContentReference() {
        InternalDependency_Test.assertEquals((String)"contentRef", (String)this.dep.getContentReference());
        InternalDependency_Test.assertEquals((String)"contentRef", (String)this.clonedDep.getContentReference());
        InternalDependency_Test.assertEquals((String)"contentRef", (String)this.element.getAttribute("contentElementRef"));
    }

    public void testGetContentReferenceOperations() {
        InternalDependency_Test.assertEquals((String)"op1", (String)this.dep.getContentReferenceOperations().toArray(new String[0])[0]);
        InternalDependency_Test.assertEquals((String)"op2", (String)this.dep.getContentReferenceOperations().toArray(new String[0])[1]);
        InternalDependency_Test.assertEquals((String)"op1", (String)this.clonedDep.getContentReferenceOperations().toArray(new String[0])[0]);
        InternalDependency_Test.assertEquals((String)"op2", (String)this.clonedDep.getContentReferenceOperations().toArray(new String[0])[1]);
        InternalDependency_Test.assertEquals((String)"op1", (String)this.element.getAttribute("contentElementRefOperation").split(" ")[0]);
        InternalDependency_Test.assertEquals((String)"op2", (String)this.element.getAttribute("contentElementRefOperation").split(" ")[1]);
    }

    public void testGetType() {
        InternalDependency_Test.assertEquals((String)"depType", (String)this.dep.getType());
        InternalDependency_Test.assertEquals((String)"depType", (String)this.clonedDep.getType());
        InternalDependency_Test.assertEquals((String)"depType", (String)this.element.getAttribute("type"));
    }

    public void testGetDescription() {
        InternalDependency_Test.assertEquals((String)"desc", (String)this.dep.getDescription().getValue());
        InternalDependency_Test.assertEquals((String)"descKey", (String)this.dep.getDescription().getTranslationKey());
        InternalDependency_Test.assertEquals((String)"desc", (String)this.clonedDep.getDescription().getValue());
        InternalDependency_Test.assertEquals((String)"descKey", (String)this.clonedDep.getDescription().getTranslationKey());
        InternalDependency_Test.assertEquals((String)"desc", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        InternalDependency_Test.assertEquals((String)"descKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetShortDescription() {
        InternalDependency_Test.assertEquals((String)"shortDesc", (String)this.dep.getShortDescription().getValue());
        InternalDependency_Test.assertEquals((String)"shortDescKey", (String)this.dep.getShortDescription().getTranslationKey());
        InternalDependency_Test.assertEquals((String)"shortDesc", (String)this.clonedDep.getShortDescription().getValue());
        InternalDependency_Test.assertEquals((String)"shortDescKey", (String)this.clonedDep.getShortDescription().getTranslationKey());
        InternalDependency_Test.assertEquals((String)"shortDesc", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        InternalDependency_Test.assertEquals((String)"shortDescKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetContentReference() {
        this.dep.setContentReference("differentRef");
        InternalDependency_Test.assertEquals((String)"differentRef", (String)this.dep.getContentReference());
        InternalDependency_Test.assertEquals((String)"differentRef", (String)this.element.getAttribute("contentElementRef"));
        try {
            this.dep.setContentReference(null);
            InternalDependency_Test.fail((String)"ContentReference set to null");
        }
        catch (Exception exception) {}
    }

    public void testSetContentReferenceOperations() {
        this.dep.setContentReferenceOperations((Collection<String>)Arrays.asList("op3"));
        InternalDependency_Test.assertEquals((String)"op3", (String)this.dep.getContentReferenceOperations().toArray(new String[0])[0]);
        InternalDependency_Test.assertEquals((String)"op3", (String)this.element.getAttribute("contentElementRefOperation").split(",")[0]);
    }

    public void testSetType() {
        this.dep.setType("differentType");
        InternalDependency_Test.assertEquals((String)"differentType", (String)this.dep.getType());
        InternalDependency_Test.assertEquals((String)"differentType", (String)this.element.getAttribute("type"));
    }

    public void testSetDescription() {
        this.dep.setDescription(new TranslatableString("differentDesc", "differentDescKey"));
        InternalDependency_Test.assertEquals((String)"differentDesc", (String)this.dep.getDescription().getValue());
        InternalDependency_Test.assertEquals((String)"differentDescKey", (String)this.dep.getDescription().getTranslationKey());
        InternalDependency_Test.assertEquals((String)"differentDesc", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        InternalDependency_Test.assertEquals((String)"differentDescKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetShortDescription() {
        this.dep.setShortDescription(new TranslatableString("differentShortDesc", "differentShortDescKey"));
        InternalDependency_Test.assertEquals((String)"differentShortDesc", (String)this.dep.getShortDescription().getValue());
        InternalDependency_Test.assertEquals((String)"differentShortDescKey", (String)this.dep.getShortDescription().getTranslationKey());
        InternalDependency_Test.assertEquals((String)"differentShortDesc", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        InternalDependency_Test.assertEquals((String)"differentShortDescKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }
}

