/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConstrainedResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Multiplicity;
import org.w3c.dom.Element;

public class Multiplicity_Test
extends TestCase {
    Multiplicity multiplicity;
    Multiplicity clonedMultiplicity;
    Element element;
    SPISessionImpl session;

    public Multiplicity_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.multiplicity = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createMultiplicity(Boolean.TRUE);
        ConstrainedResource conRes1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConstrainedResource("resource1");
        ConstrainedResource conRes2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConstrainedResource("resource2");
        this.multiplicity.setConstrainedFeatures((Collection<String>)Arrays.asList("feature1", "feature2"));
        this.multiplicity.setConstrainedResources((Collection<ConstrainedResource>)Arrays.asList(conRes1, conRes2));
        this.multiplicity.setMaxSelections(BigInteger.valueOf(5L));
        this.multiplicity.setMinSelections(BigInteger.valueOf(4L));
        this.clonedMultiplicity = (Multiplicity)this.multiplicity.clone();
        this.element = ((SPIDataObject)((Object)this.multiplicity)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)((Object)this.multiplicity)).getTranslatableStrings();
        Multiplicity_Test.assertEquals((int)0, (int)props.keySet().size());
    }

    public void testGetConstrainedFeatures() {
        Multiplicity_Test.assertEquals((int)2, (int)this.multiplicity.getConstrainedFeatures().size());
        Multiplicity_Test.assertEquals((int)2, (int)this.clonedMultiplicity.getConstrainedFeatures().size());
        Multiplicity_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "ConstrainedFeature").size());
        Multiplicity_Test.assertEquals((String)"feature1", (String)this.multiplicity.getConstrainedFeatures().toArray(new String[0])[0]);
        Multiplicity_Test.assertEquals((String)"feature2", (String)this.multiplicity.getConstrainedFeatures().toArray(new String[0])[1]);
        Multiplicity_Test.assertEquals((String)"feature1", (String)this.clonedMultiplicity.getConstrainedFeatures().toArray(new String[0])[0]);
        Multiplicity_Test.assertEquals((String)"feature2", (String)this.clonedMultiplicity.getConstrainedFeatures().toArray(new String[0])[1]);
        Multiplicity_Test.assertEquals((String)"feature1", (String)this.session.getChildren(this.element, "ConstrainedFeature").toArray(new Element[0])[0].getAttribute("featureRef"));
        Multiplicity_Test.assertEquals((String)"feature2", (String)this.session.getChildren(this.element, "ConstrainedFeature").toArray(new Element[0])[1].getAttribute("featureRef"));
    }

    public void testGetConstrainedResources() {
        Multiplicity_Test.assertEquals((int)2, (int)this.multiplicity.getConstrainedResources().size());
        Multiplicity_Test.assertEquals((int)2, (int)this.clonedMultiplicity.getConstrainedResources().size());
        Multiplicity_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "ConstrainedResource").size());
        Multiplicity_Test.assertEquals((String)"resource1", (String)this.multiplicity.getConstrainedResources().toArray(new ConstrainedResource[0])[0].getResourceRef());
        Multiplicity_Test.assertEquals((String)"resource2", (String)this.multiplicity.getConstrainedResources().toArray(new ConstrainedResource[0])[1].getResourceRef());
        Multiplicity_Test.assertEquals((String)"resource1", (String)this.clonedMultiplicity.getConstrainedResources().toArray(new ConstrainedResource[0])[0].getResourceRef());
        Multiplicity_Test.assertEquals((String)"resource2", (String)this.clonedMultiplicity.getConstrainedResources().toArray(new ConstrainedResource[0])[1].getResourceRef());
        Multiplicity_Test.assertEquals((String)"resource1", (String)this.session.getChildren(this.element, "ConstrainedResource").toArray(new Element[0])[0].getAttribute("resourceRef"));
        Multiplicity_Test.assertEquals((String)"resource2", (String)this.session.getChildren(this.element, "ConstrainedResource").toArray(new Element[0])[1].getAttribute("resourceRef"));
    }

    public void testGetMaxSelections() {
        Multiplicity_Test.assertEquals((int)5, (int)this.multiplicity.getMaxSelections().intValue());
        Multiplicity_Test.assertEquals((int)5, (int)this.clonedMultiplicity.getMaxSelections().intValue());
        Multiplicity_Test.assertEquals((int)5, (int)Integer.parseInt(this.element.getAttribute("maxSelections")));
    }

    public void testGetMinSelections() {
        Multiplicity_Test.assertEquals((int)4, (int)this.multiplicity.getMinSelections().intValue());
        Multiplicity_Test.assertEquals((int)4, (int)this.clonedMultiplicity.getMinSelections().intValue());
        Multiplicity_Test.assertEquals((int)4, (int)Integer.parseInt(this.element.getAttribute("minSelections")));
    }

    public void testGetMultiplesAllowed() {
        Multiplicity_Test.assertTrue((boolean)this.multiplicity.getMultiplesAllowed());
        Multiplicity_Test.assertTrue((boolean)this.clonedMultiplicity.getMultiplesAllowed());
        Multiplicity_Test.assertTrue((boolean)Boolean.parseBoolean(this.element.getAttribute("multiplesAllowed")));
    }

    public void testSetConstrainedFeatures() {
        this.multiplicity.setConstrainedFeatures((Collection<String>)Arrays.asList("feature3"));
        Multiplicity_Test.assertEquals((int)1, (int)this.multiplicity.getConstrainedFeatures().size());
        Multiplicity_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "ConstrainedFeature").size());
        Multiplicity_Test.assertEquals((String)"feature3", (String)this.multiplicity.getConstrainedFeatures().toArray(new String[0])[0]);
        Multiplicity_Test.assertEquals((String)"feature3", (String)this.session.getChildren(this.element, "ConstrainedFeature").toArray(new Element[0])[0].getAttribute("featureRef"));
    }

    public void testSetConstrainedResources() {
        ConstrainedResource conRes3 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConstrainedResource("resource3");
        this.multiplicity.setConstrainedResources((Collection<ConstrainedResource>)Arrays.asList(conRes3));
        Multiplicity_Test.assertEquals((int)1, (int)this.multiplicity.getConstrainedResources().size());
        Multiplicity_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "ConstrainedResource").size());
        Multiplicity_Test.assertEquals((String)"resource3", (String)this.multiplicity.getConstrainedResources().toArray(new ConstrainedResource[0])[0].getResourceRef());
        Multiplicity_Test.assertEquals((String)"resource3", (String)this.session.getChildren(this.element, "ConstrainedResource").toArray(new Element[0])[0].getAttribute("resourceRef"));
    }

    public void testSetMaxSelections() {
        this.multiplicity.setMaxSelections(BigInteger.valueOf(6L));
        Multiplicity_Test.assertEquals((int)6, (int)this.multiplicity.getMaxSelections().intValue());
        Multiplicity_Test.assertEquals((int)6, (int)Integer.parseInt(this.element.getAttribute("maxSelections")));
    }

    public void testSetMinSelections() {
        this.multiplicity.setMinSelections(BigInteger.valueOf(2L));
        Multiplicity_Test.assertEquals((int)2, (int)this.multiplicity.getMinSelections().intValue());
        Multiplicity_Test.assertEquals((int)2, (int)Integer.parseInt(this.element.getAttribute("minSelections")));
    }

    public void testSetMultiplesAllowed() {
        this.multiplicity.setMultiplesAllowed(Boolean.FALSE);
        Multiplicity_Test.assertFalse((boolean)this.multiplicity.getMultiplesAllowed());
        Multiplicity_Test.assertFalse((boolean)Boolean.parseBoolean(this.element.getAttribute("multiplesAllowed")));
        try {
            this.multiplicity.setMultiplesAllowed(null);
            Multiplicity_Test.fail((String)"MulitplesAllowed set to null");
        }
        catch (Exception exception) {}
    }
}

