/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Relationship;
import org.w3c.dom.Element;

public class Relationship_Test
extends TestCase {
    Relationship rel;
    Relationship clonedRel;
    Element element;
    SPISessionImpl session;

    public Relationship_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.rel = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createRelationship("relResourceRef", "relType");
        Properties props = new Properties();
        props.setProperty("key1", "value1");
        props.setProperty("key2", "value2");
        this.rel.setProperties(props);
        this.clonedRel = (Relationship)this.rel.clone();
        this.element = ((SPIDataObject)((Object)this.rel)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetProperties() {
        Properties testProps = this.rel.getProperties();
        Properties testclonedProps = this.clonedRel.getProperties();
        Collection<Element> testDataObjectProps = this.session.getChildren(this.element, "Property");
        Relationship_Test.assertEquals((Object)"value1", (Object)testProps.get("key1"));
        Relationship_Test.assertEquals((Object)"value2", (Object)testProps.get("key2"));
        Relationship_Test.assertEquals((Object)"value1", (Object)testclonedProps.get("key1"));
        Relationship_Test.assertEquals((Object)"value2", (Object)testclonedProps.get("key2"));
        Relationship_Test.assertEquals((int)2, (int)testDataObjectProps.size());
        int i = 0;
        while (i < testDataObjectProps.size()) {
            Element prop = testDataObjectProps.toArray(new Element[0])[i];
            String value = this.session.getChildren(prop, "Value").toArray(new Element[0])[0].getTextContent();
            String propertyName = this.session.getChildren(prop, "PropertyName").toArray(new Element[0])[0].getTextContent();
            Relationship_Test.assertTrue((String)(String.valueOf(value) + " wasn't found in the properties object"), (boolean)testProps.contains(value));
            Relationship_Test.assertTrue((String)(String.valueOf(propertyName) + " wasn't found in the properties object"), (boolean)testProps.containsKey(propertyName));
            Relationship_Test.assertEquals((Object)value, (Object)testProps.get(propertyName));
            ++i;
        }
    }

    public void testGetRelatedResourceReference() {
        Relationship_Test.assertEquals((String)"relResourceRef", (String)this.rel.getRelatedResourceReference());
        Relationship_Test.assertEquals((String)"relResourceRef", (String)this.clonedRel.getRelatedResourceReference());
        Relationship_Test.assertEquals((String)"relResourceRef", (String)this.element.getAttribute("relatedResourceRef"));
    }

    public void testGetType() {
        Relationship_Test.assertEquals((String)"relType", (String)this.rel.getType());
        Relationship_Test.assertEquals((String)"relType", (String)this.clonedRel.getType());
        Relationship_Test.assertEquals((String)"relType", (String)this.element.getAttribute("type"));
    }

    public void testSetProperties() {
        Properties props = new Properties();
        props.setProperty("key3", "value3");
        this.rel.setProperties(props);
        Properties testProps = this.rel.getProperties();
        Collection<Element> testDataObjectProps = this.session.getChildren(this.element, "Property");
        Relationship_Test.assertEquals((int)1, (int)testDataObjectProps.size());
        Relationship_Test.assertEquals((Object)"value3", (Object)testProps.get("key3"));
        int i = 0;
        while (i < testDataObjectProps.size()) {
            Element prop = testDataObjectProps.toArray(new Element[0])[i];
            String value = this.session.getChildren(prop, "Value").toArray(new Element[0])[0].getTextContent();
            String propertyName = this.session.getChildren(prop, "PropertyName").toArray(new Element[0])[0].getTextContent();
            Relationship_Test.assertTrue((String)(String.valueOf(value) + " wasn't found in the properties object"), (boolean)testProps.contains(value));
            Relationship_Test.assertTrue((String)(String.valueOf(propertyName) + " wasn't found in the properties object"), (boolean)testProps.containsKey(propertyName));
            Relationship_Test.assertEquals((Object)value, (Object)testProps.get(propertyName));
            ++i;
        }
    }

    public void testSetRelatedResourceReference() {
        this.rel.setRelatedResourceReference("differentRef");
        Relationship_Test.assertEquals((String)"differentRef", (String)this.rel.getRelatedResourceReference());
        Relationship_Test.assertEquals((String)"differentRef", (String)this.element.getAttribute("relatedResourceRef"));
        try {
            this.rel.setRelatedResourceReference(null);
            Relationship_Test.fail((String)"RelatedResourceRef was set to null");
        }
        catch (Exception exception) {}
    }

    public void testSetType() {
        this.rel.setType("differentType");
        Relationship_Test.assertEquals((String)"differentType", (String)this.rel.getType());
        Relationship_Test.assertEquals((String)"differentType", (String)this.element.getAttribute("type"));
        try {
            this.rel.setType(null);
            Relationship_Test.fail((String)"Type was set to null");
        }
        catch (Exception exception) {}
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)((Object)this.rel)).getTranslatableStrings();
        Relationship_Test.assertEquals((int)0, (int)props.keySet().size());
    }
}

