/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.UniquenessConstraint;
import org.w3c.dom.Element;

public class UniquenessConstraint_Test
extends TestCase {
    UniquenessConstraint uniquenessConstraint;
    UniquenessConstraint clonedUniquenessConstraint;
    Element element;
    SPISessionImpl session;

    public UniquenessConstraint_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.uniquenessConstraint = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createUniquenessConstraint("resourceRef");
        this.uniquenessConstraint.setDescription(new TranslatableString("unqDescription", "unqDescriptionKey"));
        this.uniquenessConstraint.setShortDescription(new TranslatableString("unqShortDescription", "unqShortDescriptionKey"));
        this.clonedUniquenessConstraint = (UniquenessConstraint)this.uniquenessConstraint.clone();
        this.element = ((SPIDataObject)((Object)this.uniquenessConstraint)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        Properties props = this.uniquenessConstraint.getTranslatableStrings();
        Properties clonedProps = this.clonedUniquenessConstraint.getTranslatableStrings();
        UniquenessConstraint_Test.assertEquals((int)2, (int)props.keySet().size());
        UniquenessConstraint_Test.assertEquals((int)2, (int)clonedProps.keySet().size());
        UniquenessConstraint_Test.assertEquals((Object)"unqDescription", (Object)props.get("unqDescriptionKey"));
        UniquenessConstraint_Test.assertEquals((Object)"unqShortDescription", (Object)props.get("unqShortDescriptionKey"));
        UniquenessConstraint_Test.assertEquals((Object)"unqDescription", (Object)clonedProps.get("unqDescriptionKey"));
        UniquenessConstraint_Test.assertEquals((Object)"unqShortDescription", (Object)clonedProps.get("unqShortDescriptionKey"));
    }

    public void testGetDistinctResourceReference() {
        UniquenessConstraint_Test.assertEquals((String)"resourceRef", (String)this.uniquenessConstraint.getDistinctResourceReference());
        UniquenessConstraint_Test.assertEquals((String)"resourceRef", (String)this.clonedUniquenessConstraint.getDistinctResourceReference());
        UniquenessConstraint_Test.assertEquals((String)"resourceRef", (String)this.element.getAttribute("distinctResourceRef"));
    }

    public void testSetDistinctResourceReference() {
        this.uniquenessConstraint.setDistinctResourceReference("differentRef");
        UniquenessConstraint_Test.assertEquals((String)"differentRef", (String)this.uniquenessConstraint.getDistinctResourceReference());
        UniquenessConstraint_Test.assertEquals((String)"differentRef", (String)((SPIDataObject)((Object)this.uniquenessConstraint)).getElement().getAttribute("distinctResourceRef"));
        try {
            this.uniquenessConstraint.setDistinctResourceReference(null);
            UniquenessConstraint_Test.fail((String)"DistinctResourceRef was set to null");
        }
        catch (Exception exception) {}
    }

    public void testGetDescription() {
        UniquenessConstraint_Test.assertEquals((String)"unqDescription", (String)this.uniquenessConstraint.getDescription().getValue());
        UniquenessConstraint_Test.assertEquals((String)"unqDescriptionKey", (String)this.uniquenessConstraint.getDescription().getTranslationKey());
        UniquenessConstraint_Test.assertEquals((String)"unqDescription", (String)this.uniquenessConstraint.getDescription().getValue());
        UniquenessConstraint_Test.assertEquals((String)"unqDescriptionKey", (String)this.uniquenessConstraint.getDescription().getTranslationKey());
        UniquenessConstraint_Test.assertEquals((String)"unqDescription", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        UniquenessConstraint_Test.assertEquals((String)"unqDescriptionKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetShortDescription() {
        UniquenessConstraint_Test.assertEquals((String)"unqShortDescription", (String)this.uniquenessConstraint.getShortDescription().getValue());
        UniquenessConstraint_Test.assertEquals((String)"unqShortDescriptionKey", (String)this.uniquenessConstraint.getShortDescription().getTranslationKey());
        UniquenessConstraint_Test.assertEquals((String)"unqShortDescription", (String)this.uniquenessConstraint.getShortDescription().getValue());
        UniquenessConstraint_Test.assertEquals((String)"unqShortDescriptionKey", (String)this.uniquenessConstraint.getShortDescription().getTranslationKey());
        UniquenessConstraint_Test.assertEquals((String)"unqShortDescription", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        UniquenessConstraint_Test.assertEquals((String)"unqShortDescriptionKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetDescription() {
        this.uniquenessConstraint.setDescription(new TranslatableString("testSetDescription", "testSetDescriptionKey"));
        UniquenessConstraint_Test.assertEquals((String)"testSetDescription", (String)this.uniquenessConstraint.getDescription().getValue());
        UniquenessConstraint_Test.assertEquals((String)"testSetDescription", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        UniquenessConstraint_Test.assertEquals((String)"testSetDescriptionKey", (String)this.uniquenessConstraint.getDescription().getTranslationKey());
        UniquenessConstraint_Test.assertEquals((String)"testSetDescriptionKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetShortDescription() {
        this.uniquenessConstraint.setShortDescription(new TranslatableString("testSetShortDescription", "testSetShortDescriptionKey"));
        UniquenessConstraint_Test.assertEquals((String)"testSetShortDescription", (String)this.uniquenessConstraint.getShortDescription().getValue());
        UniquenessConstraint_Test.assertEquals((String)"testSetShortDescription", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        UniquenessConstraint_Test.assertEquals((String)"testSetShortDescriptionKey", (String)this.uniquenessConstraint.getShortDescription().getTranslationKey());
        UniquenessConstraint_Test.assertEquals((String)"testSetShortDescriptionKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }
}

