/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterGroup;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ArtifactType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.CompletionType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ConditionalDerivedVariablesType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.DerivedVariableType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.IdentityType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ParameterGroupType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.RequirementType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResourcePropertyType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResourceType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResultingChangeType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationUnitType {
    public static boolean equals(ConfigurationUnit dd1, ConfigurationUnit dd2) {
        if (ResourceType.equals(Util.resolveResourceRef(dd1.getTargetResourceReference()), Util.resolveResourceRef(dd2.getTargetResourceReference()))) {
            if (dd1.getResultingChanges() == null && dd2.getResultingChanges() != null) {
                return false;
            }
            if (dd2.getResultingChanges() == null && dd1.getResultingChanges() != null) {
                return false;
            }
            if (ResultingChangeType.equals(dd1.getResultingChanges(), dd2.getResultingChanges())) {
                return true;
            }
        }
        return false;
    }

    public static ConfigurationUnit merge(ConfigurationUnit dd1, ConfigurationUnit dd2) {
        dd1.setIdentityData(IdentityType.merge(dd1.getIdentityData(), dd2.getIdentityData()));
        dd1.setCompletion(CompletionType.merge(dd1.getCompletion(), dd2.getCompletion()));
        dd1.setConditionalDerivedVariables(ConditionalDerivedVariablesType.merge(dd1.getConditionalDerivedVariables(), dd2.getConditionalDerivedVariables()));
        dd1.setConfigurationArtifact(ArtifactType.merge(dd1.getConfigurationArtifact(), dd2.getConfigurationArtifact()));
        dd1.setDerivedVariables(DerivedVariableType.merge(dd1.getDerivedVariables(), dd2.getDerivedVariables()));
        ParameterGroup params = ParameterGroupType.merge(dd1.getParameterGroups(), dd2.getParameterGroups());
        ArrayList<ParameterGroup> myParams = new ArrayList<ParameterGroup>();
        myParams.add(params);
        dd1.setParameterGroups(myParams);
        dd1.setRequirements(RequirementType.merge(dd1.getRequirements(), dd2.getRequirements()));
        dd1.setResourceProperties(ResourcePropertyType.merge(dd1.getResourceProperties(), dd2.getResourceProperties()));
        return dd1;
    }

    public static Collection<ConfigurationUnit> merge(Collection<ConfigurationUnit> configurationUnits1, Collection<ConfigurationUnit> configurationUnits2) {
        ArrayList<ConfigurationUnit> configurationUnitsToRemove = new ArrayList<ConfigurationUnit>();
        for (ConfigurationUnit configurationUnit1 : configurationUnits1) {
            for (ConfigurationUnit configurationUnit2 : configurationUnits2) {
                if (configurationUnitsToRemove.contains(configurationUnit2) || !ConfigurationUnitType.equals(configurationUnit1, configurationUnit2)) continue;
                configurationUnitsToRemove.add(configurationUnit2);
                configurationUnit1 = ConfigurationUnitType.merge(configurationUnit1, configurationUnit2);
            }
        }
        configurationUnits2.removeAll(configurationUnitsToRemove);
        ArrayList<ConfigurationUnit> finalConfigurationUnits = new ArrayList<ConfigurationUnit>();
        finalConfigurationUnits.addAll(configurationUnits1);
        finalConfigurationUnits.addAll(configurationUnits2);
        return finalConfigurationUnits;
    }
}

