/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResourceType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredBaseConstraintType {
    public static boolean equals(RequiredBaseConstraint constraint1, RequiredBaseConstraint constraint2) {
        return ResourceType.equals(Util.resolveResourceRef(constraint1.getResourceReference()), Util.resolveResourceRef(constraint2.getResourceReference())) && constraint1.getTestValue() == constraint2.getTestValue();
    }

    public static RequiredBaseConstraint merge(RequiredBaseConstraint constraint1, RequiredBaseConstraint constraint2) {
        TranslatableString description = constraint1.getDescription();
        description.setTranslationKey(String.valueOf(description.getTranslationKey()) + constraint2.getDescription().getTranslationKey());
        description.setTranslationKey(String.valueOf(description.getValue()) + constraint2.getDescription().getValue());
        constraint1.setDescription(description);
        TranslatableString value = constraint1.getDisplayName();
        value.setTranslationKey(String.valueOf(value.getTranslationKey()) + constraint2.getDisplayName().getTranslationKey());
        value.setTranslationKey(String.valueOf(value.getValue()) + constraint2.getDisplayName().getValue());
        constraint1.setDisplayName(value);
        return constraint1;
    }

    public static Collection<RequiredBaseConstraint> merge(Collection<RequiredBaseConstraint> requiredBaseConstraints1, Collection<RequiredBaseConstraint> requiredBaseConstraints2) {
        ArrayList<RequiredBaseConstraint> requiredBaseConstraintsToRemove = new ArrayList<RequiredBaseConstraint>();
        for (RequiredBaseConstraint requiredBaseConstraint1 : requiredBaseConstraints1) {
            for (RequiredBaseConstraint requiredBaseConstraint2 : requiredBaseConstraints2) {
                if (requiredBaseConstraintsToRemove.contains(requiredBaseConstraint2) || !RequiredBaseConstraintType.equals(requiredBaseConstraint1, requiredBaseConstraint2)) continue;
                requiredBaseConstraintsToRemove.add(requiredBaseConstraint2);
                requiredBaseConstraint1 = RequiredBaseConstraintType.merge(requiredBaseConstraint1, requiredBaseConstraint2);
            }
        }
        requiredBaseConstraints2.removeAll(requiredBaseConstraintsToRemove);
        ArrayList<RequiredBaseConstraint> finalRequiredBaseConstraints = new ArrayList<RequiredBaseConstraint>();
        finalRequiredBaseConstraints.addAll(requiredBaseConstraints1);
        finalRequiredBaseConstraints.addAll(requiredBaseConstraints2);
        return finalRequiredBaseConstraints;
    }
}

