/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.repository.operations.cmdbf;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IProperty;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.SimpleTypeProperty;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.StringProperty;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SMLPropertyFactory {
    public static IProperty create(Node node) {
        String value = SMLPropertyFactory.retrieveValue(node);
        int type = SMLPropertyFactory.determineType(value);
        switch (type) {
            case 1: {
                return new SimpleTypeProperty(node, Boolean.parseBoolean(value));
            }
            case 2: {
                return new SimpleTypeProperty(node, Integer.parseInt(value));
            }
            case 3: {
                return new SimpleTypeProperty(node, Double.parseDouble(value));
            }
            case 4: {
                return new StringProperty(node, value);
            }
        }
        return null;
    }

    private static String retrieveValue(Node node) {
        switch (node.getNodeType()) {
            case 2: {
                return node.getNodeValue();
            }
            case 1: {
                NodeList children = node.getChildNodes();
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                int childCount = children.getLength();
                while (i < childCount) {
                    Node child = children.item(i);
                    if (child.getNodeType() != 3) break;
                    String value = child.getNodeValue();
                    if (value != null) {
                        buffer.append(value.trim());
                    }
                    ++i;
                }
                return buffer.toString();
            }
        }
        return "";
    }

    private static int determineType(String value) {
        if (value == null) {
            return 0;
        }
        if ("true".equals(value) || "false".equals(value)) {
            return 1;
        }
        try {
            Integer.parseInt(value);
            return 2;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(value);
                return 3;
            }
            catch (NumberFormatException numberFormatException2) {
                return 4;
            }
        }
    }
}

