/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tests.common.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.sdd.common.validation.ValidationRule;
import org.eclipse.cosmos.me.sdd.common.validation.exception.XMLValidationException;
import org.eclipse.cosmos.me.sdd.common.validation.plugin.SchemaValidationRule;
import org.eclipse.cosmos.me.sdd.common.validation.plugin.SchematronValidationRule;
import org.eclipse.cosmos.me.sdd.common.validation.plugin.XML_DASImpl;
import org.eclipse.cosmos.me.sdd.common.validation.util.ValidatorUtils;
import org.eclipse.cosmos.me.sdd.tests.common.validation.AllTests;
import org.eclipse.cosmos.me.sdd.tests.common.validation.TrivialValidationRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XML_DASImpl_Test
extends TestCase {
    private static final String FSEP = System.getProperty("file.separator");
    private static final String VALID_DD_SCHEMATRON = String.valueOf(AllTests.ARTIFACT_LOCATION) + FSEP + "Valid_SchematronRules_DD.sch";
    private static final String INVALID_SCHEMATRON = String.valueOf(AllTests.ARTIFACT_LOCATION) + FSEP + "Invalid_SchematronRules.sch";

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLoadDocument_ValidDD() throws FileNotFoundException, IOException, XMLValidationException {
        XML_DASImpl myXmlDas = new XML_DASImpl();
        Document myDoc = myXmlDas.loadDocument(new FileInputStream(AllTests.VALID_DD));
        XML_DASImpl_Test.assertNotNull((Object)myDoc);
    }

    public void testLoadDocument_InvalidDD() throws FileNotFoundException, IOException, XMLValidationException {
        XML_DASImpl myXmlDas = new XML_DASImpl();
        Document myDoc = myXmlDas.loadDocument(new FileInputStream(AllTests.INVALID_DD));
        XML_DASImpl_Test.assertNotNull((Object)myDoc);
    }

    public void testLoadDocument_MalformedDD() throws FileNotFoundException, IOException {
        XML_DASImpl myXmlDas = new XML_DASImpl();
        try {
            myXmlDas.loadDocument(new FileInputStream(AllTests.MALFORMED_DD));
            XML_DASImpl_Test.fail((String)"DD file is malformed but an XMLValidationException was not thrown");
        }
        catch (XMLValidationException xMLValidationException) {}
    }

    public void testLoadDocument_ValidPD() throws FileNotFoundException, IOException, XMLValidationException {
        XML_DASImpl myXmlDas = new XML_DASImpl();
        Document myDoc = myXmlDas.loadDocument(new FileInputStream(AllTests.VALID_PD));
        XML_DASImpl_Test.assertNotNull((Object)myDoc);
    }

    public void testLoadDocument_InvalidPD() throws FileNotFoundException, IOException, XMLValidationException {
        XML_DASImpl myXmlDas = new XML_DASImpl();
        Document myDoc = myXmlDas.loadDocument(new FileInputStream(AllTests.INVALID_PD));
        XML_DASImpl_Test.assertNotNull((Object)myDoc);
    }

    public void testAddValidation() {
        XML_DASImpl myXmlDas = new XML_DASImpl();
        int i = 0;
        while (i < 1000) {
            TrivialValidationRule validationRule = new TrivialValidationRule();
            myXmlDas.addValidation(validationRule);
            ++i;
        }
        Collection<ValidationRule> rules = myXmlDas.getValidationRules();
        XML_DASImpl_Test.assertEquals((int)rules.size(), (int)1000);
    }

    public void testRemoveValidation_EmptyList() {
        XML_DASImpl myXmlDas = new XML_DASImpl();
        TrivialValidationRule validationRule = new TrivialValidationRule();
        myXmlDas.removeValidation(validationRule);
    }

    public void testRemoveValidation_NotInList() {
        XML_DASImpl myXmlDas = new XML_DASImpl();
        TrivialValidationRule validationRule = new TrivialValidationRule();
        myXmlDas.addValidation(validationRule);
        TrivialValidationRule validationRule2 = new TrivialValidationRule();
        myXmlDas.removeValidation(validationRule2);
    }

    public void testRemoveValidation_InList() {
        XML_DASImpl myXmlDas = new XML_DASImpl();
        TrivialValidationRule validationRule = new TrivialValidationRule();
        myXmlDas.addValidation(validationRule);
        myXmlDas.removeValidation(validationRule);
    }

    public void testValidate_SchemaValid() throws FileNotFoundException, IOException, XMLValidationException {
        XML_DASImpl myXmlDas = new XML_DASImpl();
        File[] schemaArray = new File[]{new File("sdd_schema/sdd-common-1.0.xsd"), new File("sdd_schema/sdd-deploymentDescriptor-1.0.xsd")};
        SchemaValidationRule validationRule = new SchemaValidationRule((Collection)Arrays.asList(schemaArray));
        myXmlDas.addValidation(validationRule);
        Document doc = myXmlDas.loadDocument(new FileInputStream(AllTests.VALID_DD));
        XML_DASImpl_Test.assertEquals((int)myXmlDas.validate(doc).size(), (int)0);
    }

    public void testValidate_SchemaInvalid() throws FileNotFoundException, IOException, XMLValidationException {
        XML_DASImpl myXmlDas = new XML_DASImpl();
        File[] schemaArray = new File[]{new File("sdd_schema/sdd-common-1.0.xsd"), new File("sdd_schema/sdd-deploymentDescriptor-1.0.xsd")};
        SchemaValidationRule validationRule = new SchemaValidationRule((Collection)Arrays.asList(schemaArray));
        myXmlDas.addValidation(validationRule);
        Document doc = myXmlDas.loadDocument(new FileInputStream(AllTests.VALID_DD));
        doc.getDocumentElement().removeAttribute("descriptorID");
        XML_DASImpl_Test.assertFalse((myXmlDas.validate(doc).size() == 0 ? 1 : 0) != 0);
    }

    public void testValidate_SchematronValid() throws FileNotFoundException, IOException, XMLValidationException {
        XML_DASImpl myXmlDas = new XML_DASImpl();
        SchematronValidationRule validationRule = new SchematronValidationRule(new File(VALID_DD_SCHEMATRON));
        myXmlDas.addValidation(validationRule);
        Document doc = myXmlDas.loadDocument(new FileInputStream(AllTests.VALID_DD));
        XML_DASImpl_Test.assertEquals((int)myXmlDas.validate(doc).size(), (int)0);
    }

    public void testValidate_SchematronInvalid() throws FileNotFoundException, IOException, XMLValidationException {
        XML_DASImpl myXmlDas = new XML_DASImpl();
        SchematronValidationRule validationRule = new SchematronValidationRule(new File(INVALID_SCHEMATRON));
        myXmlDas.addValidation(validationRule);
        Document doc = myXmlDas.loadDocument(new FileInputStream(AllTests.VALID_DD));
        XML_DASImpl_Test.assertFalse((myXmlDas.validate(doc).size() == 0 ? 1 : 0) != 0);
    }

    public void testSaveDocumentDocument() throws FileNotFoundException, IOException, XMLValidationException {
        XML_DASImpl myXmlDas = new XML_DASImpl();
        Document doc = myXmlDas.loadDocument(new FileInputStream(AllTests.VALID_DD));
        Element topology = ValidatorUtils.findElement(doc, "Topology");
        Element resource = ValidatorUtils.findElement(topology, "Resource");
        resource.setAttribute("id", "Win32");
        myXmlDas.saveDocument(doc, System.out, "UTF-8", false);
    }
}

