/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.dmtoolkit.j2ee.delegates;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.dr.internal.web.ui.WebViewerActivator;
import org.eclipse.cosmos.me.internal.dmtoolkit.j2ee.DMJ2EEPlugin;
import org.eclipse.cosmos.me.internal.dmtoolkit.j2ee.util.J2EEUtilities;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;

public class ToolkitLaunchableAdapterDelegate
extends LaunchableAdapterDelegate
implements IServerListener {
    private IServer server;
    private IModuleArtifact moduleArtifact;

    public Object getLaunchable(IServer server, IModuleArtifact moduleArtifact) throws CoreException {
        this.initServer(server);
        this.setModuleArtifact(moduleArtifact);
        return null;
    }

    private void initServer(IServer server) {
        if (this.getServer() == null) {
            this.setServer(server);
            server.addServerListener((IServerListener)this);
        }
    }

    private void buildEprAndLaunchViewer() throws CoreException {
        System.out.println("xxxxxxxxxxxxxx  GOT HERE xxxxxxxxxxxxxxxxxxxx");
        IURLProvider urlProvider = (IURLProvider)this.getServer().getAdapter(IURLProvider.class);
        IModule module = this.getModuleArtifact().getModule();
        URL url = urlProvider.getModuleRootURL(module);
        String serviceName = this.locateServiceName(module);
        if (serviceName == null) {
            throw new CoreException(DMJ2EEPlugin.createErrorStatus("Could not locate MDR query service in project"));
        }
        String epr = url + "services/" + serviceName;
        System.out.println("EPR = " + epr);
        this.showInWebViewer(serviceName, epr);
    }

    private void showInWebViewer(String serviceName, String epr) throws CoreException {
        WebViewerActivator.getDefault().launchCOSMOSUI(serviceName, epr);
    }

    private String locateServiceName(IModule module) throws CoreException {
        IProject project = module.getProject();
        IFolder servicesFolder = J2EEUtilities.getWebInfServicesDir(project);
        IFolder metaInfFolder = ((IFolder)servicesFolder.members()[0]).getFolder("META-INF");
        IFile file = metaInfFolder.getFile("QueryService.wsdl");
        InputStream fileContents = file.getContents();
        String serviceName = null;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(fileContents));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("<wsdl:service name=\"")) continue;
                String rightSide = line.substring(line.indexOf(34) + 1);
                int rightQuote = rightSide.indexOf(34);
                serviceName = rightSide.substring(0, rightQuote);
                break;
            }
            reader.close();
            fileContents.close();
        }
        catch (IOException e) {
            throw DMJ2EEPlugin.createCoreException(e);
        }
        return serviceName;
    }

    public void serverChanged(ServerEvent event) {
        if (event.getState() == 2) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        ToolkitLaunchableAdapterDelegate.this.buildEprAndLaunchViewer();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void setServer(IServer server) {
        this.server = server;
    }

    private IServer getServer() {
        return this.server;
    }

    private void setModuleArtifact(IModuleArtifact moduleArtifact) {
        this.moduleArtifact = moduleArtifact;
    }

    private IModuleArtifact getModuleArtifact() {
        return this.moduleArtifact;
    }
}

