/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.examples.common.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.cosmos.me.sdd.common.validation.ValidationRule;
import org.eclipse.cosmos.me.sdd.common.validation.XMLValidationError;
import org.eclipse.cosmos.me.sdd.common.validation.exception.XMLValidationException;
import org.eclipse.cosmos.me.sdd.common.validation.plugin.SDD_DASImpl;
import org.eclipse.cosmos.me.sdd.common.validation.util.ValidatorUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ValidationRule_Sample {
    private static final String FSEP = System.getProperty("file.separator");
    private static final String filesPath = "src" + FSEP + "org" + FSEP + "eclipse" + FSEP + "cosmos" + FSEP + "me" + FSEP + "internal" + FSEP + "deployment" + FSEP + "sdd" + FSEP + "examples" + FSEP + "common" + FSEP + "validation" + FSEP;
    private static final String DD_INPUT_FILE = String.valueOf(filesPath) + "DeploymentDescriptor.xml";
    private static final String PD_INPUT_FILE = String.valueOf(filesPath) + "PackageDescriptor.xml";

    public static void main(String[] args) {
        ValidationRule_Sample.prepFiles();
        SDD_DASImpl deploymentDescriptorDAS = new SDD_DASImpl();
        SDD_DASImpl packageDescriptorDAS = new SDD_DASImpl();
        Document pdDocument = null;
        Document ddDocument = null;
        try {
            pdDocument = packageDescriptorDAS.loadDocument(new FileInputStream(PD_INPUT_FILE));
            ddDocument = deploymentDescriptorDAS.loadDocument(new FileInputStream(DD_INPUT_FILE));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (XMLValidationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        CustomValidationRule customValidationRule = new CustomValidationRule(pdDocument);
        deploymentDescriptorDAS.addValidation(customValidationRule);
        Collection<XMLValidationError> validationErrors = deploymentDescriptorDAS.validate(ddDocument);
        for (XMLValidationError error : validationErrors) {
            System.err.println(error.getErrorMessage());
        }
    }

    private static void prepFiles() {
        File deploymentDescriptor = new File(String.valueOf(filesPath) + "DeploymentDescriptor.xml");
        File packageDescriptor = new File(String.valueOf(filesPath) + "PackageDescriptor.xml");
        File ddOriginal = new File(String.valueOf(filesPath) + "DeploymentDescriptor.xml_Original");
        File pdOriginal = new File(String.valueOf(filesPath) + "PackageDescriptor.xml_Original");
        try {
            FileChannel ddSrcChannel = new FileInputStream(ddOriginal).getChannel();
            FileChannel ddDestChannel = new FileOutputStream(deploymentDescriptor).getChannel();
            ddDestChannel.transferFrom(ddSrcChannel, 0L, ddSrcChannel.size());
            FileChannel pdSrcChannel = new FileInputStream(pdOriginal).getChannel();
            FileChannel pdDestChannel = new FileOutputStream(packageDescriptor).getChannel();
            pdDestChannel.transferFrom(pdSrcChannel, 0L, pdSrcChannel.size());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CustomValidationRule
    implements ValidationRule {
        private Document pdDocument;

        public CustomValidationRule(Document document) {
            this.pdDocument = document;
        }

        @Override
        public Collection<XMLValidationError> validate(InputStream xmlStream) {
            Vector<XMLValidationError> validationErrors = new Vector<XMLValidationError>();
            SDD_DASImpl sddDas = new SDD_DASImpl();
            Document ddDocument = null;
            try {
                ddDocument = sddDas.loadDocument(xmlStream);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
            catch (XMLValidationException e) {
                e.printStackTrace();
                System.exit(1);
            }
            Element installArtifact = ValidatorUtils.findElement(ddDocument, "InstallArtifact");
            String contentRef = installArtifact.getAttribute("contentRef");
            Element pdCopy = (Element)this.pdDocument.getDocumentElement().cloneNode(true);
            boolean foundMatch = false;
            Element contentElement = ValidatorUtils.findElement(pdCopy, "Content");
            while (contentElement != null && !foundMatch) {
                if (contentRef.equals(contentElement.getAttribute("id"))) {
                    foundMatch = true;
                    continue;
                }
                contentElement.getParentNode().removeChild(contentElement);
                contentElement = ValidatorUtils.findElement(pdCopy, "Content");
            }
            if (!foundMatch) {
                String errorMsg = "No matching Content element in Package Descriptor for InstallArtifact element in Deployment Descriptor.";
                validationErrors.add(new XMLValidationError(errorMsg, -1, -1, this, 2));
            }
            return validationErrors;
        }
    }
}

