/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.common.validation.plugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cosmos.me.sdd.common.validation.ValidationRule;
import org.eclipse.cosmos.me.sdd.common.validation.XMLValidationError;
import org.eclipse.cosmos.me.sdd.common.validation.XML_DAS;
import org.eclipse.cosmos.me.sdd.common.validation.exception.XMLValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XML_DASImpl
implements XML_DAS {
    private Collection<ValidationRule> validationRuleList = new Vector<ValidationRule>();

    @Override
    public void addValidation(ValidationRule validationRule) {
        this.validationRuleList.add(validationRule);
    }

    @Override
    public void removeValidation(ValidationRule validationRule) {
        this.validationRuleList.remove(validationRule);
    }

    @Override
    public Collection<ValidationRule> getValidationRules() {
        return this.validationRuleList;
    }

    @Override
    public Document loadDocument(InputStream inputStream) throws IOException, XMLValidationException {
        Document xmlDocument;
        block6: {
            xmlDocument = null;
            try {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    xmlDocument = builder.parse(inputStream);
                }
                catch (SAXException e) {
                    XMLValidationError validationError = new XMLValidationError("", null, e);
                    throw new XMLValidationException(validationError);
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                    inputStream.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
        }
        this.removeWhitespaceNodes(xmlDocument.getDocumentElement());
        return xmlDocument;
    }

    @Override
    public void saveDocument(Document document, OutputStream outputStream, String encoding, boolean performValidation) throws XMLValidationException, IOException {
        Collection<XMLValidationError> validationErrors;
        if (performValidation && (validationErrors = this.validate(document)).size() > 0) {
            throw new XMLValidationException(validationErrors);
        }
        this.writeDocumentToOutputStream(document, outputStream, encoding);
    }

    @Override
    public Collection<XMLValidationError> validate(Document document) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.writeDocumentToOutputStream(document, outputStream, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Vector<XMLValidationError> validationErrors = new Vector<XMLValidationError>();
        for (ValidationRule validationRule : this.validationRuleList) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            validationErrors.addAll(validationRule.validate(inputStream));
        }
        return validationErrors;
    }

    private void writeDocumentToOutputStream(Document document, OutputStream outputStream, String encoding) throws IOException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        Transformer tr = null;
        try {
            tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("encoding", encoding);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        try {
            tr.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private void removeWhitespaceNodes(Element e) {
        NodeList children = e.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if (child instanceof Text && ((Text)child).getData().trim().length() == 0) {
                e.removeChild(child);
            } else if (child instanceof Element) {
                this.removeWhitespaceNodes((Element)child);
            }
            --i;
        }
    }
}

