/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.examples.common.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.cosmos.me.sdd.common.validation.XMLValidationError;
import org.eclipse.cosmos.me.sdd.common.validation.exception.XMLValidationException;
import org.eclipse.cosmos.me.sdd.common.validation.plugin.SchemaValidationRule;
import org.eclipse.cosmos.me.sdd.common.validation.plugin.XML_DASImpl;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XML_DAS_Sample {
    private static final String FSEP = System.getProperty("file.separator");
    private static final String filesPath = "src" + FSEP + "org" + FSEP + "eclipse" + FSEP + "cosmos" + FSEP + "me" + FSEP + "internal" + FSEP + "deployment" + FSEP + "sdd" + FSEP + "examples" + FSEP + "common" + FSEP + "validation" + FSEP;
    private static final String XML_INPUT_FILE = String.valueOf(filesPath) + "cd_catalog.xml";
    private static final String CD_SCHEMA_FILE = String.valueOf(filesPath) + "CompactDiscCatalog.xsd";
    private static final String XML_OUTPUT_FILE = String.valueOf(filesPath) + "cd_catalog-rounded.xml";
    private static final Collection<File> schemaFiles = Arrays.asList(new File(CD_SCHEMA_FILE));

    public static void main(String[] args) {
        XML_DAS_Sample.prepFiles();
        XML_DASImpl cdCatalogDAS = new XML_DASImpl();
        Document cdCatalogDoc = null;
        try {
            cdCatalogDoc = cdCatalogDAS.loadDocument(new FileInputStream(XML_INPUT_FILE));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (XMLValidationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        XML_DAS_Sample.roundUpPrices(cdCatalogDoc);
        SchemaValidationRule schemaRule = null;
        try {
            schemaRule = new SchemaValidationRule(schemaFiles);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        cdCatalogDAS.addValidation(schemaRule);
        Collection<XMLValidationError> validationErrors = cdCatalogDAS.validate(cdCatalogDoc);
        if (validationErrors.size() > 0) {
            for (XMLValidationError error : validationErrors) {
                System.err.println(error.getErrorMessage());
            }
            System.exit(1);
        }
        try {
            cdCatalogDAS.saveDocument(cdCatalogDoc, new FileOutputStream(XML_OUTPUT_FILE), null, false);
        }
        catch (XMLValidationException xMLValidationException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void prepFiles() {
        File outputFile = new File(XML_OUTPUT_FILE);
        outputFile.delete();
    }

    private static void roundUpPrices(Document catalog) {
        NodeList nodes = catalog.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            NodeList children = nodes.item(i).getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                if ("price".equals(children.item(j).getNodeName())) {
                    double oldPrice = Double.parseDouble(children.item(j).getTextContent());
                    double newPrice = Math.ceil(oldPrice);
                    children.item(j).setTextContent(new Double(newPrice).toString());
                }
                ++j;
            }
            ++i;
        }
    }
}

