/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.io.File;
import java.io.PrintWriter;
import java.util.UUID;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.SaverHelper;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

public class QuerySaver
extends AbstractOutputter {
    public static final String CMDBF_QUERY = "query";
    public static final String PARENTCLASS = "parentClass";
    public static final String QUERYCLASS = "queryClass";
    public static final String TITLE = "title";
    public static final String UUIDPARAM = "uuid";
    public static final String FUNC = "func";
    public static final String ISFOLDER = "folder";
    public static final String RENAME_FUNC = "rename";
    public static final String DELETE_FUNC = "delete";
    protected String rootDir = "";
    protected boolean autoSave = false;

    public void initalize(IOutputterContext context, IParameters parameters) throws Exception {
        this.rootDir = context.getRealPath("queryRepository" + File.separator + "queries");
        String autoSaveStr = context.getInitParameter("QUERY_SAVE");
        if (autoSaveStr != null) {
            this.autoSave = Boolean.parseBoolean(autoSaveStr);
        }
        super.initalize(context, parameters);
    }

    public void render(PrintWriter output, IParameters input) throws Exception {
        String query = input.getParameter(CMDBF_QUERY);
        UUID uuidObj = UUID.randomUUID();
        String uuid = uuidObj.toString();
        String title = input.getParameter(TITLE);
        String nodeClass = input.getParameter(QUERYCLASS);
        String parentClass = input.getParameter(PARENTCLASS);
        String func = input.getParameter(FUNC);
        boolean isFolder = "true".equals(input.getParameter(ISFOLDER));
        if (RENAME_FUNC.equals(func)) {
            uuid = input.getParameter(UUIDPARAM);
            SaverHelper.renameQuery(uuid, title, nodeClass, parentClass, this.rootDir, isFolder);
        } else if (DELETE_FUNC.equals(func)) {
            if (this.autoSave) {
                uuid = input.getParameter(UUIDPARAM);
                SaverHelper.deleteQuery(uuid, parentClass, this.rootDir);
            }
        } else if (this.autoSave) {
            SaverHelper.saveQuery(query, uuid, title, nodeClass, parentClass, this.rootDir, isFolder);
        }
        output.write(uuid);
    }
}

