/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.common;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;


/**
 * A notification handler factory is used to create instances of 
 * notification handlers.
 * 
 * 
 * @author Ali Mehregani
 */
public interface INotificationHandlerFactory
{
	/**
	 * Creates and returns an item notification handler based
	 * on the notification type passed in.
	 * 
	 * @param type Indicates whether a registration or
	 * a deregistration handler should be returned.  See 
	 * {@link INotificationHandler#REGISTRATION} and 
	 * {@link INotificationHandler#DEREGISTRATION}
	 * @return An item notification handler
	 * 
	 * @throws CMDBfServiceException In case of an error
	 */
	public IItemNotificationHandler createItemHandler(int type) throws CMDBfServiceException;
	
	
	/**
	 * Creates and returns a relationship notification handler based
	 * on the notification type passed in.
	 * 
	 * @param type Indicates whether a registration or
	 * a deregistration handler should be returned.  See 
	 * {@link INotificationHandler#REGISTRATION} and 
	 * {@link INotificationHandler#DEREGISTRATION}
	 * @return A relationship notification handler
	 * 
	 * @throws CMDBfServiceException In case of an error
	 */
	public IRelationshipNotificationHandler createRelationshipHandler(int type) throws CMDBfServiceException;
}
