/*******************************************************************************
 * Copyright (c) 2007, 2008 CA, Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.cosmos.internal.dr.drs.service.handler.common.MapParameterImpl;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;


public class DomainOutputter extends AbstractOutputter {

	public void render(PrintWriter output, IParameters input) throws Exception {

		//
		// For M2, don't show the Domain and Brokers, just jump to the Data Managers
		//

//		Map<String, String> keyMap = new HashMap<String, String>();
//		keyMap.put("nodeDecorator", input.getParameter("nodeDecorator"));
//
//		IParameters parameters = new MapParameterImpl(keyMap);

		BrokerOutputter brokerOut = new BrokerOutputter();
		brokerOut.initalize(context, input);

		brokerOut.render(output, input);

	}

}
