/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 *     SAS Institute - Bug 275669 
 *     SAS Institute - Bug 287760
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.o10r.impl;


import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Date;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;

import org.eclipse.cosmos.me.sdd.schema.ArgumentListType;
import org.eclipse.cosmos.me.sdd.schema.ArgumentType;
import org.eclipse.cosmos.me.sdd.schema.ArtifactType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;
import org.eclipse.cosmos.me.sdd.schema.registry.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.registry.ProductType;
import org.eclipse.cosmos.me.sdd.schema.registry.RegistryType;
import org.eclipse.cosmos.me.sdd.schema.registry.VersionType;
import org.osgi.service.log.LogService;



public class SDDRegistry {
	
	private static String FOLDER = "C:\\TEMP\\";
	private final static String FILENAME = "registry.xml";
	
	private static String getFolder() {
		return FOLDER;
	}

	private static void setFolder(String folder) {
		FOLDER = folder;
	}

	protected static void updateRegistry(SDDContext ctxt, ArtifactType artifact, LogService logService)
	{
		//derive registry folder
		setFolder(deriveFolder());
		
		//try to pick up registry
		//if not there create new one
		RegistryType registry = null;
		ObjectFactory of = new ObjectFactory();
		
		try {
			JAXBContext jc = JAXBContext.newInstance(RegistryType.class);
			
			Unmarshaller u = jc.createUnmarshaller();			
			JAXBElement<RegistryType> installJax = u.unmarshal(new StreamSource(getFolder()+FILENAME),
					RegistryType.class);
			registry = installJax.getValue();
		}
		catch (JAXBException e) {
			logService.log(LogService.LOG_INFO, "unable to unmarshal install.xml");
			//e.printStackTrace();
		}
		
		if (registry == null)
		{
			//if not there create new one
			registry = of.createRegistryType();
		}
		
		registry.setVersion((new Date()).toString());
	
		ProductType prod = of.createProductType();
		//set version
		VersionType vers = of.createVersionType();
		vers.setMajor(ctxt.getPackageDescriptor().getPackageIdentity().getVersion());
		//set up product
		prod.setVersion(vers);
		prod.setId(ctxt.getPackageDescriptor().getPackageIdentity().getSoftwareID());
		prod.setName(ctxt.getPackageDescriptor().getPackageIdentity().getDescription().getValue());
		prod.setPath(getInstallLoc(ctxt, artifact));
		
		//add it to registry
		registry.getProduct().add(prod);
		//marshal registry
		marshalRegistry(registry);
		
	}
	
	private static String deriveFolder()
	{
		//user dir for now, how to check for root?
		return (System.getProperty("user.home")+File.separator);
	}

	private static void marshalRegistry(RegistryType registry)
	{
		try
		{
			JAXBContext jc = JAXBContext.newInstance(RegistryType.class);
	    	Marshaller m = jc.createMarshaller();
	    	m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, new Boolean(true));
	    	m.marshal(registry, new FileOutputStream(getFolder()+FILENAME));
	        
	    }
		catch( JAXBException je )
		{
	        je.printStackTrace();
	    } catch (FileNotFoundException e) {
			e.printStackTrace();
	    }
	}
	
	private static String getInstallLoc(SDDContext ctxt, ArtifactType artifact)
	{
		//get install location out of artifact
		if(artifact.getArguments() != null)
		{
			ArgumentListType arguments = artifact.getArguments();
			for( ArgumentType argument : arguments.getArgument())
			{
				if (argument.getName().equalsIgnoreCase("installLoc"))
				{
					return  ctxt.substituteVariables(argument.getValue());
				}				
			}
		}
		return null;
	}
	
	
}

