/**********************************************************************
 * Copyright (c) 2007, 2009 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.cosmos.rm.internal.validation.SMLActivator;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementTypeMap;
import org.eclipse.cosmos.rm.internal.validation.common.ISMLConstants;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * Constructs a map that stores the relationship between the element names and their
 * associated type.
 *
 * Rewritten to use PSVI instead of parsing schemas.
 *
 * @author Ali Mehregani
 * @author David Whiteman
 * @author John Arwe
 */
public class ElementTypeMapDataBuilder extends AbstractDataBuilder<ElementTypeMap>
{
	/**
	 * The ID of this builder
	 */
	public static final String ID = SMLActivator.PLUGIN_ID + ".ElementTypeMapDataBuilder";

	/**
	 * The structure used to store the element name and type relationship
	 */
	private ElementTypeMap elementTypeMap;

	public ElementTypeMapDataBuilder()
	{
		elementTypeMap = new ElementTypeMap();
	}


	/**
	 * @see org.xml.sax.helpers.DefaultHandler#startElement(java.lang.String, java.lang.String, java.lang.String, org.xml.sax.Attributes)
	 */
	public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException
	{
		super.startElement(uri, localName, qName, attributes);
		if (ISMLConstants.SCHEMA_URI.equals(uri)) {
			return;
		}
		if (getPsvi().getElementPSVI() == null) {
			return;
		}
		XSElementDeclaration elementDeclaration = getPsvi().getElementPSVI().getElementDeclaration();
		if (elementDeclaration != null) {
			String name = elementDeclaration.getName();
			XSTypeDefinition type = getPsvi().getElementPSVI().getTypeDefinition();
			if (type.getTypeCategory() == XSTypeDefinition.SIMPLE_TYPE) {
				return;
			}
			if (((XSComplexTypeDefinition) type).getContentType() != XSComplexTypeDefinition.CONTENTTYPE_ELEMENT) {
				return;
			}
			String namespace = type.getNamespace() == null ? getDefaultNamespace() : type.getNamespace();
			String typeName = type.getName();
			if (namespace != null && name != null && typeName != null) {
				elementTypeMap.addElementDeclaration(namespace, name, typeName);
			}
		}
	}



	/**
	 * An object of type {@link ElementTypeMap} which indicates the element name
	 * and type relationship.
	 *
	 * @see org.eclipse.cosmos.rm.internal.validation.artifacts.ElementTypeMap
	 * @see org.eclipse.cosmos.rm.internal.validation.databuilders.IDataBuilder#getDataStructure()
	 */
	public ElementTypeMap getDataStructure()
	{
		return elementTypeMap;
	}

}
