/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.cosmos.me.sdd.schema.ConditionalResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.ConditionalPropertyConstraintCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.DisplayTextCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.RelationshipConstraintCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.ResourceCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.UniquenessConstraintCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.VersionConstraintValueCompare;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalResourceConstraintCompare {
    protected static Vector<ConditionalResourceConstraintType> merge(List<ConditionalResourceConstraintType> rcs, List<ConditionalResourceConstraintType> rcs2) {
        Vector<ConditionalResourceConstraintType> toRemove = new Vector<ConditionalResourceConstraintType>();
        for (ConditionalResourceConstraintType o1 : rcs) {
            for (ConditionalResourceConstraintType o2 : rcs2) {
                if (toRemove.contains(o2) || !ConditionalResourceConstraintCompare.equals(o1, o2)) continue;
                toRemove.add(o2);
                o1 = ConditionalResourceConstraintCompare.merge(o1, o2);
            }
        }
        rcs2.removeAll(toRemove);
        Vector<ConditionalResourceConstraintType> finals = new Vector<ConditionalResourceConstraintType>();
        finals.addAll(rcs);
        finals.addAll(rcs2);
        return finals;
    }

    protected static ConditionalResourceConstraintType merge(ConditionalResourceConstraintType o1, ConditionalResourceConstraintType o2) {
        ObjectFactory objectFactory = new ObjectFactory();
        ConditionalResourceConstraintType rc = objectFactory.createConditionalResourceConstraintType();
        rc.setDescription(DisplayTextCompare.merge(o1.getDescription(), o2.getDescription()));
        rc.setDisplayName(DisplayTextCompare.merge(o1.getDisplayName(), o2.getDisplayName()));
        rc.setId(o1.getId());
        rc.setName(StringCompare.merge(o1.getName(), o2.getName()));
        rc.getPropertyConstraint().addAll(ConditionalPropertyConstraintCompare.merge(o1.getPropertyConstraint(), o2.getPropertyConstraint()));
        rc.getRelationshipConstraint().addAll(RelationshipConstraintCompare.merge(o1.getRelationshipConstraint(), o2.getRelationshipConstraint()));
        rc.setShortDescription(DisplayTextCompare.merge(o1.getShortDescription(), o2.getShortDescription()));
        rc.getUniquenessConstraint().addAll(UniquenessConstraintCompare.merge(o1.getUniquenessConstraint(), o2.getUniquenessConstraint()));
        rc.setVersionConstraint(VersionConstraintValueCompare.merge(o1.getVersionConstraint(), o2.getVersionConstraint()));
        rc.setTestValue(Boolean.valueOf(o1.isTestValue()));
        return rc;
    }

    protected static boolean equals(List<ConditionalResourceConstraintType> rc, List<ConditionalResourceConstraintType> rc2) {
        if (rc.size() != rc2.size()) {
            return false;
        }
        Iterator<ConditionalResourceConstraintType> iter = rc.iterator();
        while (iter.hasNext()) {
            iter.next();
            Iterator<ConditionalResourceConstraintType> iterc2 = rc2.iterator();
            boolean notfound = true;
            ConditionalResourceConstraintType o2 = null;
            while (iterc2.hasNext() && notfound) {
                o2 = iterc2.next();
                if (!ConditionalResourceConstraintCompare.equals(rc, rc2)) continue;
                notfound = false;
            }
            if (notfound) {
                return false;
            }
            rc2.remove(o2);
        }
        return true;
    }

    protected static boolean equals(ConditionalResourceConstraintType rc, ConditionalResourceConstraintType rc2) {
        if (!ResourceCompare.equals((ResourceType)rc.getResourceRef(), (ResourceType)rc2.getResourceRef())) {
            return false;
        }
        return rc.isTestValue() == rc2.isTestValue();
    }
}

