/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.tooling.btg;

import javax.xml.bind.JAXBElement;

import org.eclipse.cosmos.me.sdd.schema.DeploymentDescriptorType;

public class SDDFragment {

	JAXBElement<DeploymentDescriptorType> fragment;
	Object metadata;
	
	public SDDFragment(JAXBElement<DeploymentDescriptorType> fragment, Object metadata) {
		this.fragment = fragment;
		this.metadata = metadata;
	}
	
	/**
	 * @return the metadata
	 */
	public Object getMetadata() {
		return metadata;
	}

	/**
	 * @param metadata the metadata to set
	 */
	public void setMetadata(Object metadata) {
		this.metadata = metadata;
	}

	/**
	 * @return the fragment
	 */
	public JAXBElement<DeploymentDescriptorType> getFragment() {
		return fragment;
	}

	/**
	 * @param fragment the fragment to set
	 */
	public void setFragment(JAXBElement<DeploymentDescriptorType> fragment) {
		this.fragment = fragment;
	}
}