/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dr.internal.web.ui.viewer;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class WebViewer{

	/**
	 * host for web application
	 */
	private static String host = "127.0.0.1"; //$NON-NLS-1$

	/**
	 * port for web application
	 */
	private static int port = 38284;
	
	private static IWebBrowser internalBrowser;

	private static boolean webStarted = false;
	
	/**
	 * Start web application.
	 */
	private synchronized static void startWebApp( )
	{
		if (checkUpdate()){
			stopWebApp();
		}
		if ( webStarted )
			return;
		try
		{
			start( Activator.WEBAPP_CONTEXT );
		}
		catch ( Exception e )
		{
		}
	}

	/**
	 * Stop web application
	 */
	private static void stopWebApp( )
	{
		if ( !webStarted )
			return;		
		try
		{
			stop( Activator.WEBAPP_CONTEXT );
		}
		catch ( Exception e )
		{
			e.printStackTrace();
		}
	}
	
	/**
	 * Displays the specified url.
	 */
	public static void display( Map<String, String> params) throws CoreException
	{

		startWebApp( );

		try
		{
			if ( internalBrowser == null )
			{
				// Create the browser
				IWorkbenchBrowserSupport support= PlatformUI.getWorkbench().getBrowserSupport();
				try {
					internalBrowser= support.createBrowser(null);
				} catch (PartInitException e) {
//					Activator.logErrorStatus("Could not create Web browser", e.getStatus()); //$NON-NLS-1$
					return;
				}

			}		
			try {
				Iterator<String> iter = params.keySet().iterator();
				String paramsString = "?func=directMDR"; //$NON-NLS-1$
				while (iter.hasNext()){
					paramsString += "&"; //$NON-NLS-1$
					String key = iter.next();
					paramsString += key + "="+URLEncoder.encode(params.get(key),"UTF-8"); //$NON-NLS-1$ //$NON-NLS-2$
				}
				internalBrowser.openURL(new URL("http://"+host+":"+port+"/"+Activator.WEBAPP_NAME+"/index.jsp"+paramsString)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			} catch (PartInitException e) {
			} catch (MalformedURLException e) {
			}
		}
		catch ( Exception e )
		{
			throw new CoreException(Activator.createErrorStatus(Messages.getString("WebViewer.5"))); //$NON-NLS-1$
		}
	}
	
	public static boolean checkUpdate(){
		int newPort = -1;
		try {
			// configure web server
			newPort = Integer.parseInt(Activator.getDefault().getPortPreference());
		} catch (Exception e) {
			return false;
		}
		String newHost = Activator.getDefault().getHostPreference();
		
		return ((newPort != port) || (!host.equals(newHost))); 
	}

	public static void  start( String webappName ) throws CoreException
	{
		try {
			// configure web server
			port = Integer.parseInt(Activator.getDefault().getPortPreference());
		} catch (Exception e) {
			return;
		}
		host = Activator.getDefault().getHostPreference();
		
		Dictionary<String, Object> dict = new Hashtable<String, Object>( );

		// configure the port
		dict.put( "http.port", new Integer( port ) ); //$NON-NLS-1$

		// configure the host
		dict.put( "http.host", host ); //$NON-NLS-1$

		dict.put( "other.info", Activator.PLUGIN_ID ); //$NON-NLS-1$

		try {
			JettyConfigurator.startServer( webappName, dict );

			ensureBundleStarted( "org.eclipse.equinox.http.registry" ); //$NON-NLS-1$
		} catch (BundleException e) {
			throw new CoreException(Activator.createErrorStatus(Messages.getString("WebViewer.6"), e)); //$NON-NLS-1$
		} catch (Exception e) {
			throw new CoreException(Activator.createErrorStatus(Messages.getString("WebViewer.7"), e)); //$NON-NLS-1$
		}
		webStarted = true;
	}

	public static void stop( String webappName ) throws CoreException
	{
		try {
			JettyConfigurator.stopServer( webappName );
			webStarted = false;
		} catch (Exception e) {
			throw new CoreException(Activator.createErrorStatus(Messages.getString("WebViewer.8"), e)); //$NON-NLS-1$
		}
	}

	private static void ensureBundleStarted( String symbolicName )
			throws BundleException
	{
		Bundle bundle = Platform.getBundle( symbolicName );
		if ( bundle != null )
		{
			if ( bundle.getState( ) == Bundle.RESOLVED )
			{
				bundle.start( Bundle.START_TRANSIENT );
			}
		}
	}	
	

}