/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.response.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryResult;

public class QueryResult
implements IQueryResult {
    private Map<String, INodes> nodes = new Hashtable<String, INodes>();
    private Map<String, IEdges> edges = new Hashtable<String, IEdges>();

    public INodes[] getAllNodes() {
        return this.nodes.values().toArray(new INodes[this.nodes.size()]);
    }

    public INodes getNodes(String id) {
        return this.nodes.get(id);
    }

    public IEdges[] getAllEdges() {
        return this.edges.values().toArray(new IEdges[this.edges.size()]);
    }

    public IEdges getEdges(String id) {
        return this.edges.get(id);
    }

    public void addNodes(INodes nodes) {
        this.nodes.put(nodes.getId(), nodes);
    }

    public void removeNodes(INodes nodes) {
        this.nodes.remove(nodes.getId());
    }

    public void addEdges(IEdges edges) {
        this.edges.put(edges.getId(), edges);
    }

    public void removeEdges(IEdges edges) {
        this.edges.remove(edges.getId());
    }

    public String[] getNodesIds() {
        return this.nodes.keySet().toArray(new String[this.nodes.size()]);
    }

    public String[] getEdgesIds() {
        return this.edges.keySet().toArray(new String[this.edges.size()]);
    }

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write("<cmdbf:queryResult xmlns:cmdbf=\"http://cmdbf.org/schema/1-0-0/datamodel\">" + ICMDBfServicesConstants.nl);
        CMDBfServicesUtil.outputListToXML((StringWriter)writer, (int)(indent + 1), new ArrayList<INodes>(this.nodes.values()));
        CMDBfServicesUtil.outputListToXML((StringWriter)writer, (int)(indent + 1), new ArrayList<IEdges>(this.edges.values()));
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor((String)"cmdbf:queryResult")) + ICMDBfServicesConstants.nl);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.edges == null ? 0 : this.edges.hashCode());
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryResult other = (QueryResult)obj;
        if (this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes)) {
            return false;
        }
        return !(this.edges == null ? other.edges != null : !this.edges.equals(other.edges));
    }
}

