/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTree");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator");


dojo.declare(
	// class
	"org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTree",

	// superclass	
	[org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator],
	
	// member variables/functions
	{
		// summary: This class provides a tree widget that manages the query capabilities on an itemTemplate or a relationshipTemplate of a CMDBf query 
		// description: This widget will show a tree that allows the user the ability to right-click the itemTemplate or relationsthipTempalte node 
		//              to add query capabilities.  The user also has the ability to remove query capability nodes.
		//singleClickEdit:boolean 
		singleClickEdit: true,
		//contextMenuFactor: org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryMenu
		// provides the a menu factory to construct menu items within a menu
	    contextMenuFactory: null,
		create: function(params, srcNodeRef) {
			//summary: the create method of the widget
			//description: In the create method the 'params.contextMap.store' provides the tree widget's content.  The 'params.contextMap.menuFactory'
		    //             provides the menu factory that determines what kind of query capabilities can be added to an itemTemplate or relationshipTemplate
		    //             node.
			if ((params.contextMap) && (params.contextMap.menuFactory)){
				params.menuFactory = params.contextMap.menuFactory;														
			}
			if ((params.contextMap) && (params.contextMap.store)){
				params.store =  params.contextMap.store[0];
				params.store.UIContext = params.UIContext;														
				org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTree.superclass.create.apply(this, arguments);
			}
			else{
					org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTree.superclass.create.apply(this, arguments);
			}
		},	    
		postCreate: function(){
			//summary: the postCreate method of the widget
			org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTree.superclass.postCreate.apply(this, arguments);
			this.contextMenuFactory = new org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTreeMenu();
			this.contextMenuFactory.store = this.menuFactory;
		},
		deleteTreeNode:function(treeNode){
			//summary: removes the treeNode passed in from the tree widget.
			org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTree.superclass.deleteTreeNode.apply(this, arguments);
			//need to publish that the node was deleted
			for (var i=0;i < this.publish.length;i++){
		 	    //lets clone the information we're going to send to another widget since we don't want the other
		 	    //widget modifying our content
				var cloneMap = new Object();
		 	    dojo.mixin(cloneMap,treeNode.item);
		 	    //let tag the data we're going to send so that the consumer of this data knows where the data came from
		 	    cloneMap.nodeClass = this.attachPoint + " nodedeleted" ;
				dojo.publish(this.publish[i], [{contextMap:cloneMap}]);
			}
			
		},				
		createContextMenu: function(e){
			//summary: constructs the menu options on a node.
			var menu = this.menu;
			this.menu.getChildren().forEach(function(i){menu.removeChild(i);});
			var tn = dijit.getEnclosingWidget(e.target);
			this.contextMenuFactory.sourceObject=this;		
			this.contextMenuFactory.UIContext = this.UIContext;		
			this.contextMenuFactory.createContextMenu(this.menu,tn,tn.item.nodeClass);
			this.contextMenuFactory.nodeFactory = this.contextMap.nodeFactory;
			
		}
	}
	
);	


dojo.declare(
		   "org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTreeMenu",
			// superclass	
			org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryMenu,
			{
			   //nodeFactory:org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryBuilderFactory
			   //  factory class that is used to construct new nodes
			   nodeFactory:null,
				// summary: This class provides the menu options for the tree that manages the query capabilities on a relationshpiTemplate or itemTemplate node 			   
				addTreeNode:function(/*Object*/store, /*String*/nodeClass, /*String*/parentClass, /*Object*/childMenuItem){
			   		// summary: adds a node to the tree
			   		// description: the store.item contains the parent node that the new node will be added to.  The nodeClass is the tag name
			   		//             that will be used to create the node using the node factory.
			   		var _self = this;
			   		this.nodeFactory.createNode(nodeClass, parentClass,function(node, childrenNodes){
				   		var parentObj = store.tree.addTreeNode(node, store.item, true);
						if  (childrenNodes){
							for (var z = 0 ; z < childrenNodes.length; z++){
				   				store.tree.addTreeNode(childrenNodes[z], parentObj, true);
							}
						}
			   		});
		   		},
				createContextMenu:function(/*Object*/menu, /*Object*/store, /*String*/className){
		   		   //summary: This method will construct the menu options on a particular node within the tree. 
		   		   //description: The menu option list is dynamic and is based on what node is selected in the tree.
		   		   //menu: the menu to add the menu options
		   		   //store: a store that contains the rules to determine which menu options can be shown on a particular node.
		   		   //className: not used
				   var queryValue = store.item.nodeClass;
				   if (dojo.isArray(store.item.nodeClass)){
					   queryValue = store.item.nodeClass[0];
				   }
			   		var _self = this;			
					this.store.fetch({
						   query: {nodeClass: queryValue},
						   queryOptions:{deep:true},
						   onComplete:function(items, request){
							   if (items.length > 0){
								   //there should only be one item in the menu store
								   if ((items[0].children) && (items[0].children.length >0)){
									   for (var i = 0; i < items[0].children.length; i++){
										   var childMenuItem = items[0].children[i];
										   if ((childMenuItem.nodeClass == 'delete') || (childMenuItem.nodeClass == 'reldelete')){
												menu.addChild(new dijit.MenuItem({onClick:function(){
													store.tree.deleteTreeNode(store.item);
												},
												label:childMenuItem.title +" "+queryValue
												}));											   
										   }
										   else{
											   if (childMenuItem.menuRules){
													store.tree.store.fetch({
														query: {object:queryValue+"*"},
														queryOptions:{deep:true},
													   onComplete:function(items, request){
															   if (items.length == 0){
																	menu.addChild(new dijit.MenuItem({childMenuItem:childMenuItem, onClick:function(){
																		_self.addTreeNode(store, this.childMenuItem.nodeClass, queryValue, this.childMenuItem);
																	},
																	label:childMenuItem.title
																	}));
															   }
															   else{
																   var found = false
																   for (var y = 0; y < items.length; y++){
																	   for (var x = 0; x < childMenuItem.menuRules.length; x++){
																		   if (items[y].nodeClass == childMenuItem.menuRules[x]){
																			   found = true;
																		   }
																	   }
																   }
																   if (!found){
																		menu.addChild(new dijit.MenuItem({childMenuItem:childMenuItem, onClick:function(){
																			_self.addTreeNode(store, this.childMenuItem.nodeClass, queryValue, this.childMenuItem);
																		},
																		label:childMenuItem.title
																		}));
																   }
															   }
														}
													});														
											   }
											   else{
													menu.addChild(new dijit.MenuItem({childMenuItem:childMenuItem, onClick:function(){
														_self.addTreeNode(store, this.childMenuItem.nodeClass, queryValue, this.childMenuItem);
													},
													label:childMenuItem.title
													}));
											   }
										   }
									   }
								   }
							   }
						   }
						});
			   					   		
				}
			}
		); 




