/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.reference.URIReference;

public class SchemaBindings {
    private SchemaBinding defaultBinding;
    private List<SchemaBinding> bindings = new ArrayList<SchemaBinding>();
    private SchemaBinding noSchemaBindings;
    private boolean present;

    public void setDefaultBinding(SchemaBinding schemaBinding) {
        this.defaultBinding = schemaBinding;
    }

    public SchemaBinding getDefaultBinding() {
        return this.defaultBinding;
    }

    public void addBinding(SchemaBinding schemaBinding) {
        this.bindings.add(schemaBinding);
    }

    public SchemaBinding[] getBindings() {
        return this.bindings.toArray(new SchemaBinding[this.bindings.size()]);
    }

    public boolean isPresent() {
        return this.present;
    }

    public void setPresent(boolean present) {
        this.present = present;
    }

    public SchemaBinding getNoSchemaBindings() {
        return this.noSchemaBindings;
    }

    public void setNoSchemaBindings(SchemaBinding noSchemaBindings) {
        this.noSchemaBindings = noSchemaBindings;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SchemaBinding {
        private List<String> schemaAliases = new ArrayList<String>();
        private List<String> documentAliases = new ArrayList<String>();

        public void addSchemaAlias(String alias, URI baseURI, IValidationOutput<?, ?> logger, int lineNumber) {
            if ((alias = URIReference.validAliasOrAliasPrefix(alias, baseURI, logger, lineNumber, SMLValidationMessages.schemaBindingSchemaAlias)) != null) {
                this.schemaAliases.add(alias);
            }
        }

        public String[] getSchemaAliases() {
            return this.schemaAliases.toArray(new String[this.schemaAliases.size()]);
        }

        public void addDocumentAlias(String alias, URI baseURI, IValidationOutput<?, ?> logger, int lineNumber) {
            if ((alias = URIReference.validAliasOrAliasPrefix(alias, baseURI, logger, lineNumber, SMLValidationMessages.schemaBindingDocumentAlias)) != null) {
                this.documentAliases.add(alias);
            }
        }

        public String[] getDocumentAliases() {
            return this.documentAliases.toArray(new String[this.documentAliases.size()]);
        }
    }
}

