/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

/**
 * Constants used by the outputters
 * 
 * @author Ali Mehregani
 */
public interface IOutputterConstants
{
	/**
	 * Miscellaneous constants
	 */
	public static final String NULL = "null"; //$NON-NLS-1$
	
	
	/**
	 * Namespace constants
	 */
	public static final String NAMESPACE_DATAMANAGER = "http://www.eclipse.org/cosmos/datamanager"; //$NON-NLS-1$
	public static final String NAMESPACE_QUERY = "http://cmdbf.org/schema/1-0-0/query"; //$NON-NLS-1$
	public static final String NAMESPACE_REGISTRATION = "http://cmdbf.org/schema/1-0-0/registration"; //$NON-NLS-1$
	
	
	/**
	 * Common JSON constants
	 */
	public static final String IDENTIFIER = "identifier";
	public static final String LABEL = "label";
	public static final String MDR_ID = "mdrId";
	public static final String LOCAL_ID = "localId";
	public static final String UNKNOWN = "unknown";
	public static final String TRUE = "true";

	
	
	/**
	 * Constants used by the registration/deregistration outputter
	 */
	public static final String RESPONSE = "response";
	public static final String ITEMS = "items";
	public static final String TYPE = "type";
	public static final String ID = "id";
	
	
	/**
	 * Constants used by the graph query response
	 */
	public static final String ITEM_TEMPLATE = "itemTemplate";
	public static final String RELATIONSHIP_TEMPLATE = "relationshipTemplate";
	public static final String ELEMENTS = "elements";
	public static final String INSTANCE_ID = "instanceId";
	public static final String ADDITIONAL_RECORDS = "additionalRecords";
	public static final String NAMESPACE = "namespace";
	public static final String LOCAL_NAME = "localName";
	public static final String RECORDS = "records";
	public static final String LAST_MODIFIED = "lastModified";
	public static final String SNAP_ID = "snapId";
	public static final String BASE_ID = "baseId";
	public static final String VALUE = "value";
	public static final String SOURCE = "source";
	public static final String TARGET = "target";	
	public static final String TEMPLATE = "template";	
	public static final String CONNECTIONS = "connections";
	public static final String ITEM = "item";
	public static final String RELATIONSHIP = "relationship";
	public static final String RECORD = "record";
}
