/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.text.MessageFormat;
import java.util.Properties;
import java.util.Set;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.eclipse.cosmos.common.provisional.exceptions.CosmosException;
import org.eclipse.cosmos.dc.broker.provisional.client.BrokerClient;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Group;
import org.eclipse.cosmos.dc.test.CommandEntry;
import org.eclipse.cosmos.dc.test.CosmosCLI;
import org.eclipse.cosmos.dc.test.Messages;
import org.eclipse.cosmos.dc.test.Tokenizer;

class CmdDMInfo
extends CommandEntry {
    private static final String DM_NAMESPACE = "http://datamanager.provisional.dc.cosmos.eclipse.org";
    private String _id = null;
    private String eprstr = null;

    public CmdDMInfo(CosmosCLI cli) {
        this._cli = cli;
        this._command = new String("GetDataManagerInfo");
        this._usage_entry = new String("USAGE_DMINFO_INFO");
    }

    public void performAction() throws Exception {
        if (!this.getEPR()) {
            return;
        }
        EndpointReference epr = new EndpointReference(this.eprstr);
        ServiceClient sender = null;
        Options options = new Options();
        options.setTo(epr);
        options.setTransportInProtocol("http");
        try {
            sender = new ServiceClient();
        }
        catch (AxisFault a) {
            throw new CosmosException("AxisFault");
        }
        sender.setOptions(options);
        Object ret = null;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(DM_NAMESPACE, "tns");
        OMElement tsRequest = fac.createOMElement("getDataManagerInfo", omNs);
        OMElement result = null;
        try {
            result = sender.sendReceive(tsRequest);
        }
        catch (AxisFault a) {
            throw new CosmosException(a.getMessage());
        }
        Group g = this.PopulateGroup(result);
        this.Print(g);
    }

    public boolean validateArguments(Tokenizer st, String line) {
        if (!st.hasMoreTokens()) {
            this._cli.logMessage(Messages.getString("MISSING_DM_ID_ERR"));
            return false;
        }
        this._id = st.nextToken();
        return true;
    }

    private void Print(Group g) {
        System.out.println("Id = " + g.getId());
        System.out.println("DisplayName = " + g.getName());
        System.out.println("Description = " + g.getDescription());
        System.out.println("SoapNamespace = " + g.getSoapNamespace());
        System.out.println("RecordTypeNamespace = " + g.getRecordTypeNamespace());
        System.out.println("SecurityNamespace = " + g.getSecurityNamespace());
        Properties p = g.getProperties();
        Set<Object> ks = p.keySet();
        Object[] o = ks.toArray();
        int i = 0;
        for (i = 0; i < o.length; ++i) {
            String tstr = o[i].toString();
            String pstr = p.getProperty(tstr);
            System.out.println(tstr + " = " + pstr);
        }
    }

    private Group PopulateGroup(OMElement result) {
        Group g = Group.getGroup((OMElement)result);
        return g;
    }

    private boolean getEPR() throws Exception {
        BrokerClient brokerclient = new BrokerClient(this._cli.getBrokerEPR());
        DataManager dm = null;
        try {
            dm = brokerclient.getDataManagerById(this._id);
        }
        catch (Exception a) {
            if (a.getMessage().equals("unknown")) {
                this._cli.logMessage(MessageFormat.format(Messages.getString("DMID_NOT_FOUND_ERR"), this._id));
                return false;
            }
            throw a;
        }
        this.eprstr = dm.getServiceEPR("http://www.eclipse.org/cosmos/datamanager");
        return true;
    }
}

