/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.BatchUpdateException;
import org.apache.derby.client.am.Blob;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.CrossConverters;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.MaterialPreparedStatement;
import org.apache.derby.client.am.ParameterMetaData;
import org.apache.derby.client.am.PreparedStatementCallbackInterface;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.Types;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.jdbc.ClientDriver;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement,
PreparedStatementCallbackInterface {
    public MaterialPreparedStatement materialPreparedStatement_ = null;
    public String sql_;
    public boolean outputRegistered_ = false;
    public Object[] parameters_;
    boolean[] parameterSet_;
    boolean[] parameterRegistered_;
    public ColumnMetaData parameterMetaData_;
    private ArrayList parameterTypeList;
    String positionedUpdateCursorName_ = null;
    protected final ClientPooledConnection pooledConnection_;
    boolean listenToUnitOfWork_ = false;

    void setInput(int parameterIndex, Object input) {
        this.parameters_[parameterIndex - 1] = input;
        this.parameterSet_[parameterIndex - 1] = true;
    }

    private void initPreparedStatement() {
        this.materialPreparedStatement_ = null;
        this.sql_ = null;
        this.outputRegistered_ = false;
        this.parameters_ = null;
        this.parameterSet_ = null;
        this.parameterRegistered_ = null;
        this.parameterMetaData_ = null;
        this.parameterTypeList = null;
        this.isAutoCommittableStatement_ = true;
        this.isPreparedStatement_ = true;
    }

    protected void initResetPreparedStatement() {
        this.outputRegistered_ = false;
        this.isPreparedStatement_ = true;
        this.resetParameters();
    }

    public void reset(boolean fullReset) throws SqlException {
        if (fullReset) {
            this.connection_.resetPrepareStatement(this);
        } else {
            super.initResetPreparedStatement();
            this.initResetPreparedStatement();
        }
    }

    void resetForReuse() throws SqlException {
        this.resetParameters();
        super.resetForReuse();
    }

    private void resetParameters() {
        if (this.parameterMetaData_ != null) {
            Arrays.fill(this.parameters_, null);
            Arrays.fill(this.parameterSet_, false);
            Arrays.fill(this.parameterRegistered_, false);
        }
    }

    public PreparedStatement(Agent agent, Connection connection, String sql, Section section, ClientPooledConnection cpc) throws SqlException {
        super(agent, connection);
        this.isPoolable = true;
        this.initPreparedStatement(sql, section);
        this.pooledConnection_ = cpc;
    }

    public void resetPreparedStatement(Agent agent, Connection connection, String sql, Section section) throws SqlException {
        super.resetStatement(agent, connection);
        this.initPreparedStatement();
        this.initPreparedStatement(sql, section);
    }

    private void initPreparedStatement(String sql, Section section) throws SqlException {
        this.sql_ = sql;
        this.isPreparedStatement_ = true;
        this.parseSqlAndSetSqlModes(this.sql_);
        this.section_ = section;
    }

    public PreparedStatement(Agent agent, Connection connection, String sql, int type, int concurrency, int holdability, int autoGeneratedKeys, String[] columnNames, int[] columnIndexes, ClientPooledConnection cpc) throws SqlException {
        super(agent, connection, type, concurrency, holdability, autoGeneratedKeys, columnNames, columnIndexes);
        this.isPoolable = true;
        this.initPreparedStatement(sql);
        this.pooledConnection_ = cpc;
    }

    public void resetPreparedStatement(Agent agent, Connection connection, String sql, int type, int concurrency, int holdability, int autoGeneratedKeys, String[] columnNames, int[] columnIndexes) throws SqlException {
        super.resetStatement(agent, connection, type, concurrency, holdability, autoGeneratedKeys, columnNames, columnIndexes);
        this.initPreparedStatement();
        this.initPreparedStatement(sql);
    }

    private void initPreparedStatement(String sql) throws SqlException {
        String[] sqlAndCursorName;
        this.sql_ = super.escape(sql);
        this.parseSqlAndSetSqlModes(this.sql_);
        this.isPreparedStatement_ = true;
        String cursorName = null;
        if ((this.sqlUpdateMode_ == 64 || this.sqlUpdateMode_ == 128) && (sqlAndCursorName = this.extractCursorNameFromWhereCurrentOf(this.sql_)) != null) {
            cursorName = sqlAndCursorName[0];
            this.sql_ = sqlAndCursorName[1];
        }
        if (cursorName != null) {
            this.positionedUpdateCursorName_ = cursorName;
            this.section_ = this.agent_.sectionManager_.getPositionedUpdateSection(cursorName, false);
            if (this.section_ == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ114.S"), cursorName);
            }
            if (this.section_.getClientCursorName() != null && cursorName.compareTo(this.section_.getClientCursorName()) == 0) {
                this.sql_ = this.substituteClientCursorNameWithServerCursorName(this.sql_, this.section_);
            }
        } else {
            this.section_ = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
        }
    }

    public void resetPreparedStatement(Agent agent, Connection connection, String sql, Section section, ColumnMetaData parameterMetaData, ColumnMetaData resultSetMetaData) throws SqlException {
        this.resetPreparedStatement(agent, connection, sql, section);
        this.initPreparedStatement(parameterMetaData, resultSetMetaData);
    }

    private void initPreparedStatement(ColumnMetaData parameterMetaData, ColumnMetaData resultSetMetaData) throws SqlException {
        this.isPreparedStatement_ = true;
        this.parameterMetaData_ = parameterMetaData;
        this.resultSetMetaData_ = resultSetMetaData;
        if (this.parameterMetaData_ != null) {
            this.parameters_ = new Object[this.parameterMetaData_.columns_];
            this.parameterSet_ = new boolean[this.parameterMetaData_.columns_];
            this.parameterRegistered_ = new boolean[this.parameterMetaData_.columns_];
        }
    }

    void prepare() throws SqlException {
        try {
            this.flowPrepareDescribeInputOutput();
        }
        catch (SqlException e) {
            this.markClosed();
            throw e;
        }
    }

    public boolean execute(String sql) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "execute", sql);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "execute(String)").getSQLException();
    }

    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "executeQuery", sql);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "executeQuery(String)").getSQLException();
    }

    public int executeUpdate(String sql) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", sql);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "executeUpdate(String)").getSQLException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet executeQuery() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeQuery");
                }
                ResultSet resultSet = this.executeQueryX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeQuery", resultSet);
                }
                return resultSet;
            }
        }
        catch (SqlException se) {
            this.checkStatementValidity(se);
            throw se.getSQLException();
        }
    }

    ResultSet executeQueryX() throws SqlException {
        this.flowExecute(1);
        return this.resultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeUpdate");
                }
                int updateValue = this.executeUpdateX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", updateValue);
                }
                return updateValue;
            }
        }
        catch (SqlException se) {
            this.checkStatementValidity(se);
            throw se.getSQLException();
        }
    }

    private int executeUpdateX() throws SqlException {
        this.flowExecute(2);
        return this.updateCount_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull(int parameterIndex, int jdbcType) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setNull", parameterIndex, jdbcType);
                }
                this.checkForClosedStatement();
                this.checkForSupportedDataType(jdbcType);
                int paramType = this.getColumnMetaDataX().getColumnType(parameterIndex);
                if (!PossibleTypes.getPossibleTypesForNull(paramType).checkType(jdbcType)) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, jdbcType, paramType);
                }
                this.setNullX(parameterIndex, jdbcType);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    void setNullX(int parameterIndex, int jdbcType) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = jdbcType;
        if (!this.parameterMetaData_.nullable_[parameterIndex - 1]) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("23502"), new Integer(parameterIndex));
        }
        this.setInput(parameterIndex, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull(int parameterIndex, int jdbcType, String typeName) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setNull", parameterIndex, jdbcType, (Object)typeName);
            }
            this.setNull(parameterIndex, jdbcType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int paramType;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setBoolean", parameterIndex, x);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(paramType = this.getColumnMetaDataX().getColumnType(parameterIndex))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 16, paramType);
                }
                this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = -7;
                this.setInput(parameterIndex, new Short((short)(x ? 1 : 0)));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int paramType;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setByte", parameterIndex, x);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(paramType = this.getColumnMetaDataX().getColumnType(parameterIndex))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, -6, paramType);
                }
                this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = -6;
                this.setInput(parameterIndex, new Short(x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int paramType;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setShort", parameterIndex, x);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(paramType = this.getColumnMetaDataX().getColumnType(parameterIndex))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 5, paramType);
                }
                this.setShortX(parameterIndex, x);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    void setShortX(int parameterIndex, short x) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = 5;
        this.setInput(parameterIndex, new Short(x));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int paramType;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setInt", parameterIndex, x);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(paramType = this.getColumnMetaDataX().getColumnType(parameterIndex))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 4, paramType);
                }
                this.setIntX(parameterIndex, x);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    void setIntX(int parameterIndex, int x) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = 4;
        this.setInput(parameterIndex, new Integer(x));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int paramType;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setLong", parameterIndex, x);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(paramType = this.getColumnMetaDataX().getColumnType(parameterIndex))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 4, paramType);
                }
                this.setLongX(parameterIndex, x);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    void setLongX(int parameterIndex, long x) {
        this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = -5;
        this.setInput(parameterIndex, new Long(x));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int paramType;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setFloat", parameterIndex, x);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(paramType = this.getColumnMetaDataX().getColumnType(parameterIndex))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 6, paramType);
                }
                this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = 7;
                this.setInput(parameterIndex, new Float(x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int paramType;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setDouble", parameterIndex, x);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(paramType = this.getColumnMetaDataX().getColumnType(parameterIndex))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 8, paramType);
                }
                this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = 8;
                this.setInput(parameterIndex, new Double(x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int paramType;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setBigDecimal", parameterIndex, (Object)x);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(paramType = this.getColumnMetaDataX().getColumnType(parameterIndex))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, -5, paramType);
                }
                this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = 3;
                if (x == null) {
                    this.setNull(parameterIndex, 3);
                    return;
                }
                boolean registerOutScale = false;
                this.setInput(parameterIndex, x);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int paramType;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setDate", parameterIndex, (Object)x);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_DATE.checkType(paramType = this.getColumnMetaDataX().getColumnType(parameterIndex))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 91, paramType);
                }
                this.checkForClosedStatement();
                this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = 91;
                if (x == null) {
                    this.setNull(parameterIndex, 91);
                    return;
                }
                this.setInput(parameterIndex, x);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(int parameterIndex, Date x, Calendar calendar) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setDate", parameterIndex, (Object)x, (Object)calendar);
                }
                this.checkForClosedStatement();
                if (calendar == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)"null", (Object)"calendar", "setDate");
                }
                Calendar targetCalendar = Calendar.getInstance(calendar.getTimeZone());
                targetCalendar.clear();
                targetCalendar.setTime(x);
                Calendar defaultCalendar = Calendar.getInstance();
                defaultCalendar.clear();
                defaultCalendar.setTime(x);
                long timeZoneOffset = targetCalendar.get(15) - defaultCalendar.get(15) + targetCalendar.get(16) - defaultCalendar.get(16);
                Date adjustedDate = timeZoneOffset == 0L || x == null ? x : new Date(x.getTime() + timeZoneOffset);
                this.setDate(parameterIndex, adjustedDate);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int paramType;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setTime", parameterIndex, (Object)x);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_TIME.checkType(paramType = this.getColumnMetaDataX().getColumnType(parameterIndex))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 92, paramType);
                }
                this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = 92;
                if (x == null) {
                    this.setNull(parameterIndex, 92);
                    return;
                }
                this.setInput(parameterIndex, x);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(int parameterIndex, Time x, Calendar calendar) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setTime", parameterIndex, (Object)x, (Object)calendar);
                }
                this.checkForClosedStatement();
                if (calendar == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)"null", (Object)"calendar", "setTime()");
                }
                Calendar targetCalendar = Calendar.getInstance(calendar.getTimeZone());
                targetCalendar.clear();
                targetCalendar.setTime(x);
                Calendar defaultCalendar = Calendar.getInstance();
                defaultCalendar.clear();
                defaultCalendar.setTime(x);
                long timeZoneOffset = targetCalendar.get(15) - defaultCalendar.get(15) + targetCalendar.get(16) - defaultCalendar.get(16);
                Time adjustedTime = timeZoneOffset == 0L || x == null ? x : new Time(x.getTime() + timeZoneOffset);
                this.setTime(parameterIndex, adjustedTime);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int paramType;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setTimestamp", parameterIndex, (Object)x);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_TIMESTAMP.checkType(paramType = this.getColumnMetaDataX().getColumnType(parameterIndex))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 93, paramType);
                }
                this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = 93;
                if (x == null) {
                    this.setNull(parameterIndex, 93);
                    return;
                }
                this.setInput(parameterIndex, x);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar calendar) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                Timestamp adjustedTimestamp;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setTimestamp", parameterIndex, (Object)x, (Object)calendar);
                }
                this.checkForClosedStatement();
                if (calendar == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)"null", (Object)"calendar", "setTimestamp()");
                }
                Calendar targetCalendar = Calendar.getInstance(calendar.getTimeZone());
                targetCalendar.clear();
                targetCalendar.setTime(x);
                Calendar defaultCalendar = Calendar.getInstance();
                defaultCalendar.clear();
                defaultCalendar.setTime(x);
                long timeZoneOffset = targetCalendar.get(15) - defaultCalendar.get(15) + targetCalendar.get(16) - defaultCalendar.get(16);
                Timestamp timestamp = adjustedTimestamp = timeZoneOffset == 0L || x == null ? x : new Timestamp(x.getTime() + timeZoneOffset);
                if (x != null) {
                    adjustedTimestamp.setNanos(x.getNanos());
                }
                this.setTimestamp(parameterIndex, adjustedTimestamp);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setString", parameterIndex, (Object)x);
                }
                int paramType = this.getColumnMetaDataX().getColumnType(parameterIndex);
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_STRING.checkType(paramType)) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 12, paramType);
                }
                this.setStringX(parameterIndex, x);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    void setStringX(int parameterIndex, String x) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = -1;
        if (x == null) {
            this.setNullX(parameterIndex, -1);
            return;
        }
        this.setInput(parameterIndex, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int paramType;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setBytes", parameterIndex, x);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_BYTES.checkType(paramType = this.getColumnMetaDataX().getColumnType(parameterIndex))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, -3, paramType);
                }
                this.setBytesX(parameterIndex, x);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void setBytesX(int parameterIndex, byte[] x) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = -4;
        if (x == null) {
            this.setNullX(parameterIndex, -4);
            return;
        }
        this.setInput(parameterIndex, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setBinaryStream", parameterIndex, (Object)"<input stream>", (Object)new Long(length));
                }
                this.checkTypeForSetBinaryStream(parameterIndex);
                this.checkStreamLength(length);
                this.setBinaryStreamX(parameterIndex, x, (int)length);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    protected void setBinaryStreamX(int parameterIndex, InputStream x, int length) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = 2004;
        if (x == null) {
            this.setNullX(parameterIndex, 2004);
            return;
        }
        Blob blob = length == -1 ? new Blob(this.agent_, x) : new Blob(this.agent_, x, length);
        this.setInput(parameterIndex, blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setAsciiStream", parameterIndex, (Object)"<input stream>", (Object)new Long(length));
                }
                this.checkTypeForSetAsciiStream(parameterIndex);
                this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = 2005;
                if (x == null) {
                    this.setNull(parameterIndex, -1);
                    return;
                }
                this.checkStreamLength(length);
                this.setInput(parameterIndex, new Clob(this.agent_, x, "ISO-8859-1", (int)length));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    private void checkStreamLength(long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003.S.4"), (Object)new Long(length), new Integer(Integer.MAX_VALUE)).getSQLException();
        }
        if (length < 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ025.S")).getSQLException();
        }
    }

    private void checkTypeForSetAsciiStream(int parameterIndex) throws SqlException, SQLException {
        int paramType = this.getColumnMetaDataX().getColumnType(parameterIndex);
        if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_ASCIISTREAM.checkType(paramType)) {
            PossibleTypes.throw22005Exception(this.agent_.logWriter_, -1, paramType);
        }
    }

    private void checkTypeForSetBinaryStream(int parameterIndex) throws SqlException, SQLException {
        int paramType = this.getColumnMetaDataX().getColumnType(parameterIndex);
        if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_BINARYSTREAM.checkType(paramType)) {
            PossibleTypes.throw22005Exception(this.agent_.logWriter_, -3, paramType);
        }
    }

    private void checkTypeForSetCharacterStream(int parameterIndex) throws SqlException, SQLException {
        int paramType = this.getColumnMetaDataX().getColumnType(parameterIndex);
        if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_CHARACTERSTREAM.checkType(paramType)) {
            PossibleTypes.throw22005Exception(this.agent_.logWriter_, -1, paramType);
        }
    }

    private void checkTypeForSetBlob(int parameterIndex) throws SqlException, SQLException {
        int paramType = this.getColumnMetaDataX().getColumnType(parameterIndex);
        if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_BLOB.checkType(paramType)) {
            PossibleTypes.throw22005Exception(this.agent_.logWriter_, 2004, paramType);
        }
    }

    private void checkTypeForSetClob(int parameterIndex) throws SqlException, SQLException {
        int paramType = this.getColumnMetaDataX().getColumnType(parameterIndex);
        if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_CLOB.checkType(paramType)) {
            PossibleTypes.throw22005Exception(this.agent_.logWriter_, 2005, paramType);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceDeprecatedEntry(this, "setUnicodeStream", parameterIndex, "<input stream>", length);
        }
        throw SQLExceptionFactory.notImplemented("setUnicodeStream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setCharacterStream", parameterIndex, (Object)x);
            }
            try {
                this.checkTypeForSetCharacterStream(parameterIndex);
                this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = 2005;
                if (x == null) {
                    this.setNull(parameterIndex, -1);
                    return;
                }
                this.setInput(parameterIndex, new Clob(this.agent_, x));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setCharacterStream", parameterIndex, (Object)x, (Object)new Long(length));
                }
                this.checkTypeForSetCharacterStream(parameterIndex);
                this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = 2005;
                if (x == null) {
                    this.setNull(parameterIndex, -1);
                    return;
                }
                this.checkStreamLength(length);
                this.setInput(parameterIndex, new Clob(this.agent_, x, (int)length));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, x, (long)length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int parameterIndex, java.sql.Blob x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setBlob", parameterIndex, (Object)x);
                }
                this.checkTypeForSetBlob(parameterIndex);
                this.setBlobX(parameterIndex, x);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void setBlobX(int parameterIndex, java.sql.Blob x) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = 2004;
        if (x == null) {
            this.setNullX(parameterIndex, 2004);
            return;
        }
        this.setInput(parameterIndex, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int parameterIndex, java.sql.Clob x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setClob", parameterIndex, (Object)x);
                }
                this.checkTypeForSetClob(parameterIndex);
                this.setClobX(parameterIndex, x);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    void setClobX(int parameterIndex, java.sql.Clob x) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = 2005;
        if (x == null) {
            this.setNullX(parameterIndex, 2005);
            return;
        }
        this.setInput(parameterIndex, x);
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setArray", parameterIndex, (Object)x);
                }
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setRef", parameterIndex, (Object)x);
                }
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int parameterIndex, Object x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setObject", parameterIndex, x);
                }
                if (x instanceof String) {
                    this.setString(parameterIndex, (String)x);
                } else if (x instanceof Integer) {
                    this.setInt(parameterIndex, (Integer)x);
                } else if (x instanceof Double) {
                    this.setDouble(parameterIndex, (Double)x);
                } else if (x instanceof Float) {
                    this.setFloat(parameterIndex, ((Float)x).floatValue());
                } else if (x instanceof Boolean) {
                    this.setBoolean(parameterIndex, (Boolean)x);
                } else if (x instanceof Long) {
                    this.setLong(parameterIndex, (Long)x);
                } else if (x instanceof byte[]) {
                    this.setBytes(parameterIndex, (byte[])x);
                } else if (x instanceof BigDecimal) {
                    this.setBigDecimal(parameterIndex, (BigDecimal)x);
                } else if (x instanceof Date) {
                    this.setDate(parameterIndex, (Date)x);
                } else if (x instanceof Time) {
                    this.setTime(parameterIndex, (Time)x);
                } else if (x instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)x);
                } else if (x instanceof java.sql.Blob) {
                    this.setBlob(parameterIndex, (java.sql.Blob)x);
                } else if (x instanceof java.sql.Clob) {
                    this.setClob(parameterIndex, (java.sql.Clob)x);
                } else if (x instanceof Array) {
                    this.setArray(parameterIndex, (Array)x);
                } else if (x instanceof Ref) {
                    this.setRef(parameterIndex, (Ref)x);
                } else if (x instanceof Short) {
                    this.setShort(parameterIndex, (Short)x);
                } else if (x instanceof Byte) {
                    this.setByte(parameterIndex, (Byte)x);
                } else {
                    this.checkForClosedStatement();
                    this.checkForValidParameterIndex(parameterIndex);
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ021.S"));
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int parameterIndex, Object x, int targetJdbcType) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setObject", parameterIndex, x, targetJdbcType);
                }
                this.checkForClosedStatement();
                this.setObjectX(parameterIndex, x, targetJdbcType, 0);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int parameterIndex, Object x, int targetJdbcType, int scale) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setObject", parameterIndex, x, targetJdbcType, scale);
                }
                this.checkForClosedStatement();
                this.setObjectX(parameterIndex, x, targetJdbcType, scale);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void setObjectX(int parameterIndex, Object x, int targetJdbcType, int scale) throws SqlException {
        int inputParameterType;
        this.checkForValidParameterIndex(parameterIndex);
        this.checkForValidScale(scale);
        this.checkForSupportedDataType(targetJdbcType);
        if (x == null) {
            this.setNullX(parameterIndex, targetJdbcType);
            return;
        }
        this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = inputParameterType = CrossConverters.getInputJdbcType(targetJdbcType);
        x = this.agent_.crossConverters_.setObject(inputParameterType, x);
        try {
            if (targetJdbcType == 3 || targetJdbcType == 2) {
                x = ((BigDecimal)x).setScale(scale, 1);
            }
        }
        catch (ArithmeticException ae) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), new Object[]{ae.getClass().getName(), ae.getMessage()}, (Throwable)ae);
        }
        try {
            this.setObject(parameterIndex, x);
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "clearParameters");
                }
                this.checkForClosedStatement();
                if (this.parameterMetaData_ != null) {
                    Arrays.fill(this.parameters_, null);
                    Arrays.fill(this.parameterSet_, false);
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "execute");
                }
                boolean b = this.executeX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", b);
                }
                return b;
            }
        }
        catch (SqlException se) {
            this.checkStatementValidity(se);
            throw se.getSQLException();
        }
    }

    boolean executeX() throws SqlException {
        this.flowExecute(3);
        return this.resultSet_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "addBatch");
                }
                this.checkForClosedStatement();
                this.checkThatAllParametersAreSet();
                if (this.parameterTypeList == null) {
                    this.parameterTypeList = new ArrayList();
                }
                if (this.parameterMetaData_ != null) {
                    Object[] inputsClone = new Object[this.parameters_.length];
                    System.arraycopy(this.parameters_, 0, inputsClone, 0, this.parameters_.length);
                    this.batch_.add(inputsClone);
                    this.parameterTypeList.add(this.parameterMetaData_.clientParamtertype_.clone());
                } else {
                    this.batch_.add(null);
                    this.parameterTypeList.add(null);
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException, BatchUpdateException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeBatch");
                }
                int[] updateCounts = null;
                updateCounts = this.executeBatchX(false);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeBatch", updateCounts);
                }
                return updateCounts;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getMetaData");
                }
                ColumnMetaData resultSetMetaData = this.getMetaDataX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getMetaData", resultSetMetaData);
                }
                return resultSetMetaData;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ColumnMetaData getMetaDataX() throws SqlException {
        super.checkForClosedStatement();
        return this.resultSetMetaData_;
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "execute", (Object)sql, autoGeneratedKeys);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "execute(String, int)").getSQLException();
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "execute", (Object)sql, (Object)columnNames);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "execute(String, String[])").getSQLException();
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "execute", (Object)sql, (Object)columnIndexes);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "execute(String, int[])").getSQLException();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", autoGeneratedKeys);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "executeUpdate(String, int)").getSQLException();
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", columnNames);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "executeUpdate(String, String[])").getSQLException();
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", columnIndexes);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "execute(String, int[])").getSQLException();
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setURL", parameterIndex, (Object)x);
        }
        this.jdbc3FeatureNotSupported(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getParameterMetaData");
                }
                ParameterMetaData parameterMetaData = this.getParameterMetaDataX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getParameterMetaData", parameterMetaData);
                }
                return parameterMetaData;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ParameterMetaData getParameterMetaDataX() throws SqlException {
        ParameterMetaData pm = ClientDriver.getFactory().newParameterMetaData(this.getColumnMetaDataX());
        return pm;
    }

    private ColumnMetaData getColumnMetaDataX() throws SqlException {
        this.checkForClosedStatement();
        return this.parameterMetaData_ != null ? this.parameterMetaData_ : ClientDriver.getFactory().newColumnMetaData(this.agent_.logWriter_, 0);
    }

    public void writeExecute(Section section, ColumnMetaData parameterMetaData, Object[] inputs, int numInputColumns, boolean outputExpected, boolean chainedWritesFollowingSetLob) throws SqlException {
        this.materialPreparedStatement_.writeExecute_(section, parameterMetaData, inputs, numInputColumns, outputExpected, chainedWritesFollowingSetLob);
    }

    public void readExecute() throws SqlException {
        this.materialPreparedStatement_.readExecute_();
    }

    private void writeOpenQuery(Section section, int fetchSize, int resultSetType, int numInputColumns, ColumnMetaData parameterMetaData, Object[] inputs) throws SqlException {
        this.materialPreparedStatement_.writeOpenQuery_(section, fetchSize, resultSetType, numInputColumns, parameterMetaData, inputs);
    }

    public void writeDescribeInput(Section section) throws SqlException {
        this.materialPreparedStatement_.writeDescribeInput_(section);
    }

    public void readDescribeInput() throws SqlException {
        this.materialPreparedStatement_.readDescribeInput_();
    }

    public void completeDescribeInput(ColumnMetaData parameterMetaData, Sqlca sqlca) {
        int sqlcode = super.completeSqlca(sqlca);
        if (sqlcode < 0) {
            return;
        }
        this.parameterMetaData_ = parameterMetaData;
        if (this.sqlMode_ != 2 && this.parameterMetaData_ != null) {
            Arrays.fill(this.parameterMetaData_.sqlxParmmode_, (short)1);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceParameterMetaData(this, this.parameterMetaData_);
        }
    }

    public void writeDescribeOutput(Section section) throws SqlException {
        this.materialPreparedStatement_.writeDescribeOutput_(section);
    }

    public void readDescribeOutput() throws SqlException {
        this.materialPreparedStatement_.readDescribeOutput_();
    }

    public void completeDescribeOutput(ColumnMetaData resultSetMetaData, Sqlca sqlca) {
        int sqlcode = super.completeSqlca(sqlca);
        if (sqlcode < 0) {
            return;
        }
        this.resultSetMetaData_ = resultSetMetaData;
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceResultSetMetaData(this, resultSetMetaData);
        }
    }

    void writePrepareDescribeInputOutput() throws SqlException {
        this.writePrepareDescribeOutput(this.sql_, this.section_);
        this.writeDescribeInput(this.section_);
    }

    void readPrepareDescribeInputOutput() throws SqlException {
        this.readPrepareDescribeOutput();
        this.readDescribeInput();
        this.completePrepareDescribe();
    }

    void writePrepareDescribeInput() throws SqlException {
        this.writePrepare(this.sql_, this.section_);
        this.writeDescribeInput(this.section_);
    }

    void readPrepareDescribeInput() throws SqlException {
        this.readPrepare();
        this.readDescribeInput();
        this.completePrepareDescribe();
    }

    void completePrepareDescribe() {
        if (this.parameterMetaData_ == null) {
            return;
        }
        this.parameters_ = this.expandObjectArray(this.parameters_, this.parameterMetaData_.columns_);
        this.parameterSet_ = this.expandBooleanArray(this.parameterSet_, this.parameterMetaData_.columns_);
        this.parameterRegistered_ = this.expandBooleanArray(this.parameterRegistered_, this.parameterMetaData_.columns_);
    }

    private Object[] expandObjectArray(Object[] array, int newLength) {
        if (array == null) {
            Object[] newArray = new Object[newLength];
            return newArray;
        }
        if (array.length < newLength) {
            Object[] newArray = new Object[newLength];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    private boolean[] expandBooleanArray(boolean[] array, int newLength) {
        if (array == null) {
            boolean[] newArray = new boolean[newLength];
            return newArray;
        }
        if (array.length < newLength) {
            boolean[] newArray = new boolean[newLength];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    void writePrepareDescribeInputOutput(String sql, Section section) throws SqlException {
        this.writePrepareDescribeOutput(sql, section);
        this.writeDescribeInput(section);
    }

    void flowPrepareDescribeInputOutput() throws SqlException {
        this.agent_.beginWriteChain(this);
        if (this.sqlMode_ == 2) {
            this.writePrepareDescribeInput();
            this.agent_.flow(this);
            this.readPrepareDescribeInput();
            this.agent_.endReadChain();
        } else {
            this.writePrepareDescribeInputOutput();
            this.agent_.flow(this);
            this.readPrepareDescribeInputOutput();
            this.agent_.endReadChain();
        }
    }

    private void flowExecute(int executeType) throws SqlException {
        boolean outputExpected;
        int numInputColumns;
        this.checkForClosedStatement();
        this.checkAutoGeneratedKeysParameters();
        this.clearWarningsX();
        this.checkForAppropriateSqlMode(executeType, this.sqlMode_);
        this.checkThatAllParametersAreSet();
        this.updateCount_ = this.sqlMode_ == 4 ? 0 : -1;
        if (this.sqlMode_ == 1) {
            this.checkForDuplicateCursorName();
        }
        this.agent_.beginWriteChain(this);
        boolean piggybackedAutocommit = this.writeCloseResultSets(true);
        try {
            numInputColumns = this.parameterMetaData_ != null ? this.parameterMetaData_.getColumnCount() : 0;
            outputExpected = this.resultSetMetaData_ != null && this.resultSetMetaData_.getColumnCount() > 0;
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
        boolean chainAutoCommit = false;
        boolean commitSubstituted = false;
        boolean repositionedCursor = false;
        boolean timeoutSent = false;
        ResultSet scrollableRS = null;
        if (this.doWriteTimeout) {
            this.timeoutArrayList.set(0, "SET STATEMENT_TIMEOUT " + this.timeout_);
            this.writeSetSpecialRegister(this.timeoutArrayList);
            this.doWriteTimeout = false;
            timeoutSent = true;
        }
        switch (this.sqlMode_) {
            case 4: {
                if (this.positionedUpdateCursorName_ != null) {
                    scrollableRS = this.agent_.sectionManager_.getPositionedUpdateResultSet(this.positionedUpdateCursorName_);
                }
                if (scrollableRS != null && !scrollableRS.isRowsetCursor_ && !(repositionedCursor = scrollableRS.repositionScrollableResultSetBeforeJDBC1PositionedUpdateDelete())) {
                    scrollableRS = null;
                }
                chainAutoCommit = this.connection_.willAutoCommitGenerateFlow() && this.isAutoCommittableStatement_;
                boolean chainOpenQueryForAutoGeneratedKeys = this.sqlUpdateMode_ == 32 && this.autoGeneratedKeys_ == 1;
                this.writeExecute(this.section_, this.parameterMetaData_, this.parameters_, numInputColumns, outputExpected, chainAutoCommit || chainOpenQueryForAutoGeneratedKeys);
                if (chainOpenQueryForAutoGeneratedKeys) {
                    this.prepareAutoGeneratedKeysStatement();
                    this.writeOpenQuery(this.preparedStatementForAutoGeneratedKeys_.section_, this.preparedStatementForAutoGeneratedKeys_.fetchSize_, this.preparedStatementForAutoGeneratedKeys_.resultSetType_);
                }
                if (!chainAutoCommit) break;
                if (this.agent_.accumulatedReadExceptions_ != null) {
                    this.connection_.writeCommitSubstitute_();
                    commitSubstituted = true;
                    break;
                }
                this.connection_.writeCommit();
                break;
            }
            case 1: {
                this.writeOpenQuery(this.section_, this.fetchSize_, this.resultSetType_, numInputColumns, this.parameterMetaData_, this.parameters_);
                break;
            }
            case 2: {
                this.writeExecuteCall(this.outputRegistered_, null, this.section_, this.fetchSize_, false, this.resultSetType_, this.parameterMetaData_, this.parameters_);
            }
        }
        this.agent_.flow(this);
        super.readCloseResultSets(true);
        if (piggybackedAutocommit) {
            this.connection_.completeTransactionStart();
        }
        this.markResultSetsClosed(true);
        if (timeoutSent) {
            this.readSetSpecialRegister();
        }
        switch (this.sqlMode_) {
            case 4: {
                if (scrollableRS != null && !scrollableRS.isRowsetCursor_) {
                    scrollableRS.readPositioningFetch_();
                } else {
                    this.readExecute();
                    if (this.sqlUpdateMode_ == 32 && this.autoGeneratedKeys_ == 1) {
                        this.readPrepareAutoGeneratedKeysStatement();
                        this.preparedStatementForAutoGeneratedKeys_.readOpenQuery();
                        this.generatedKeysResultSet_ = this.preparedStatementForAutoGeneratedKeys_.resultSet_;
                        this.preparedStatementForAutoGeneratedKeys_.resultSet_ = null;
                    }
                }
                if (!chainAutoCommit) break;
                if (commitSubstituted) {
                    this.connection_.readCommitSubstitute_();
                    break;
                }
                this.connection_.readCommit();
                break;
            }
            case 1: {
                try {
                    this.readOpenQuery();
                }
                catch (DisconnectException dise) {
                    throw dise;
                }
                catch (SqlException e) {
                    throw e;
                }
                if (this.resultSet_ == null) break;
                this.resultSet_.parseScrollableRowset();
                this.setupCursorNameCacheAndMappings();
                break;
            }
            case 2: {
                this.readExecuteCall();
            }
        }
        this.agent_.endReadChain();
        if (this.sqlMode_ == 2) {
            this.parseStorProcReturnedScrollableRowset();
            this.checkForStoredProcResultSetCount(executeType);
            if (this.connection_.autoCommit_ && this.resultSet_ == null && this.resultSetList_ == null && this.isAutoCommittableStatement_) {
                this.connection_.flowAutoCommit();
            }
        }
        if (executeType == 2 && this.updateCount_ < 0) {
            this.updateCount_ = 0;
        }
        if (this.resultSet_ != null && this.resultSet_.resultSetHoldability_ != this.resultSetHoldability_ && this.sqlMode_ != 2) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ115.S"), new Integer(this.resultSetHoldability_));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatchX(boolean supportsQueryBatchRequest) throws SqlException, SQLException, BatchUpdateException {
        Connection connection = this.connection_;
        synchronized (connection) {
            this.checkForClosedStatement();
            this.clearWarningsX();
            return this.executeBatchRequestX(supportsQueryBatchRequest);
        }
    }

    private int[] executeBatchRequestX(boolean supportsQueryBatchRequest) throws SqlException, BatchUpdateException {
        boolean chainAutoCommit;
        int numInputColumns;
        SqlException chainBreaker = null;
        int batchSize = this.batch_.size();
        int[] updateCounts = new int[batchSize];
        try {
            numInputColumns = this.parameterMetaData_ == null ? 0 : this.parameterMetaData_.getColumnCount();
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
        Object[] savedInputs = null;
        boolean timeoutSent = false;
        if (batchSize == 0) {
            return updateCounts;
        }
        if (batchSize > 65534) {
            throw new BatchUpdateException(this.agent_.logWriter_, new ClientMessageId("XJ116.S"), new Integer(65534), updateCounts);
        }
        for (int i = 0; i < batchSize; ++i) {
            updateCounts[i] = -3;
        }
        if (!supportsQueryBatchRequest && this.sqlMode_ == 1) {
            throw new BatchUpdateException(this.agent_.logWriter_, new ClientMessageId("XJ117.S"), updateCounts);
        }
        if (supportsQueryBatchRequest && this.sqlMode_ != 1) {
            throw new BatchUpdateException(this.agent_.logWriter_, new ClientMessageId("XJ118.S"), updateCounts);
        }
        this.resultSetList_ = null;
        if (this.sqlMode_ == 1) {
            this.indexOfCurrentResultSet_ = -1;
            this.resultSetList_ = new ResultSet[batchSize];
        }
        savedInputs = this.parameters_;
        this.agent_.beginBatchedWriteChain(this);
        boolean bl = chainAutoCommit = this.connection_.willAutoCommitGenerateFlow() && this.isAutoCommittableStatement_;
        if (this.doWriteTimeout) {
            this.timeoutArrayList.set(0, "SET STATEMENT_TIMEOUT " + this.timeout_);
            this.writeSetSpecialRegister(this.timeoutArrayList);
            this.doWriteTimeout = false;
            timeoutSent = true;
        }
        for (int i = 0; i < batchSize; ++i) {
            if (this.parameterMetaData_ != null) {
                this.parameterMetaData_.clientParamtertype_ = (int[])this.parameterTypeList.get(i);
                this.parameters_ = (Object[])this.batch_.get(i);
            }
            if (this.sqlMode_ != 2) {
                boolean outputExpected;
                try {
                    outputExpected = this.resultSetMetaData_ != null && this.resultSetMetaData_.getColumnCount() > 0;
                }
                catch (SQLException se) {
                    throw new SqlException(se);
                }
                this.writeExecute(this.section_, this.parameterMetaData_, this.parameters_, numInputColumns, outputExpected, chainAutoCommit || i != batchSize - 1);
                continue;
            }
            if (this.outputRegistered_) {
                throw new BatchUpdateException(this.agent_.logWriter_, new ClientMessageId("XJ04C.S"), updateCounts);
            }
            this.writeExecuteCall(false, null, this.section_, this.fetchSize_, true, this.resultSetType_, this.parameterMetaData_, this.parameters_);
        }
        boolean commitSubstituted = false;
        if (chainAutoCommit) {
            if (this.agent_.accumulatedReadExceptions_ != null) {
                this.connection_.writeCommitSubstitute_();
                commitSubstituted = true;
            } else {
                this.connection_.writeCommit();
            }
        }
        this.agent_.flowBatch(this, batchSize);
        if (timeoutSent) {
            this.readSetSpecialRegister();
        }
        try {
            for (int i = 0; i < batchSize; ++i) {
                this.agent_.setBatchedExceptionLabelIndex(i);
                this.parameters_ = (Object[])this.batch_.get(i);
                if (this.sqlMode_ != 2) {
                    this.readExecute();
                } else {
                    this.readExecuteCall();
                }
                updateCounts[i] = this.updateCount_;
            }
            this.agent_.disableBatchedExceptionTracking();
            if (chainAutoCommit) {
                if (!commitSubstituted) {
                    this.connection_.readCommit();
                } else {
                    this.connection_.readCommitSubstitute_();
                }
            }
        }
        catch (SqlException e) {
            chainBreaker = e;
            chainBreaker.setNextException(new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ211.S")));
        }
        this.batch_.clear();
        this.parameterTypeList = null;
        this.parameters_ = savedInputs;
        this.agent_.endBatchedReadChain(updateCounts, chainBreaker);
        return updateCounts;
    }

    public void listenToUnitOfWork() {
        if (!this.listenToUnitOfWork_) {
            this.listenToUnitOfWork_ = true;
            this.connection_.CommitAndRollbackListeners_.put(this, null);
        }
    }

    public void completeLocalCommit(Iterator listenerIterator) {
        if (this.section_ != null) {
            this.openOnServer_ = false;
        }
        listenerIterator.remove();
        this.listenToUnitOfWork_ = false;
    }

    public void completeLocalRollback(Iterator listenerIterator) {
        if (this.section_ != null) {
            this.openOnServer_ = false;
        }
        listenerIterator.remove();
        this.listenToUnitOfWork_ = false;
    }

    protected String getJdbcStatementInterfaceName() {
        return "java.sql.PreparedStatement";
    }

    void checkForValidParameterIndex(int parameterIndex) throws SqlException {
        if (this.parameterMetaData_ == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("07009"));
        }
        if (parameterIndex < 1 || parameterIndex > this.parameterMetaData_.columns_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL13.S"), (Object)new Integer(parameterIndex), new Integer(this.parameterMetaData_.columns_));
        }
    }

    private void checkThatAllParametersAreSet() throws SqlException {
        if (this.parameterMetaData_ != null) {
            for (int i = 0; i < this.parameterMetaData_.columns_; ++i) {
                if (this.parameterSet_[i] || this.parameterRegistered_[i]) continue;
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("07000"));
            }
        }
    }

    void checkForValidScale(int scale) throws SqlException {
        if (scale < 0 || scale > 31) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ044.S"), new Integer(scale));
        }
    }

    private void checkForSupportedDataType(int dataType) throws SqlException {
        switch (dataType) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case 70: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2009: 
            case 2011: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.7"), Types.getTypeString(dataType));
            }
        }
    }

    void checkScaleForINOUTDecimal(int parameterIndex, int registerOutScale) throws SqlException {
        BigDecimal decimalInput = (BigDecimal)this.parameters_[parameterIndex - 1];
        if (decimalInput == null) {
            return;
        }
        if (registerOutScale > this.parameterMetaData_.sqlScale_[parameterIndex - 1]) {
            int inputLength = decimalInput.toString().length();
            int scaleDifference = registerOutScale - decimalInput.scale();
            if (decimalInput.signum() == -1) {
                --inputLength;
            }
            if (32 - scaleDifference < inputLength) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ100.S"));
            }
            this.parameters_[parameterIndex - 1] = decimalInput.setScale(registerOutScale);
            this.parameterMetaData_.sqlScale_[parameterIndex - 1] = registerOutScale;
        } else if (registerOutScale < this.parameterMetaData_.sqlScale_[parameterIndex - 1]) {
            try {
                this.parameters_[parameterIndex - 1] = decimalInput.setScale(registerOutScale);
                this.parameterMetaData_.sqlScale_[parameterIndex - 1] = registerOutScale;
            }
            catch (ArithmeticException e) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ100.S"));
            }
        }
    }

    protected void markClosed(boolean removeListener) {
        if (this.pooledConnection_ != null) {
            this.pooledConnection_.onStatementClose(this);
        }
        super.markClosed(removeListener);
        if (this.parameterMetaData_ != null) {
            this.parameterMetaData_.markClosed();
            this.parameterMetaData_ = null;
        }
        this.sql_ = null;
        if (this.parameters_ != null) {
            Arrays.fill(this.parameters_, null);
        }
        this.parameters_ = null;
        if (removeListener) {
            this.connection_.CommitAndRollbackListeners_.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setAsciiStream", parameterIndex, (Object)x);
            }
            try {
                this.checkTypeForSetAsciiStream(parameterIndex);
                this.parameterMetaData_.clientParamtertype_[parameterIndex - 1] = 2005;
                if (x == null) {
                    this.setNull(parameterIndex, -1);
                    return;
                }
                this.setInput(parameterIndex, new Clob(this.agent_, x, "ISO-8859-1"));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setBinaryStream", parameterIndex, (Object)x);
            }
            try {
                this.checkTypeForSetBinaryStream(parameterIndex);
                this.setBinaryStreamX(parameterIndex, x, -1);
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setClob", parameterIndex, (Object)reader);
            }
            try {
                this.checkTypeForSetClob(parameterIndex);
                this.checkForClosedStatement();
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
            this.setInput(parameterIndex, new Clob(this.agent_, reader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setClob", parameterIndex, (Object)reader, (Object)new Long(length));
            }
            try {
                this.checkForClosedStatement();
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
            if (length > Integer.MAX_VALUE) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ093.S"), (Object)new Long(length), new Integer(Integer.MAX_VALUE)).getSQLException();
            }
            this.setInput(parameterIndex, new Clob(this.agent_, reader, (int)length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setBlob", parameterIndex, (Object)inputStream);
            }
            try {
                this.checkTypeForSetBlob(parameterIndex);
                this.setBinaryStreamX(parameterIndex, inputStream, -1);
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setBlob", parameterIndex, (Object)inputStream, (Object)new Long(length));
            }
            if (length > Integer.MAX_VALUE) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ093.S"), (Object)new Long(length), new Integer(Integer.MAX_VALUE)).getSQLException();
            }
            try {
                this.checkTypeForSetBlob(parameterIndex);
                this.setBinaryStreamX(parameterIndex, inputStream, (int)length);
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    private void checkStatementValidity(SqlException sqle) throws SQLException {
        if (this.pooledConnection_ != null && this.isClosed()) {
            this.pooledConnection_.onStatementErrorOccurred(this, sqle.getSQLException());
        }
    }

    private static class PossibleTypes {
        private final int[] possibleTypes;
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR = new PossibleTypes(new int[]{-5, -1, 1, 3, 4, 5, 7, 8, 12});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_DATE = new PossibleTypes(new int[]{-1, 1, 12, 91, 93});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_TIME = new PossibleTypes(new int[]{-1, 1, 12, 92});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_TIMESTAMP = new PossibleTypes(new int[]{-1, 1, 12, 91, 92, 93});
        private static final PossibleTypes POSSIBLE_TYPES_IN_SET_STRING = new PossibleTypes(new int[]{-5, -1, 1, 3, 4, 5, 7, 8, 12, 91, 92, 93, 2005});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_BYTES = new PossibleTypes(new int[]{-4, -3, -2, -1, 1, 12, 2004});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_BINARYSTREAM = new PossibleTypes(new int[]{-4, -3, -2, 2004});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_ASCIISTREAM = new PossibleTypes(new int[]{-1, 1, 12, 2005});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_CHARACTERSTREAM = new PossibleTypes(new int[]{-1, 1, 12, 2005});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_BLOB = new PossibleTypes(new int[]{2004});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_CLOB = new PossibleTypes(new int[]{2005});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL = new PossibleTypes(new int[]{-7, -6, -5, -1, 1, 2, 3, 4, 5, 6, 7, 8, 12});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_GENERIC_CHARACTERS_NULL = new PossibleTypes(new int[]{-7, -6, -5, -1, 1, 2, 3, 4, 5, 6, 7, 8, 12, 91, 92, 93});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_VARBINARY_NULL = new PossibleTypes(new int[]{-3, -2, -4});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_BINARY_NULL = new PossibleTypes(new int[]{-3, -2, -4});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_LONGVARBINARY_NULL = new PossibleTypes(new int[]{-3, -2, -4});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_DATE_NULL = new PossibleTypes(new int[]{-1, 1, 12, 91, 93});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_TIME_NULL = new PossibleTypes(new int[]{-1, 1, 12, 92, 93});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_TIMESTAMP_NULL = new PossibleTypes(new int[]{-1, 1, 12, 91, 93});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_CLOB_NULL = new PossibleTypes(new int[]{-1, 1, 12, 2005});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_BLOB_NULL = new PossibleTypes(new int[]{2004});
        public static final PossibleTypes DEFAULT_POSSIBLE_TYPES_FOR_NULL = new PossibleTypes(new int[]{-7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 12, 16, 70, 91, 92, 93, 1111, 2000, 2001, 2002, 2003, 2004, 2005, 2006});

        private PossibleTypes(int[] types) {
            this.possibleTypes = types;
            Arrays.sort(this.possibleTypes);
        }

        boolean checkType(int type) {
            for (int i = 0; i < this.possibleTypes.length - 1; ++i) {
                SanityManager.ASSERT(this.possibleTypes[i] < this.possibleTypes[i + 1]);
            }
            return Arrays.binarySearch(this.possibleTypes, type) >= 0;
        }

        static SqlException throw22005Exception(LogWriter logWriter, int valType, int paramType) throws SqlException {
            throw new SqlException(logWriter, new ClientMessageId("22005"), new Object[]{Types.getTypeString(valType), Types.getTypeString(paramType)}, (Throwable)null);
        }

        static PossibleTypes getPossibleTypesForNull(int typeOfVariable) {
            switch (typeOfVariable) {
                case 5: {
                    return POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL;
                }
                case 4: {
                    return POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL;
                }
                case -5: {
                    return POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL;
                }
                case 7: {
                    return POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL;
                }
                case 6: {
                    return POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL;
                }
                case 8: {
                    return POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL;
                }
                case 3: {
                    return POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL;
                }
                case 1: {
                    return POSSIBLE_TYPES_FOR_GENERIC_CHARACTERS_NULL;
                }
                case 12: {
                    return POSSIBLE_TYPES_FOR_GENERIC_CHARACTERS_NULL;
                }
                case -1: {
                    return POSSIBLE_TYPES_FOR_GENERIC_CHARACTERS_NULL;
                }
                case -3: {
                    return POSSIBLE_TYPES_FOR_VARBINARY_NULL;
                }
                case -2: {
                    return POSSIBLE_TYPES_FOR_BINARY_NULL;
                }
                case -4: {
                    return POSSIBLE_TYPES_FOR_LONGVARBINARY_NULL;
                }
                case 91: {
                    return POSSIBLE_TYPES_FOR_DATE_NULL;
                }
                case 92: {
                    return POSSIBLE_TYPES_FOR_TIME_NULL;
                }
                case 93: {
                    return POSSIBLE_TYPES_FOR_TIMESTAMP_NULL;
                }
                case 2005: {
                    return POSSIBLE_TYPES_FOR_CLOB_NULL;
                }
                case 2004: {
                    return POSSIBLE_TYPES_FOR_BLOB_NULL;
                }
            }
            return DEFAULT_POSSIBLE_TYPES_FOR_NULL;
        }
    }
}

