/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.util.ArrayList;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.PreparedStatementCallbackInterface;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.ResultSetCallbackInterface;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.StatementCallbackInterface;
import org.apache.derby.client.am.Types;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.FdocaConstants;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetCursor;
import org.apache.derby.client.net.NetPackageReply;
import org.apache.derby.client.net.NetResultSet;
import org.apache.derby.client.net.NetSqlca;
import org.apache.derby.client.net.NetSqldta;
import org.apache.derby.client.net.NetStatement;
import org.apache.derby.client.net.StatementReplyInterface;
import org.apache.derby.jdbc.ClientDriver;
import org.apache.derby.shared.common.i18n.MessageUtil;

public class NetStatementReply
extends NetPackageReply
implements StatementReplyInterface {
    NetStatementReply(NetAgent netAgent, int bufferSize) {
        super(netAgent, bufferSize);
    }

    public void readPrepareDescribeOutput(StatementCallbackInterface statement) throws DisconnectException {
        this.startSameIdChainParse();
        this.parsePRPSQLSTTreply(statement);
        this.endOfSameIdChainData();
    }

    public void readExecuteImmediate(StatementCallbackInterface statement) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseEXCSQLIMMreply(statement);
        this.endOfSameIdChainData();
    }

    public void readOpenQuery(StatementCallbackInterface statement) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseOPNQRYreply(statement);
        this.endOfSameIdChainData();
    }

    public void readExecute(PreparedStatementCallbackInterface preparedStatement) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseEXCSQLSTTreply(preparedStatement);
        this.endOfSameIdChainData();
    }

    public void readPrepare(StatementCallbackInterface statement) throws DisconnectException {
        this.startSameIdChainParse();
        this.parsePRPSQLSTTreply(statement);
        this.endOfSameIdChainData();
    }

    public void readDescribeInput(PreparedStatementCallbackInterface preparedStatement) throws DisconnectException {
        if (this.longBufferForDecryption_ != null) {
            this.buffer_ = this.longBufferForDecryption_;
            this.pos_ = this.longPosForDecryption_;
            this.count_ = this.longCountForDecryption_;
            if (this.longBufferForDecryption_ != null && this.count_ > this.longBufferForDecryption_.length) {
                this.count_ = this.longBufferForDecryption_.length;
            }
            this.dssLength_ = 0;
            this.longBufferForDecryption_ = null;
        }
        this.startSameIdChainParse();
        this.parseDSCSQLSTTreply(preparedStatement, 1);
        this.endOfSameIdChainData();
    }

    public void readDescribeOutput(PreparedStatementCallbackInterface preparedStatement) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseDSCSQLSTTreply(preparedStatement, 0);
        this.endOfSameIdChainData();
    }

    public void readExecuteCall(StatementCallbackInterface statement) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseEXCSQLSTTreply(statement);
        this.endOfSameIdChainData();
    }

    private void parsePRPSQLSTTreply(StatementCallbackInterface statement) throws DisconnectException {
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        if (peekCP == 9233) {
            ColumnMetaData columnMetaData = null;
            NetSqlca netSqlca = null;
            boolean nullSqlca = this.peekForNullSqlcagrp();
            if (nullSqlca && this.peekNumOfColumns() == 0) {
                netSqlca = this.parseSQLDARD(columnMetaData, true);
            } else {
                columnMetaData = ClientDriver.getFactory().newColumnMetaData(this.netAgent_.logWriter_);
                netSqlca = this.parseSQLDARD(columnMetaData, false);
            }
            statement.completePrepareDescribeOutput(columnMetaData, netSqlca);
        } else if (peekCP == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            statement.completePrepare(netSqlca);
        } else {
            this.parsePrepareError(statement);
        }
    }

    private void parseDSCSQLSTTreply(PreparedStatementCallbackInterface ps, int metaDataType) throws DisconnectException {
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        if (peekCP == 9233) {
            ColumnMetaData columnMetaData = null;
            if (columnMetaData == null) {
                columnMetaData = ClientDriver.getFactory().newColumnMetaData(this.netAgent_.logWriter_);
            }
            NetSqlca netSqlca = this.parseSQLDARD(columnMetaData, false);
            if (columnMetaData.columns_ == 0) {
                columnMetaData = null;
            }
            if (metaDataType == 0) {
                ps.completeDescribeOutput(columnMetaData, netSqlca);
            } else {
                ps.completeDescribeInput(columnMetaData, netSqlca);
            }
        } else if (peekCP == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            if (metaDataType == 0) {
                ps.completeDescribeOutput(null, netSqlca);
            } else {
                ps.completeDescribeInput(null, netSqlca);
            }
        } else {
            this.parseDescribeError(ps);
        }
    }

    private void parseEXCSQLIMMreply(StatementCallbackInterface statement) throws DisconnectException {
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        if (peekCP == 8728) {
            this.parseRDBUPDRM();
            peekCP = this.parseTypdefsOrMgrlvlovrs();
        }
        switch (peekCP) {
            case 8716: {
                this.parseENDUOWRM(statement.getConnectionCallbackInterface());
                this.parseTypdefsOrMgrlvlovrs();
            }
            case 9224: {
                NetSqlca netSqlca = this.parseSQLCARD(null);
                statement.completeExecuteImmediate(netSqlca);
                break;
            }
            default: {
                this.parseExecuteImmediateError(statement);
            }
        }
        peekCP = this.peekCodePoint();
        if (peekCP == 49152) {
            this.parsePBSD();
        }
    }

    private void parseOPNQRYreply(StatementCallbackInterface statementI) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        if (peekCP == 8709) {
            this.parseOpenQuery(statementI);
            peekCP = this.peekCodePoint();
            if (peekCP == 8728) {
                this.parseRDBUPDRM();
                peekCP = this.peekCodePoint();
            }
        } else if (peekCP == 8728) {
            this.parseRDBUPDRM();
            this.parseOpenQuery(statementI);
            peekCP = this.peekCodePoint();
        } else if (peekCP == 8722) {
            this.parseOpenQueryFailure(statementI);
            peekCP = this.peekCodePoint();
        } else {
            this.parseOpenQueryError(statementI);
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 49152) {
            this.parsePBSD();
        }
    }

    private void parseEXCSQLSETreply(StatementCallbackInterface statement) throws DisconnectException {
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        if (peekCP == 8728) {
            this.parseRDBUPDRM();
            this.parseTypdefsOrMgrlvlovrs();
        } else if (peekCP == 8716) {
            this.parseENDUOWRM(statement.getConnectionCallbackInterface());
            this.parseTypdefsOrMgrlvlovrs();
        }
        if (peekCP == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            statement.completeExecuteSetStatement(netSqlca);
        } else {
            this.parseExecuteSetStatementError(statement);
        }
    }

    private void parseEXCSQLSTTreply(StatementCallbackInterface statementI) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        if (peekCP == 8728) {
            this.parseRDBUPDRM();
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 8716) {
            this.parseENDUOWRM(statementI.getConnectionCallbackInterface());
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 8729) {
            this.parseResultSetProcedure(statementI);
            peekCP = this.peekCodePoint();
            if (peekCP == 8728) {
                this.parseRDBUPDRM();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 49152) {
                this.parsePBSD();
            }
            return;
        }
        peekCP = this.parseTypdefsOrMgrlvlovrs();
        if (peekCP == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            statementI.completeExecute(netSqlca);
            peekCP = this.peekCodePoint();
        } else if (peekCP == 9235) {
            NetSqldta netSqldta = null;
            boolean useCachedSingletonRowData = false;
            if (((Statement)statementI).cachedSingletonRowData_ == null) {
                netSqldta = new NetSqldta(this.netAgent_);
            } else {
                netSqldta = (NetSqldta)((Statement)statementI).cachedSingletonRowData_;
                netSqldta.resetDataBuffer();
                netSqldta.extdtaData_.clear();
                useCachedSingletonRowData = true;
            }
            NetSqlca netSqlca = this.parseSQLDTARD(netSqldta);
            peekCP = this.peekCodePoint();
            while (peekCP == 5228) {
                this.copyEXTDTA(netSqldta);
                peekCP = this.peekCodePoint();
            }
            statementI.completeExecuteCall(netSqlca, netSqldta);
        } else {
            this.parseExecuteError(statementI);
        }
        if (peekCP == 49152) {
            this.parsePBSD();
            peekCP = this.peekCodePoint();
        }
    }

    protected void parseResultSetProcedure(StatementCallbackInterface statementI) throws DisconnectException {
        ArrayList sectionAL = this.parseRSLSETRM();
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        NetSqldta netSqldta = null;
        NetSqlca netSqlca = null;
        if (peekCP == 9224) {
            netSqlca = this.parseSQLCARD(null);
        } else {
            netSqldta = new NetSqldta(this.netAgent_);
            netSqlca = this.parseSQLDTARD(netSqldta);
        }
        peekCP = this.parseTypdefsOrMgrlvlovrs();
        int numberOfResultSets = this.parseSQLRSLRD(sectionAL);
        ResultSet[] resultSets = new NetResultSet[numberOfResultSets];
        for (int i = 0; i < numberOfResultSets; ++i) {
            NetResultSet netResultSet = this.parseResultSetCursor(statementI, (Section)sectionAL.get(i));
            resultSets[i] = netResultSet;
        }
        peekCP = this.peekCodePoint();
        while (peekCP == 5228) {
            this.copyEXTDTA(netSqldta);
            peekCP = this.peekCodePoint();
        }
        statementI.completeExecuteCall(netSqlca, netSqldta, resultSets);
    }

    protected NetResultSet parseResultSetCursor(StatementCallbackInterface statementI, Section section) throws DisconnectException {
        NetResultSet netResultSet = this.parseOPNQRYRM(statementI, false);
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = null;
        if (peekCP == 9224) {
            netSqlca = this.parseSQLCARD(null);
            peekCP = this.parseTypdefsOrMgrlvlovrs();
        }
        ColumnMetaData resultSetMetaData = null;
        if (peekCP == 9227) {
            resultSetMetaData = this.parseSQLCINRD();
            peekCP = this.parseTypdefsOrMgrlvlovrs();
        }
        this.parseQRYDSC(netResultSet.netCursor_);
        peekCP = this.peekCodePoint();
        statementI.completeExecuteCallOpenQuery(netSqlca, netResultSet, resultSetMetaData, section);
        while (peekCP == 9243) {
            this.parseQRYDTA(netResultSet);
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 8715) {
            this.parseEndQuery(netResultSet);
        }
        return netResultSet;
    }

    protected void parseOpenQuery(StatementCallbackInterface statementI) throws DisconnectException {
        NetResultSet netResultSet = this.parseOPNQRYRM(statementI, true);
        NetSqlca sqlca = null;
        int peekCP = this.peekCodePoint();
        if (peekCP != 9242) {
            peekCP = this.parseTypdefsOrMgrlvlovrs();
            if (peekCP == 9233) {
                ColumnMetaData columnMetaData = ClientDriver.getFactory().newColumnMetaData(this.netAgent_.logWriter_);
                NetSqlca netSqlca = this.parseSQLDARD(columnMetaData, false);
                statementI.completePrepareDescribeOutput(columnMetaData, netSqlca);
                peekCP = this.parseTypdefsOrMgrlvlovrs();
            }
            if (peekCP == 9224) {
                sqlca = this.parseSQLCARD(null);
                peekCP = this.parseTypdefsOrMgrlvlovrs();
            }
        }
        this.parseQRYDSC(netResultSet.netCursor_);
        peekCP = this.peekCodePoint();
        while (peekCP == 9243) {
            this.parseQRYDTA(netResultSet);
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            statementI.completeSqlca(netSqlca);
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 8715) {
            this.parseEndQuery(netResultSet);
        }
        statementI.completeOpenQuery(sqlca, netResultSet);
    }

    protected void parseEndQuery(ResultSetCallbackInterface resultSetI) throws DisconnectException {
        this.parseENDQRYRM(resultSetI);
        this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = this.parseSQLCARD(null);
        resultSetI.earlyCloseComplete(netSqlca);
    }

    void parseOpenQueryFailure(StatementCallbackInterface statementI) throws DisconnectException {
        this.parseOPNQFLRM(statementI);
        this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = this.parseSQLCARD(null);
        statementI.completeOpenQuery(netSqlca, null);
    }

    void parsePrepareError(StatementCallbackInterface statement) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                NetSqlca sqlca = this.parseAbnormalEndUow(statement);
                statement.completeSqlca(sqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca sqlca = this.parseSqlErrorCondition();
                statement.completeSqlca(sqlca);
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    void parseExecuteImmediateError(StatementCallbackInterface statement) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                NetSqlca sqlca = this.parseAbnormalEndUow(statement);
                statement.completeSqlca(sqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca sqlca = this.parseSqlErrorCondition();
                statement.completeSqlca(sqlca);
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    void parseDescribeError(StatementCallbackInterface statement) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                NetSqlca sqlca = this.parseAbnormalEndUow(statement);
                statement.completeSqlca(sqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca sqlca = this.parseSqlErrorCondition();
                statement.completeSqlca(sqlca);
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    void parseOpenQueryError(StatementCallbackInterface statementI) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                NetSqlca sqlca = this.parseAbnormalEndUow(statementI);
                statementI.completeSqlca(sqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8719: {
                this.parseQRYPOPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    void parseExecuteError(StatementCallbackInterface statementI) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                NetSqlca sqlca = this.parseAbnormalEndUow(statementI);
                statementI.completeSqlca(sqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca sqlca = this.parseSqlErrorCondition();
                statementI.completeSqlca(sqlca);
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    void parseExecuteSetStatementError(StatementCallbackInterface statement) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                NetSqlca sqlca = this.parseAbnormalEndUow(statement);
                statement.completeSqlca(sqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca sqlca = this.parseSqlErrorCondition();
                statement.completeSqlca(sqlca);
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    protected NetResultSet parseOPNQRYRM(StatementCallbackInterface statementI, boolean isOPNQRYreply) throws DisconnectException {
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean svrcodReceived = false;
        int qryprctyp = 0;
        boolean qryprctypReceived = false;
        int sqlcsrhld = 240;
        boolean sqlcsrhldReceived = false;
        int qryattscr = 240;
        boolean qryattscrReceived = false;
        int qryattsns = 0;
        boolean qryattsnsReceived = false;
        int qryattupd = 0;
        boolean qryattupdReceived = false;
        long qryinsid = 0L;
        boolean qryinsidReceived = false;
        int qryattset = 240;
        boolean qryattsetReceived = false;
        this.parseLengthAndMatchCodePoint(8709);
        int ddmLength = this.getDdmLength();
        this.ensureBLayerDataInBuffer(ddmLength);
        int peekCP = this.peekCodePoint();
        int length = 0;
        while (ddmLength > 0) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                length = this.peekedLength_;
                svrcod = this.parseFastSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_SESDMG);
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8450) {
                foundInPass = true;
                qryprctypReceived = this.checkAndGetReceivedFlag(qryprctypReceived);
                length = this.peekedLength_;
                qryprctyp = this.parseFastQRYPRCTYP();
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8479) {
                foundInPass = true;
                sqlcsrhldReceived = this.checkAndGetReceivedFlag(sqlcsrhldReceived);
                length = this.peekedLength_;
                sqlcsrhld = this.parseFastSQLCSRHLD();
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8521) {
                foundInPass = true;
                qryattscrReceived = this.checkAndGetReceivedFlag(qryattscrReceived);
                length = this.peekedLength_;
                qryattscr = this.parseFastQRYATTSCR();
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8535) {
                foundInPass = true;
                qryattsnsReceived = this.checkAndGetReceivedFlag(qryattsnsReceived);
                length = this.peekedLength_;
                qryattsns = this.parseFastQRYATTSNS();
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8528) {
                foundInPass = true;
                qryattupdReceived = this.checkAndGetReceivedFlag(qryattupdReceived);
                length = this.peekedLength_;
                qryattupd = this.parseFastQRYATTUPD();
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8539) {
                foundInPass = true;
                qryinsidReceived = this.checkAndGetReceivedFlag(qryinsidReceived);
                length = this.peekedLength_;
                qryinsid = this.parseFastQRYINSID();
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8522) {
                foundInPass = true;
                qryattsetReceived = this.checkAndGetReceivedFlag(qryattsetReceived);
                length = this.peekedLength_;
                qryattset = this.parseFastQRYATTSET();
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.checkRequiredObjects(svrcodReceived, qryprctypReceived, qryinsidReceived);
        this.netAgent_.setSvrcod(svrcod);
        Statement statement = (Statement)statementI;
        NetResultSet rs = null;
        if (statement.cachedCursor_ != null) {
            statement.cachedCursor_.resetDataBuffer();
            ((NetCursor)statement.cachedCursor_).extdtaData_.clear();
            try {
                rs = (NetResultSet)ClientDriver.getFactory().newNetResultSet(this.netAgent_, (NetStatement)statement.materialStatement_, statement.cachedCursor_, qryprctyp, sqlcsrhld, qryattscr, qryattsns, qryattset, qryinsid, this.calculateResultSetType(qryattscr, qryattsns, statement.resultSetType_), this.calculateResultSetConcurrency(qryattupd, statement.resultSetConcurrency_), this.calculateResultSetHoldability(sqlcsrhld));
            }
            catch (SqlException sqle) {
                throw new DisconnectException((Agent)this.netAgent_, sqle);
            }
        }
        try {
            rs = (NetResultSet)ClientDriver.getFactory().newNetResultSet(this.netAgent_, (NetStatement)statement.materialStatement_, new NetCursor(this.netAgent_, qryprctyp), qryprctyp, sqlcsrhld, qryattscr, qryattsns, qryattset, qryinsid, this.calculateResultSetType(qryattscr, qryattsns, statement.resultSetType_), this.calculateResultSetConcurrency(qryattupd, statement.resultSetConcurrency_), this.calculateResultSetHoldability(sqlcsrhld));
        }
        catch (SqlException sqle) {
            throw new DisconnectException((Agent)this.netAgent_, sqle);
        }
        boolean qryclsimp = isOPNQRYreply && rs.resultSetType_ == 1003 && this.netAgent_.netConnection_.serverSupportsQryclsimp();
        rs.netCursor_.setQryclsimpEnabled(qryclsimp);
        return rs;
    }

    protected void parseENDQRYRM(ResultSetCallbackInterface resultSetI) throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8715);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived);
        this.netAgent_.setSvrcod(svrcod);
    }

    private void parseQRYPOPRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        boolean pkgnamcsnReceived = false;
        Object pkgnamcsn = null;
        this.parseLengthAndMatchCodePoint(8719);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8467) {
                foundInPass = true;
                pkgnamcsnReceived = this.checkAndGetReceivedFlag(pkgnamcsnReceived);
                pkgnamcsn = this.parsePKGNAMCSN(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, rdbnamReceived, pkgnamcsnReceived);
        this.netAgent_.setSvrcod(svrcod);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)MessageUtil.getCompleteMessage("J129", SqlException.CLIENT_MESSAGE_RESOURCE_NAME, null)));
    }

    private void parseOPNQFLRM(StatementCallbackInterface statement) throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8722);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, rdbnamReceived);
        this.netAgent_.setSvrcod(svrcod);
    }

    protected ArrayList parseRSLSETRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean pkgsnlstReceived = false;
        ArrayList pkgsnlst = null;
        this.parseLengthAndMatchCodePoint(8729);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_INFO);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8505) {
                foundInPass = true;
                pkgsnlstReceived = this.checkAndGetReceivedFlag(pkgsnlstReceived);
                pkgsnlst = this.parsePKGSNLST();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, pkgsnlstReceived);
        this.netAgent_.setSvrcod(svrcod);
        return pkgsnlst;
    }

    protected NetSqlca parseSQLDTARD(NetSqldta netSqldta) throws DisconnectException {
        boolean fdodscReceived = false;
        boolean fdodtaReceived = false;
        this.parseLengthAndMatchCodePoint(9235);
        this.pushLengthOnCollectionStack();
        NetSqlca netSqlca = null;
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 16) {
                foundInPass = true;
                fdodscReceived = this.checkAndGetReceivedFlag(fdodscReceived);
                this.parseFDODSC(netSqldta);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 5242) {
                foundInPass = true;
                fdodtaReceived = this.checkAndGetReceivedFlag(fdodtaReceived);
                netSqlca = this.parseFDODTA(netSqldta);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(fdodscReceived, fdodtaReceived);
        netSqldta.calculateColumnOffsetsForRow();
        return netSqlca;
    }

    protected void parseQRYDSC(NetCursor cursor) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9242);
        this.parseSQLDTARDarray(cursor, false);
    }

    private void parseFDODSC(NetCursor cursor) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(16);
        this.parseSQLDTARDarray(cursor, false);
    }

    private void parseSQLDTARDarray(NetCursor cursor, boolean skipBytes) throws DisconnectException {
        int tripletLength;
        int ddmLength;
        if (skipBytes) {
            this.skipBytes();
        }
        int previousTripletType = 0;
        int previousTripletId = 0;
        int mddProtocolType = 0;
        int columnCount = 0;
        this.netAgent_.targetTypdef_.clearMddOverrides();
        this.ensureBLayerDataInBuffer(ddmLength);
        block11: for (ddmLength = this.getDdmLength(); ddmLength > 0; ddmLength -= tripletLength) {
            tripletLength = this.readFastUnsignedByte();
            int tripletType = this.readFastUnsignedByte();
            int tripletId = this.readFastUnsignedByte();
            switch (tripletType) {
                case 120: {
                    if (tripletLength != 7 || tripletId != 0) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(previousTripletType, 2, previousTripletId, 3);
                    previousTripletType = 2;
                    previousTripletId = 3;
                    int mddClass = this.readFastUnsignedByte();
                    int mddType = this.readFastUnsignedByte();
                    int mddRefType = this.readFastUnsignedByte();
                    mddProtocolType = this.readFastUnsignedByte();
                    continue block11;
                }
                case 118: {
                    if (tripletId != 208) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(previousTripletType, 5, previousTripletId, 4);
                    previousTripletType = 5;
                    previousTripletId = 3;
                    int columns = this.peekTotalColumnCount(tripletLength);
                    cursor.initializeColumnInfoArrays(this.netAgent_.targetTypdef_, columns, this.netAgent_.targetSqlam_);
                    columnCount += this.parseSQLDTAGRPdataLabelsAndUpdateColumn(cursor, columnCount, tripletLength);
                    continue block11;
                }
                case 113: {
                    switch (tripletId) {
                        case 224: {
                            if (tripletLength != 9) {
                                this.descriptorErrorDetected();
                            }
                            this.checkPreviousSQLDTARDtriplet(previousTripletType, 4, previousTripletId, 5);
                            previousTripletType = 4;
                            previousTripletId = 5;
                            this.checkFastRLO(FdocaConstants.RLO_SQLCADTA);
                            continue block11;
                        }
                        case 240: {
                            if (tripletLength != 6) {
                                this.descriptorErrorDetected();
                            }
                            this.checkPreviousSQLDTARDtriplet(previousTripletType, 4, previousTripletId, 6);
                            previousTripletType = 4;
                            previousTripletId = 6;
                            this.checkFastRLO(FdocaConstants.RLO_SQLDTARD);
                            continue block11;
                        }
                    }
                    this.descriptorErrorDetected();
                    continue block11;
                }
                case 127: {
                    if (tripletId != 0) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(previousTripletType, 6, previousTripletId, 3);
                    previousTripletType = 6;
                    previousTripletId = 3;
                    columnCount += this.parseSQLDTAGRPdataLabelsAndUpdateColumn(cursor, columnCount, tripletLength);
                    continue block11;
                }
                case 112: {
                    if (tripletLength != 12) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(previousTripletType, 3, previousTripletId, 2);
                    previousTripletType = 3;
                    previousTripletId = 2;
                    this.netAgent_.targetTypdef_.setMddOverride(mddProtocolType, tripletId, this.readFastUnsignedByte(), this.readFastInt(), this.readFastUnsignedByte(), this.readFastUnsignedByte(), this.readFastShort());
                    continue block11;
                }
                default: {
                    this.descriptorErrorDetected();
                }
            }
        }
        this.adjustLengths(this.getDdmLength());
        cursor.allocateCharBuffer();
        this.checkPreviousSQLDTARDtriplet(previousTripletType, 1, previousTripletId, 1);
    }

    private void checkPreviousSQLDTARDtriplet(int previousTripletType, int tripletType, int previousTripletId, int tripletId) throws DisconnectException {
        if (!FdocaConstants.SQLDTARD_TRIPLET_TYPES[previousTripletType][tripletType]) {
            this.descriptorErrorDetected();
        }
        if (!FdocaConstants.SQLDTARD_TRIPLET_IDS[previousTripletId][tripletId]) {
            this.descriptorErrorDetected();
        }
    }

    private void checkFastRLO(int[][] rlo) throws DisconnectException {
        for (int i = 0; i < rlo.length; ++i) {
            int repFactor;
            int elementTaken;
            int lid = this.readFastUnsignedByte();
            if (lid != rlo[i][0]) {
                this.descriptorErrorDetected();
            }
            if ((elementTaken = this.readFastUnsignedByte()) != rlo[i][1]) {
                this.descriptorErrorDetected();
            }
            if ((repFactor = this.readFastUnsignedByte()) == rlo[i][2]) continue;
            this.descriptorErrorDetected();
        }
    }

    private void descriptorErrorDetected() throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)MessageUtil.getCompleteMessage("J130", SqlException.CLIENT_MESSAGE_RESOURCE_NAME, null)));
    }

    protected void parseQRYDTA(NetResultSet netResultSet) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9243);
        if (this.longValueForDecryption_ == null) {
            int ddmLength = this.getDdmLength();
            this.ensureBLayerDataInBuffer(ddmLength);
        }
        this.parseSQLDTARDdata(netResultSet.netCursor_);
        if (this.longValueForDecryption_ == null) {
            this.adjustLengths(this.getDdmLength());
        } else {
            this.longValueForDecryption_ = null;
        }
        if (this.longBufferForDecryption_ != null) {
            this.buffer_ = this.longBufferForDecryption_;
            this.pos_ = this.longPosForDecryption_;
            if (this.count_ > this.longBufferForDecryption_.length) {
                this.count_ = this.longBufferForDecryption_.length;
            } else if (this.longCountForDecryption_ != 0) {
                this.count_ = this.longCountForDecryption_;
                this.longCountForDecryption_ = 0;
            }
            this.dssLength_ = 0;
            this.longBufferForDecryption_ = null;
        }
    }

    NetSqlca parseFDODTA(NetCursor netCursor) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(5242);
        int ddmLength = this.getDdmLength();
        this.ensureBLayerDataInBuffer(ddmLength);
        this.mark();
        NetSqlca netSqlca = this.parseSQLCARDrow(null);
        int length = this.getFastSkipSQLCARDrowLength();
        this.adjustLengths(length);
        this.parseFastSQLDTARDdata(netCursor);
        return netSqlca;
    }

    void parseFastSQLDTARDdata(NetCursor netCursor) throws DisconnectException {
        netCursor.dataBufferStream_ = this.getFastData(netCursor.dataBufferStream_);
        netCursor.dataBuffer_ = netCursor.dataBufferStream_.toByteArray();
        netCursor.lastValidBytePosition_ = netCursor.dataBuffer_.length;
    }

    void parseSQLDTARDdata(NetCursor netCursor) throws DisconnectException {
        if (this.longValueForDecryption_ == null) {
            netCursor.dataBufferStream_ = this.getData(netCursor.dataBufferStream_);
            netCursor.dataBuffer_ = netCursor.dataBufferStream_.toByteArray();
        } else {
            int size = netCursor.dataBufferStream_.size();
            if (size == 0) {
                netCursor.dataBuffer_ = this.longValueForDecryption_;
            } else {
                byte[] newArray = new byte[size + this.longValueForDecryption_.length];
                System.arraycopy(netCursor.dataBuffer_, 0, newArray, 0, size);
                System.arraycopy(this.longValueForDecryption_, 0, newArray, size, this.longValueForDecryption_.length);
                netCursor.dataBuffer_ = newArray;
            }
        }
        netCursor.lastValidBytePosition_ = netCursor.dataBuffer_.length;
    }

    protected void copyEXTDTA(NetCursor netCursor) throws DisconnectException {
        try {
            this.parseLengthAndMatchCodePoint(5228);
            byte[] data = null;
            if (this.longValueForDecryption_ == null) {
                data = this.getData(null).toByteArray();
            } else {
                data = this.longValueForDecryption_;
                this.dssLength_ = 0;
                this.longValueForDecryption_ = null;
            }
            netCursor.extdtaData_.add(data);
        }
        catch (OutOfMemoryError e) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C.6"), null, (Throwable)e));
        }
    }

    protected Object parsePKGNAMCSN(boolean skip) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8467);
        if (skip) {
            this.skipBytes();
            return null;
        }
        String rdbnam = null;
        String rdbcolid = null;
        String pkgid = null;
        byte[] pkgcnstkn = null;
        int pkgsn = 0;
        byte[] pkgnamcsnBytes = null;
        int pkgnamcsnLength = 0;
        int ddmLength = this.getDdmLength();
        int offset = 0;
        this.ensureBLayerDataInBuffer(ddmLength);
        if (ddmLength == 64) {
            pkgnamcsnLength = ddmLength - 2;
            pkgnamcsnBytes = new byte[pkgnamcsnLength];
            offset = this.peekFastBytes(pkgnamcsnBytes, offset, pkgnamcsnLength);
            rdbnam = this.readFastString(18);
            rdbcolid = this.readFastString(18);
            pkgid = this.readFastString(18);
            pkgcnstkn = this.readFastBytes(8);
        } else if (ddmLength >= 71 && ddmLength <= 781) {
            pkgnamcsnBytes = new byte[ddmLength - 2];
            int scldtaLen = this.peekFastLength();
            if (scldtaLen < 18 || scldtaLen > 255) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.21"), (Object)new Integer(scldtaLen)));
                return null;
            }
            offset = this.peekFastBytes(pkgnamcsnBytes, offset, 2 + scldtaLen);
            this.skipFastBytes(2);
            rdbnam = this.readFastString(scldtaLen);
            scldtaLen = this.peekFastLength();
            if (scldtaLen < 18 || scldtaLen > 255) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.7"), (Object)new Integer(scldtaLen)));
                return null;
            }
            offset = this.peekFastBytes(pkgnamcsnBytes, offset, 2 + scldtaLen);
            this.skipFastBytes(2);
            rdbcolid = this.readFastString(scldtaLen);
            scldtaLen = this.peekFastLength();
            if (scldtaLen < 18 || scldtaLen > 255) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.8"), (Object)new Integer(scldtaLen)));
                return null;
            }
            offset = this.peekFastBytes(pkgnamcsnBytes, offset, 2 + scldtaLen);
            this.skipFastBytes(2);
            pkgid = this.readFastString(scldtaLen);
            offset = this.peekFastBytes(pkgnamcsnBytes, offset, 8);
            pkgcnstkn = this.readFastBytes(8);
        } else {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.9"), (Object)new Integer(ddmLength), (Object)new Integer(this.netAgent_.targetSqlam_)));
            return null;
        }
        pkgsn = this.readFastUnsignedShort();
        this.adjustLengths(ddmLength);
        Section section = new Section(this.agent_, pkgid, pkgsn, null, -1, true);
        section.setPKGNAMCBytes(pkgnamcsnBytes);
        return section;
    }

    protected int parseQRYPRCTYP() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8450);
        int qryprctyp = this.parseCODPNTDR();
        if (qryprctyp != 9240 && qryprctyp != 9239) {
            this.doValnsprmSemantics(8450, qryprctyp);
        }
        return qryprctyp;
    }

    protected int parseFastQRYPRCTYP() throws DisconnectException {
        this.matchCodePoint(8450);
        int qryprctyp = this.readFastUnsignedShort();
        if (qryprctyp != 9240 && qryprctyp != 9239) {
            this.doValnsprmSemantics(8450, qryprctyp);
        }
        return qryprctyp;
    }

    protected int parseSQLCSRHLD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8479);
        int sqlcsrhld = this.readUnsignedByte();
        if (sqlcsrhld != 240 && sqlcsrhld != 241) {
            this.doValnsprmSemantics(8479, sqlcsrhld);
        }
        return sqlcsrhld;
    }

    protected int parseFastSQLCSRHLD() throws DisconnectException {
        this.matchCodePoint(8479);
        int sqlcsrhld = this.readFastUnsignedByte();
        if (sqlcsrhld != 240 && sqlcsrhld != 241) {
            this.doValnsprmSemantics(8479, sqlcsrhld);
        }
        return sqlcsrhld;
    }

    protected int parseQRYATTSCR() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8521);
        int qryattscr = this.readUnsignedByte();
        if (qryattscr != 240 && qryattscr != 241) {
            this.doValnsprmSemantics(8521, qryattscr);
        }
        return qryattscr;
    }

    protected int parseFastQRYATTSCR() throws DisconnectException {
        this.matchCodePoint(8521);
        int qryattscr = this.readFastUnsignedByte();
        if (qryattscr != 240 && qryattscr != 241) {
            this.doValnsprmSemantics(8521, qryattscr);
        }
        return qryattscr;
    }

    protected int parseQRYATTSET() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8522);
        int qryattset = this.readUnsignedByte();
        if (qryattset != 240 && qryattset != 241) {
            this.doValnsprmSemantics(8522, qryattset);
        }
        return qryattset;
    }

    protected int parseFastQRYATTSET() throws DisconnectException {
        this.matchCodePoint(8522);
        int qryattset = this.readFastUnsignedByte();
        if (qryattset != 240 && qryattset != 241) {
            this.doValnsprmSemantics(8522, qryattset);
        }
        return qryattset;
    }

    protected int parseQRYATTSNS() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8535);
        int qryattsns = this.readUnsignedByte();
        switch (qryattsns) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                this.doValnsprmSemantics(8535, qryattsns);
            }
        }
        return qryattsns;
    }

    protected int parseFastQRYATTSNS() throws DisconnectException {
        this.matchCodePoint(8535);
        int qryattsns = this.readFastUnsignedByte();
        switch (qryattsns) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                this.doValnsprmSemantics(8535, qryattsns);
            }
        }
        return qryattsns;
    }

    protected int parseQRYATTUPD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8528);
        int qryattupd = this.readUnsignedByte();
        switch (qryattupd) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            default: {
                this.doValnsprmSemantics(8528, qryattupd);
            }
        }
        return qryattupd;
    }

    protected int parseFastQRYATTUPD() throws DisconnectException {
        this.matchCodePoint(8528);
        int qryattupd = this.readFastUnsignedByte();
        switch (qryattupd) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            default: {
                this.doValnsprmSemantics(8528, qryattupd);
            }
        }
        return qryattupd;
    }

    private long parseFastQRYINSID() throws DisconnectException {
        this.matchCodePoint(8539);
        return this.readFastLong();
    }

    protected ArrayList parsePKGSNLST() throws DisconnectException {
        Object pkgnamcsn = null;
        ArrayList<Object> pkgsnlst = new ArrayList<Object>();
        this.parseLengthAndMatchCodePoint(8505);
        this.pushLengthOnCollectionStack();
        while (this.peekCodePoint() != -1) {
            pkgnamcsn = this.parsePKGNAMCSN(false);
            pkgsnlst.add(pkgnamcsn);
        }
        this.popCollectionStack();
        return pkgsnlst;
    }

    protected NetSqlca parseSQLDARD(ColumnMetaData columnMetaData, boolean skipBytes) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9233);
        return this.parseSQLDARDarray(columnMetaData, skipBytes);
    }

    protected int parseSQLRSLRD(ArrayList sectionAL) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9230);
        return this.parseSQLRSLRDarray(sectionAL);
    }

    protected ColumnMetaData parseSQLCINRD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9227);
        int ddmLength = this.getDdmLength();
        this.ensureBLayerDataInBuffer(ddmLength);
        ColumnMetaData cm = this.parseSQLCINRDarray();
        this.adjustLengths(this.getDdmLength());
        return cm;
    }

    NetSqlca parseSQLDARDarray(ColumnMetaData columnMetaData, boolean skipBytes) throws DisconnectException {
        int ddmLength = 0;
        if (!this.ensuredLengthForDecryption_ && this.longValueForDecryption_ == null) {
            ddmLength = this.getDdmLength();
            this.ensureBLayerDataInBuffer(ddmLength);
        }
        if (this.longValueForDecryption_ != null) {
            this.buffer_ = this.longValueForDecryption_;
            this.pos_ = 0;
            this.count_ = this.longValueForDecryption_.length;
        }
        NetSqlca netSqlca = null;
        if (skipBytes) {
            this.mark();
            netSqlca = this.parseSQLCARDrow(null);
            this.skipFastBytes(ddmLength - this.getFastSkipSQLCARDrowLength());
            this.adjustLengths(this.getDdmLength());
            return netSqlca;
        }
        netSqlca = this.parseSQLCARDrow(null);
        this.parseSQLDHROW(columnMetaData);
        int columns = this.parseSQLNUMROW();
        if (columns > columnMetaData.columns_) {
            columnMetaData.initializeCache(columns);
        } else {
            columnMetaData.columns_ = columns;
        }
        for (int i = 0; i < columnMetaData.columns_; ++i) {
            this.parseSQLDAROW(columnMetaData, i);
        }
        if (this.longValueForDecryption_ == null) {
            this.adjustLengths(this.getDdmLength());
        } else {
            this.dssLength_ = 0;
            this.longValueForDecryption_ = null;
        }
        return netSqlca;
    }

    int parseSQLRSLRDarray(ArrayList sectionAL) throws DisconnectException {
        int numOfResultSets = this.parseSQLNUMROW();
        for (int i = 0; i < numOfResultSets; ++i) {
            this.parseSQLRSROW((Section)sectionAL.get(i));
        }
        return numOfResultSets;
    }

    ColumnMetaData parseSQLCINRDarray() throws DisconnectException {
        ColumnMetaData columnMetaData = ClientDriver.getFactory().newColumnMetaData(this.netAgent_.logWriter_);
        this.parseSQLDHROW(columnMetaData);
        columnMetaData.initializeCache(this.parseFastSQLNUMROW());
        for (int i = 0; i < columnMetaData.columns_; ++i) {
            this.parseSQLDAROW(columnMetaData, i);
        }
        return columnMetaData;
    }

    private void parseSQLDAROW(ColumnMetaData columnMetaData, int columnNumber) throws DisconnectException {
        this.parseSQLDAGRP(columnMetaData, columnNumber);
    }

    private void parseSQLDHROW(ColumnMetaData columnMetaData) throws DisconnectException {
        this.parseSQLDHGRP(columnMetaData);
    }

    private void parseSQLRSROW(Section section) throws DisconnectException {
        this.parseSQLRSGRP(section);
    }

    private void parseSQLDAGRP(ColumnMetaData columnMetaData, int columnNumber) throws DisconnectException {
        long columnLength = 0L;
        short precision = this.readFastShort();
        short scale = this.readFastShort();
        columnLength = this.readFastLong();
        short sqlType = this.readFastShort();
        int ccsid = this.readFastUnsignedShort();
        columnMetaData.sqlPrecision_[columnNumber] = precision;
        columnMetaData.sqlScale_[columnNumber] = scale;
        columnMetaData.sqlLength_[columnNumber] = columnLength;
        columnMetaData.sqlType_[columnNumber] = sqlType;
        columnMetaData.nullable_[columnNumber] = Utils.isSqlTypeNullable(sqlType);
        columnMetaData.sqlCcsid_[columnNumber] = ccsid;
        columnMetaData.types_[columnNumber] = Types.mapDERBYTypeToDriverType(true, sqlType, columnLength, ccsid);
        this.parseSQLDOPTGRP(columnMetaData, columnNumber);
    }

    private void parseSQLUDTGRP(ColumnMetaData columnMetaData, int columnNumber) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
    }

    private void parseSQLDOPTGRP(ColumnMetaData columnMetaData, int columnNumber) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        short sqlunnamed = this.readFastShort();
        String name = this.parseFastVCMorVCS();
        String label = this.parseFastVCMorVCS();
        String colComments = this.parseFastVCMorVCS();
        if (columnMetaData.sqlName_ == null) {
            columnMetaData.sqlName_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlLabel_ == null) {
            columnMetaData.sqlLabel_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlUnnamed_ == null) {
            columnMetaData.sqlUnnamed_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlComment_ == null) {
            columnMetaData.sqlComment_ = new String[columnMetaData.columns_];
        }
        columnMetaData.sqlName_[columnNumber] = name;
        columnMetaData.sqlLabel_[columnNumber] = label;
        columnMetaData.sqlUnnamed_[columnNumber] = sqlunnamed;
        columnMetaData.sqlComment_[columnNumber] = colComments;
        this.parseSQLUDTGRP(columnMetaData, columnNumber);
        this.parseSQLDXGRP(columnMetaData, columnNumber);
    }

    private void parseSQLDXGRP(ColumnMetaData columnMetaData, int column) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        short sqlxkeymem = this.readFastShort();
        short sqlxupdateable = this.readFastShort();
        short sqlxgenerated = this.readFastShort();
        short sqlxparmmode = this.readFastShort();
        String sqlxrdbnam = this.parseFastVCS();
        String sqlxcorname = this.parseFastVCMorVCS();
        String sqlxbasename = this.parseFastVCMorVCS();
        String sqlxschema = this.parseFastVCMorVCS();
        String sqlxname = this.parseFastVCMorVCS();
        if (columnMetaData.sqlxKeymem_ == null) {
            columnMetaData.sqlxKeymem_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxGenerated_ == null) {
            columnMetaData.sqlxGenerated_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxParmmode_ == null) {
            columnMetaData.sqlxParmmode_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxCorname_ == null) {
            columnMetaData.sqlxCorname_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxName_ == null) {
            columnMetaData.sqlxName_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxBasename_ == null) {
            columnMetaData.sqlxBasename_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxUpdatable_ == null) {
            columnMetaData.sqlxUpdatable_ = new int[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxSchema_ == null) {
            columnMetaData.sqlxSchema_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxRdbnam_ == null) {
            columnMetaData.sqlxRdbnam_ = new String[columnMetaData.columns_];
        }
        columnMetaData.sqlxKeymem_[column] = sqlxkeymem;
        columnMetaData.sqlxGenerated_[column] = sqlxgenerated;
        columnMetaData.sqlxParmmode_[column] = sqlxparmmode;
        columnMetaData.sqlxCorname_[column] = sqlxcorname;
        columnMetaData.sqlxName_[column] = sqlxname;
        columnMetaData.sqlxBasename_[column] = sqlxbasename;
        columnMetaData.sqlxUpdatable_[column] = sqlxupdateable;
        columnMetaData.sqlxSchema_[column] = sqlxschema == null ? columnMetaData.sqldSchema_ : sqlxschema;
        columnMetaData.sqlxRdbnam_[column] = sqlxrdbnam == null ? columnMetaData.sqldRdbnam_ : sqlxrdbnam;
    }

    private void parseSQLDHGRP(ColumnMetaData columnMetaData) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        short sqldhold = this.readFastShort();
        short sqldreturn = this.readFastShort();
        short sqldscroll = this.readFastShort();
        short sqldsensitive = this.readFastShort();
        short sqldfcode = this.readFastShort();
        short sqldkeytype = this.readFastShort();
        String sqldrdbnam = this.parseFastVCS();
        String sqldschema = this.parseFastVCMorVCS();
        columnMetaData.sqldHold_ = sqldhold;
        columnMetaData.sqldReturn_ = sqldreturn;
        columnMetaData.sqldScroll_ = sqldscroll;
        columnMetaData.sqldSensitive_ = sqldsensitive;
        columnMetaData.sqldFcode_ = sqldfcode;
        columnMetaData.sqldKeytype_ = sqldkeytype;
        columnMetaData.sqldRdbnam_ = sqldrdbnam;
        columnMetaData.sqldSchema_ = sqldschema;
    }

    private void parseSQLRSGRP(Section section) throws DisconnectException {
        int rsLocator = this.readInt();
        String rsName = this.parseVCMorVCS();
        int rsNumRows = this.readInt();
        section.setCursorName(rsName);
    }

    private String parseFastVCMorVCS() throws DisconnectException {
        String stringToBeSet = null;
        int vcm_length = this.readFastUnsignedShort();
        if (vcm_length > 0) {
            stringToBeSet = this.readFastString(vcm_length, this.netAgent_.targetTypdef_.getCcsidMbcEncoding());
        }
        int vcs_length = this.readFastUnsignedShort();
        if (vcm_length > 0 && vcs_length > 0) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.10")));
        } else if (vcs_length > 0) {
            stringToBeSet = this.readFastString(vcs_length, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        }
        return stringToBeSet;
    }

    private String parseVCMorVCS() throws DisconnectException {
        String stringToBeSet = null;
        int vcm_length = this.readUnsignedShort();
        if (vcm_length > 0) {
            stringToBeSet = this.readString(vcm_length, this.netAgent_.targetTypdef_.getCcsidMbcEncoding());
        }
        int vcs_length = this.readUnsignedShort();
        if (vcm_length > 0 && vcs_length > 0) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.10")));
        } else if (vcs_length > 0) {
            stringToBeSet = this.readString(vcs_length, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        }
        return stringToBeSet;
    }

    private int calculateResultSetType(int qryattscr, int qryattsns, int defaultType) {
        if (qryattscr == 240) {
            return 1003;
        }
        switch (qryattsns) {
            case 1: {
                return 1004;
            }
        }
        return defaultType;
    }

    private int calculateResultSetConcurrency(int qryattupd, int defaultConcurrency) {
        switch (qryattupd) {
            case 1: {
                return 1007;
            }
            case 4: {
                return 1008;
            }
        }
        return defaultConcurrency;
    }

    private int calculateResultSetHoldability(int sqlcsrhld) {
        if (sqlcsrhld == 240) {
            return 2;
        }
        return 1;
    }

    private int parseSQLDTAGRPdataLabelsAndUpdateColumn(NetCursor cursor, int columnIndex, int tripletLength) throws DisconnectException {
        int numColumns = (tripletLength - 3) / 3;
        for (int i = columnIndex; i < columnIndex + numColumns; ++i) {
            cursor.qrydscTypdef_.updateColumn(cursor, i, this.readFastUnsignedByte(), this.readFastUnsignedShort());
        }
        return numColumns;
    }

    private String parseSQLSTT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9236);
        return this.parseSQLSTTGRP();
    }

    private String parseSQLSTTGRP() throws DisconnectException {
        int mixedNullInd = this.readUnsignedByte();
        int singleNullInd = 0;
        String sqlsttString = null;
        int stringLength = 0;
        if (mixedNullInd == 255) {
            singleNullInd = this.readUnsignedByte();
            if (singleNullInd == 255) {
                this.doDtamchrmSemantics();
            }
            stringLength = this.readInt();
            sqlsttString = this.readString(stringLength, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        } else {
            stringLength = this.readInt();
            sqlsttString = this.readString(stringLength, this.netAgent_.targetTypdef_.getCcsidMbcEncoding());
            singleNullInd = this.readUnsignedByte();
        }
        return sqlsttString;
    }

    public void readSetSpecialRegister(StatementCallbackInterface statement) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseEXCSQLSETreply(statement);
        this.endOfSameIdChainData();
    }
}

